/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.udteditor.action;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUserDefinedType;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.udteditor.model.ASAUserDefinedTypeObjectEditModel;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.udteditor.model.ASAUserDefinedTypeObjectImmutableModel;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.action.EditSchemaObjectAction;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;

public class ASAUserDefinedTypeEditAction
extends EditSchemaObjectAction {
    protected SybaseASABaseUserDefinedType _udd;
    private static final String EDIT = "&View";
    private static final String ObjectTypeID = "org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUserDefinedType";
    private static final String VENDOR_ASA = "Sybase_ASA";
    private static final String VENDOR_ASIQ = "Sybase_IQ";
    private static final String VERSION = "x";
    private static final String MONITOR_OPENING = "Opening user defined type editor...";
    private static final String MONITOR_LONDING_INFO = "Reading objects from database";
    private static final String MONITOR_INITIALIZING = "Initializing editor";

    public ASAUserDefinedTypeEditAction() {
        this.setText(EDIT);
    }

    public ASAUserDefinedTypeEditAction(SybaseASABaseUserDefinedType udd) {
        this.setSQLObject((SQLObject)udd);
        this.setText(EDIT);
    }

    private void init() {
        if (this.getSQLObject() != null && this.getSQLObject() instanceof SybaseASABaseUserDefinedType) {
            this._udd = (SybaseASABaseUserDefinedType)this.getSQLObject();
            String uddVendor = this._udd.getSchema().getCatalog().getDatabase().getVendor();
            if (uddVendor != null && uddVendor.indexOf("ASA") > 0) {
                this.setVendorName(VENDOR_ASA);
            } else {
                this.setVendorName(VENDOR_ASIQ);
            }
            this.setVersion(VERSION);
            this.setObjectTypeId(ObjectTypeID);
        }
    }

    public void run(IProgressMonitor monitor) {
        ConnectionInfo connInfo;
        this.init();
        monitor.beginTask(MONITOR_OPENING, -1);
        monitor.subTask(MONITOR_LONDING_INFO);
        Database db = ModelUtil.getDatabase((Schema)this._udd.getSchema());
        if (db != null && (connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(db)) instanceof ConnectionInfoImpl) {
            IConnectionProfile cp = ((ConnectionInfoImpl)connInfo).getConnectionProfile();
            DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(cp.getName(), ModelUtil.getDatabaseName((EObject)this._udd));
            this.setDatabaseIdentifier(databaseIdentifier);
        }
        ASAUserDefinedTypeObjectImmutableModel imodel = new ASAUserDefinedTypeObjectImmutableModel((SQLObject)this._udd, new HashMap());
        ASAUserDefinedTypeObjectEditModel emodel = new ASAUserDefinedTypeObjectEditModel((ISchemaObjectImmutableModel)imodel, this.getDatabaseIdentifier());
        this.setModelObj((ISchemaObjectEditModel)emodel);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(MONITOR_INITIALIZING);
        ExamplePlugin.getStandardDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ASAUserDefinedTypeEditAction.this.checkAndOpenEditor();
                ISchemaObjectEditModel obj = (ISchemaObjectEditModel)ASAUserDefinedTypeEditAction.this.getModelObj();
                IEditorPart part = ASAUserDefinedTypeEditAction.this.getPart();
                if (part != null) {
                    ((ISchemaObjectEditor)part).setEditorPartName(obj.getMainSQLObject().getName());
                }
                ASAUserDefinedTypeEditAction.this.setActivePage();
            }
        });
        monitor.done();
    }
}

