/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MathException;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.MathUtils;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.parser.node.StandardParserVisitor;
import org.apache.velocity.util.DuckType;

public class ASTNegateNode
extends SimpleNode {
    protected boolean strictMode = false;

    public ASTNegateNode(int i) {
        super(i);
    }

    public ASTNegateNode(Parser p, int i) {
        super(p, i);
    }

    @Override
    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        super.init(context, data);
        this.strictMode = this.rsvc.getBoolean("runtime.strict_math", false);
        this.cleanupParserAndTokens();
        return data;
    }

    @Override
    public Object jjtAccept(StandardParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(InternalContextAdapter context) throws MethodInvocationException {
        return this.jjtGetChild(0).evaluate(context);
    }

    @Override
    public Object value(InternalContextAdapter context) throws MethodInvocationException {
        Object value = this.jjtGetChild(0).value(context);
        try {
            value = DuckType.asNumber(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!(value instanceof Number)) {
            String msg = "Argument of unary negate (" + this.jjtGetChild(0).literal() + ") " + (value == null ? "has a null value." : "is not a Number.");
            if (this.strictMode) {
                this.log.error(msg);
                throw new MathException(msg, this.rsvc.getLogContext().getStackTrace());
            }
            this.log.debug(msg);
            return null;
        }
        return MathUtils.negate((Number)value);
    }

    @Override
    public String literal() {
        return "-" + this.jjtGetChild(0).literal();
    }
}

