/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.EclipseProjectConfigurator;
import org.eclipse.ui.internal.wizards.datatransfer.expressions.FileExpressionHandler;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.osgi.framework.Bundle;

public class ProjectConfiguratorExtensionManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.ide.projectConfigurators";
    private final IConfigurationElement[] extensions;
    private final ExpressionConverter expressionConverter;
    private final Map<IConfigurationElement, ProjectConfigurator> configuratorsByExtension = new HashMap<IConfigurationElement, ProjectConfigurator>();

    public ProjectConfiguratorExtensionManager() {
        this.extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int eclipseConfiguratorIndex = 0;
        while (eclipseConfiguratorIndex < this.extensions.length && !this.extensions[eclipseConfiguratorIndex].getAttribute("class").equals(EclipseProjectConfigurator.class.getName())) {
            ++eclipseConfiguratorIndex;
        }
        if (eclipseConfiguratorIndex != 0 && eclipseConfiguratorIndex < this.extensions.length) {
            IConfigurationElement tmp = this.extensions[eclipseConfiguratorIndex];
            this.extensions[eclipseConfiguratorIndex] = this.extensions[0];
            this.extensions[0] = tmp;
        }
        this.expressionConverter = new ExpressionConverter(new ElementHandler[]{ElementHandler.getDefault(), new FileExpressionHandler()});
    }

    private List<ProjectConfigurator> getAllActiveProjectConfiguratorsUntyped(Object container) {
        ArrayList<ProjectConfigurator> res = new ArrayList<ProjectConfigurator>();
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            boolean addIt = false;
            String bundleOrFragmentId = extension.getContributor().getName();
            Bundle contributingBundle = Platform.getBundle((String)bundleOrFragmentId);
            if (contributingBundle.getState() == 32) {
                addIt = true;
            } else {
                IConfigurationElement[] activeWhenElements = extension.getChildren("activeWhen");
                switch (activeWhenElements.length) {
                    case 0: {
                        addIt = true;
                        break;
                    }
                    case 1: {
                        IConfigurationElement activeWhen = activeWhenElements[0];
                        IConfigurationElement[] activeWhenChildren = activeWhen.getChildren();
                        if (activeWhenChildren.length == 1) {
                            try {
                                Expression expression = this.expressionConverter.perform(activeWhen.getChildren()[0]);
                                EvaluationContext context = new EvaluationContext(null, container);
                                addIt = expression.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
                            }
                            catch (CoreException ex) {
                                IDEWorkbenchPlugin.log("Could not evaluate expression for " + extension.getContributor().getName(), ex);
                            }
                            break;
                        }
                        IDEWorkbenchPlugin.log("Could not evaluate xpression for " + extension.getContributor().getName() + ": there must be exactly one child of 'activeWhen'");
                        break;
                    }
                    default: {
                        IDEWorkbenchPlugin.log("Only one 'activeWhen' is authorized on extension point org.eclipse.ui.ide.projectConfigurators, for extension contributed by " + extension.getContributor().getName());
                    }
                }
            }
            if (addIt) {
                ProjectConfigurator configurator = this.getConfigurator(extension);
                if (configurator instanceof EclipseProjectConfigurator) {
                    res.add(0, configurator);
                } else {
                    res.add(configurator);
                }
            }
            ++n2;
        }
        return res;
    }

    public List<ProjectConfigurator> getAllActiveProjectConfigurators(IContainer container) {
        return this.getAllActiveProjectConfiguratorsUntyped(container);
    }

    public List<ProjectConfigurator> getAllActiveProjectConfigurators(File folder) {
        Assert.isTrue((boolean)folder.isDirectory(), (String)folder.getAbsolutePath());
        return this.getAllActiveProjectConfiguratorsUntyped(folder);
    }

    private ProjectConfigurator getConfigurator(IConfigurationElement extension) {
        if (!this.configuratorsByExtension.containsKey(extension)) {
            try {
                ProjectConfigurator configurator = (ProjectConfigurator)extension.createExecutableExtension("class");
                this.configuratorsByExtension.put(extension, configurator);
                return configurator;
            }
            catch (CoreException ex) {
                IDEWorkbenchPlugin.log(ex.getMessage(), ex);
                return null;
            }
        }
        return this.configuratorsByExtension.get(extension);
    }

    public static List<String> getAllExtensionLabels() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        ArrayList<String> res = new ArrayList<String>(extensions.length);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            res.add(extension.getAttribute("label"));
            ++n2;
        }
        return res;
    }

    public static String getLabel(ProjectConfigurator configurator) {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (configurator.getClass().getName().equals(extension.getAttribute("class"))) {
                return extension.getAttribute("label");
            }
            ++n2;
        }
        return "Missing label for " + configurator.getClass().getName();
    }
}

