/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.taginfo;

import java.io.Reader;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.ui.internal.taginfo.JavaWordFinder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.taginfo.AbstractHoverProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPJavaJavadocHoverProcessor
extends AbstractHoverProcessor {
    private final long LABEL_FLAGS = 283710660642007L;
    private final long LOCAL_VARIABLE_FLAGS = 283710660707543L;

    protected String getHoverInfo(IJavaElement[] result) {
        StringBuilder builder = new StringBuilder();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList((StringBuilder)builder);
                IJavaElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet((StringBuilder)builder, (String)this.getInfoText(curr));
                }
                HTMLPrinter.endBulletList((StringBuilder)builder);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                Reader reader;
                IMember member = (IMember)curr;
                HTMLPrinter.addSmallHeader((StringBuilder)builder, (String)this.getInfoText((IJavaElement)member));
                try {
                    reader = JavadocContentAccess.getHTMLContentReader((IMember)member, (boolean)true, (boolean)true);
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuilder)builder, (Reader)reader);
                }
            } else if (curr.getElementType() == 14 || curr.getElementType() == 15) {
                HTMLPrinter.addSmallHeader((StringBuilder)builder, (String)this.getInfoText(curr));
            }
        }
        if (builder.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuilder)builder, (int)0);
            HTMLPrinter.addPageEpilog((StringBuilder)builder);
            return builder.toString();
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDOMModel xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(textViewer.getDocument());
        try {
            IDOMDocument xmlDoc;
            JSPTranslationAdapter adapter;
            if (xmlModel != null && (adapter = (JSPTranslationAdapter)(xmlDoc = xmlModel.getDocument()).getAdapterFor(IJSPTranslation.class)) != null) {
                JSPTranslationExtension translation = adapter.getJSPTranslation();
                IJavaElement[] result = translation.getElementsFromJspRange(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength());
                String string = translation.fixupMangledName(this.getHoverInfo(result));
                return string;
            }
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromRead();
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    private String getInfoText(IJavaElement member) {
        long flags = member.getElementType() == 14 ? 283710660707543L : 283710660642007L;
        String label = JavaElementLabels.getElementLabel((IJavaElement)member, (long)flags);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

