/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentoutline;

import java.util.List;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeShowingLabelProvider
extends JFaceNodeLabelProvider {
    boolean fShowAttributes = false;
    static final String ATTR_NAME = "name";
    static final String ATTR_ID = "id";

    public AttributeShowingLabelProvider(boolean showAttributes) {
        this.fShowAttributes = showAttributes;
    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    @Override
    public String getText(Object o) {
        StringBuffer text = null;
        if (o instanceof Node) {
            Node node = (Node)o;
            if (node.getNodeType() == 1 && this.fShowAttributes) {
                text = new StringBuffer(super.getText(o));
                if (node.hasAttributes()) {
                    String attributeName;
                    Element element = (Element)node;
                    NamedNodeMap attributes = element.getAttributes();
                    Node idTypedAttribute = null;
                    Node requiredAttribute = null;
                    boolean hasId = false;
                    boolean hasName = false;
                    Node shownAttribute = null;
                    CMElementDeclaration elementDecl = null;
                    ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
                    if (mq != null) {
                        elementDecl = mq.getCMElementDeclaration(element);
                    }
                    if (elementDecl != null) {
                        int i = 0;
                        while (i < attributes.getLength() && idTypedAttribute == null) {
                            Node attr = attributes.item(i);
                            String attrName = attr.getNodeName();
                            CMNamedNodeMap attributeDeclarationMap = elementDecl.getAttributes();
                            CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl(attributeDeclarationMap);
                            List nodes = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument()).getAvailableContent(element, elementDecl, 1);
                            int k = 0;
                            while (k < nodes.size()) {
                                CMNode cmnode = (CMNode)nodes.get(k);
                                if (cmnode.getNodeType() == 2) {
                                    allAttributes.put(cmnode);
                                }
                                ++k;
                            }
                            attributeDeclarationMap = allAttributes;
                            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attributeDeclarationMap.getNamedItem(attrName);
                            if (attrDecl != null) {
                                if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                                    idTypedAttribute = attr;
                                } else if (attrDecl.getUsage() == 2 && requiredAttribute == null) {
                                    requiredAttribute = attr;
                                } else {
                                    hasId = hasId || attrName.equals(ATTR_ID);
                                    hasName = hasName || attrName.equals(ATTR_NAME);
                                }
                            }
                            ++i;
                        }
                    }
                    if (idTypedAttribute != null) {
                        shownAttribute = idTypedAttribute;
                    } else if (requiredAttribute != null) {
                        shownAttribute = requiredAttribute;
                    } else if (hasId) {
                        shownAttribute = attributes.getNamedItem(ATTR_ID);
                    } else if (hasName) {
                        shownAttribute = attributes.getNamedItem(ATTR_NAME);
                    }
                    if (shownAttribute == null) {
                        shownAttribute = attributes.item(0);
                    }
                    if ((attributeName = shownAttribute.getNodeName()) != null && attributeName.length() > 0) {
                        text.append(" ");
                        text.append(attributeName);
                        String attributeValue = shownAttribute.getNodeValue();
                        if (attributeValue != null && attributeValue.length() > 0) {
                            text.append("=");
                            text.append(StringUtils.strip((String)attributeValue));
                        }
                    }
                }
            } else {
                text = new StringBuffer(super.getText(o));
            }
        } else {
            return super.toString();
        }
        return text.toString();
    }

    public String getToolTipText(Object element) {
        if (element instanceof Node) {
            switch (((Node)element).getNodeType()) {
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    String nodeValue = ((Node)element).getNodeValue().trim();
                    return this.prepareText(nodeValue);
                }
                case 1: {
                    Node previous = ((Node)element).getPreviousSibling();
                    Element elem = (Element)element;
                    if (XSLCore.isXSLNamespace((Node)((Node)element)) && elem.hasAttribute("mode")) {
                        return "Mode: " + elem.getAttribute("mode");
                    }
                    if (previous != null && previous.getNodeType() == 3) {
                        previous = previous.getPreviousSibling();
                    }
                    if (previous == null || previous.getNodeType() != 8) break;
                    return this.getToolTipText(previous);
                }
            }
        }
        return super.getToolTipText(element);
    }

    private String prepareText(String text) {
        StringBuffer nodeText = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c != '\r' && c != '\n') {
                nodeText.append(c);
            } else if (c == '\r' || c == '\n') {
                nodeText.append('\n');
                while (Character.isWhitespace(c) && i < text.length()) {
                    c = text.charAt(++i);
                }
                nodeText.append(c);
            }
            ++i;
        }
        return nodeText.toString();
    }

    public void setShowAttributes(boolean fShowAttributes) {
        this.fShowAttributes = fShowAttributes;
    }
}

