/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class ResetAllOperation
extends BuildpathModifierOperation {
    private IBuildpathEntry[] fEntries;

    public ResetAllOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip, 6);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        this.fException = null;
        try {
            this.fInformationProvider.getScriptProject().setRawBuildpath(this.fEntries, monitor);
            this.fInformationProvider.deleteCreatedResources();
            this.fEntries = null;
        }
        catch (CoreException e) {
            this.fException = e;
        }
        super.handleResult(null, monitor);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        IBuildpathEntry[] currentEntries;
        IScriptProject project = this.fInformationProvider.getScriptProject();
        if (project == null) {
            return false;
        }
        if (this.fEntries == null) {
            this.fEntries = project.getRawBuildpath();
        }
        if ((currentEntries = project.getRawBuildpath()).length != this.fEntries.length) {
            return true;
        }
        int i = 0;
        while (i < this.fEntries.length) {
            if (!this.fEntries[i].equals(currentEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getDescription(int type) {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAll;
    }
}

