/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchRequestor;

public class CollectingSearchRequestor
extends SearchRequestor {
    private final List<SearchMatch> fFound = new ArrayList<SearchMatch>();
    private final List<SearchMatch> fBinaryRefs;

    public CollectingSearchRequestor() {
        this(false);
    }

    public CollectingSearchRequestor(boolean binaryRefs) {
        this.fBinaryRefs = binaryRefs ? new ArrayList() : null;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (!this.filterMatch(match)) {
            this.collectMatch(match);
        }
    }

    public void collectMatch(SearchMatch match) {
        this.fFound.add(match);
    }

    public boolean filterMatch(SearchMatch match) throws CoreException {
        if (this.fBinaryRefs == null) {
            return false;
        }
        if (match.getAccuracy() == 0 && CollectingSearchRequestor.isBinaryElement(match.getElement())) {
            this.fBinaryRefs.add(match);
            return true;
        }
        return false;
    }

    private static boolean isBinaryElement(Object element) throws ModelException {
        if (element instanceof IMember) {
            return ((IMember)element).getSourceModule().isBinary();
        }
        if (element instanceof ISourceModule) {
            return ((ISourceModule)element).isBinary();
        }
        if (element instanceof IProjectFragment) {
            return ((IProjectFragment)element).isBinary();
        }
        return false;
    }

    public List<SearchMatch> getResults() {
        return this.fFound;
    }
}

