/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentSearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLSearchPattern;
import org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher;
import org.eclipse.wst.xml.core.internal.search.matching.SAXSearchElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSearchPatternMatcher
extends PatternMatcher {
    private SearchParticipant searchParticipant;
    XMLSearchPattern searchPattern;

    public XMLSearchPatternMatcher(SearchParticipant searchParticipant) {
        this.searchParticipant = searchParticipant;
    }

    protected String computeNamespaceForPrefix(Element element, String prefix) {
        String result = null;
        Node node = element;
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element e = node;
                String attributeName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
                String string = result = e.hasAttribute(attributeName) ? e.getAttribute(attributeName) : null;
                if (result != null && result.length() > 0) break;
            }
            node = node.getParentNode();
        }
        return result;
    }

    protected void initialize(XMLSearchPattern pattern, Element domElement) {
        String actualValue;
        pattern.setElementName(domElement.getLocalName());
        pattern.setElementNamespace(domElement.getNamespaceURI());
        String string = actualValue = domElement.hasAttribute(pattern.getAttributeName()) ? domElement.getAttribute(pattern.getAttributeName()) : null;
        if (actualValue != null && actualValue.length() > 0) {
            pattern.setSearchElement(domElement);
            pattern.setSearchName(actualValue);
            pattern.setSearchNamespace(domElement.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace"));
        }
    }

    protected void initialize(XMLSearchPattern pattern, SAXSearchElement saxElement) {
        pattern.setElementName(saxElement.getElementName());
        pattern.setElementNamespace(saxElement.getElementNamespace());
        pattern.setDepth(saxElement.getDepth());
        pattern.setParentName(saxElement.getParentName());
        String actualValue = saxElement.getAttributes().getValue(pattern.getAttributeName());
        if (actualValue != null) {
            pattern.setSearchElement(saxElement);
            pattern.setSearchName(actualValue);
            pattern.setSearchNamespace(saxElement.getTargetNamespace());
        }
    }

    public XMLSearchPatternMatcher() {
    }

    @Override
    public void locateMatches(SearchPattern pattern, IFile file, Element element, SearchRequestor requestor) {
        if (pattern instanceof XMLComponentSearchPattern) {
            XMLSearchPattern[] childPatterns = ((XMLComponentSearchPattern)pattern).getChildren(this.searchParticipant);
            if (childPatterns == null) {
                return;
            }
            int i = 0;
            while (i < childPatterns.length) {
                PatternMatcher matcher = (PatternMatcher)childPatterns[i].getAdapter(PatternMatcher.class);
                if (matcher == null) {
                    matcher = this;
                }
                if (matcher != null) {
                    matcher.locateMatches(childPatterns[i], file, element, requestor);
                }
                ++i;
            }
        } else if (pattern instanceof XMLSearchPattern && this.matches(pattern, element)) {
            Attr attribute = element.getAttributeNode(((XMLSearchPattern)pattern).getAttributeName());
            this.addMatch(pattern, file, attribute, requestor);
        }
    }

    @Override
    public boolean matches(SearchPattern pattern, Object element) {
        if (pattern instanceof XMLComponentSearchPattern) {
            XMLSearchPattern[] childPatterns = ((XMLComponentSearchPattern)pattern).getChildren(this.searchParticipant);
            if (childPatterns == null) {
                return false;
            }
            int i = 0;
            while (i < childPatterns.length) {
                PatternMatcher matcher = (PatternMatcher)childPatterns[i].getAdapter(PatternMatcher.class);
                if (matcher == null) {
                    matcher = this;
                }
                if (matcher != null && matcher.matches(childPatterns[i], element)) {
                    return true;
                }
                ++i;
            }
        } else if (pattern instanceof XMLSearchPattern) {
            XMLSearchPattern possibleMatch = new XMLSearchPattern();
            possibleMatch.setAttributeName(((XMLSearchPattern)pattern).getAttributeName());
            if (element instanceof Element) {
                this.initialize(possibleMatch, (Element)element);
            } else if (element instanceof SAXSearchElement) {
                this.initialize(possibleMatch, (SAXSearchElement)element);
            }
            this.searchPattern = (XMLSearchPattern)pattern;
            return this.matchesPattern(possibleMatch);
        }
        return false;
    }

    protected boolean matchesPattern(SearchPattern pattern) {
        if (this.searchPattern != null && pattern instanceof XMLSearchPattern) {
            XMLSearchPattern decodedPattern = (XMLSearchPattern)pattern;
            if (this.searchPattern.getElementName().equals(decodedPattern.getElementName()) && this.searchPattern.getElementNamespace().equals(decodedPattern.getElementNamespace())) {
                if (this.searchPattern.getParentName() != null && decodedPattern.getParentName() != null && !this.searchPattern.getParentName().equals(decodedPattern.getParentName())) {
                    return false;
                }
                return this.searchPattern.matches(decodedPattern);
            }
        }
        return false;
    }

    @Override
    protected SearchMatch createSearchMatch(IFile file, Attr attributeNode) {
        SearchMatch match = super.createSearchMatch(file, attributeNode);
        if ("name".equals(attributeNode.getName())) {
            QualifiedName qualifiedName = new QualifiedName("todo-compute-targetNamespace", attributeNode.getValue());
            match.map.put("name", qualifiedName);
        }
        return match;
    }
}

