/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapReference;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeOwner;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class ColumnMap
extends IdObjectTypeMap {
    private final FinalValue<Optional<IES6Class>> m_tableClass = new FinalValue();
    private final FinalValue<Optional<IES6Class>> m_columnClass = new FinalValue();

    protected ColumnMap(String name, IObjectLiteral model, Collection<String> usedNames) {
        super(name, model, usedNames);
    }

    public static Optional<ColumnMap> create(String tableOrModelName, IObjectLiteral tableModel, Collection<String> usedNames) {
        if (tableOrModelName == null || tableModel == null) {
            return Optional.empty();
        }
        return Optional.of(tableOrModelName).map(n -> Strings.removeSuffix((String)n, (CharSequence)"Model")).map(n -> n + "ColumnMap").map(n -> new ColumnMap((String)n, tableModel, usedNames));
    }

    protected Optional<IES6Class> tableClass() {
        return (Optional)this.m_tableClass.computeIfAbsentAndGet(() -> this.classByObjectType("Table"));
    }

    protected Optional<IES6Class> columnClass() {
        return (Optional)this.m_columnClass.computeIfAbsentAndGet(() -> this.classByObjectType("Column"));
    }

    @Override
    protected Map<String, IdObjectType> parseElements() {
        IES6Class columnClass = this.columnClass().orElse(null);
        if (columnClass == null) {
            return Collections.emptyMap();
        }
        return this.model().property("columns").flatMap(IConstantValue::asArray).stream().flatMap(Stream::of).filter(cv -> cv.type() == IConstantValue.ConstantValueType.ObjectLiteral).flatMap(cv -> cv.asObjectLiteral().stream()).map(ol -> IdObjectType.create(ol, this.usedNames(), this.scoutJsModel().orElse(null))).flatMap(Optional::stream).filter(idObjectType -> idObjectType.objectType().isInstanceOf(columnClass)).collect(Collectors.toMap(IdObjectType::id, Function.identity(), (a, b) -> {
            this.createDuplicateIdWarning(a.id());
            return b;
        }, LinkedHashMap::new));
    }

    @Override
    protected Set<IdObjectTypeMapReference> parseIdObjectTypeMapReferences() {
        IES6Class tableClass = this.tableClass().orElse(null);
        return this.model().property("objectType").flatMap(IConstantValue::asES6Class).filter(es6Class -> es6Class != tableClass).flatMap(es6Class -> es6Class.field("columnMap")).flatMap(IDataTypeOwner::dataType).filter(IES6Class.class::isInstance).map(IES6Class.class::cast).flatMap(IdObjectTypeMapReference::create).stream().collect(Collectors.toSet());
    }
}

