/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;

public class TypeSynonymsPattern
extends JavaSearchPattern {
    private static final char[] SEARCH_PATTERN_PREFIX = new char[]{'*', '/'};
    private static final char[] SEARCH_PATTERN_SUFFIX = new char[]{'/', '*'};
    private static char[][] CATEGORIES = new char[][]{TYPE_SYNONYMS};
    private final char[] fSearchTypeName;
    private char[][] fSynonyms;

    public TypeSynonymsPattern(char[] searchTypeName) {
        super(1024, 2);
        this.fSearchTypeName = searchTypeName;
    }

    private TypeSynonymsPattern() {
        this(null);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        if (key != null && key.length > 2) {
            this.fSynonyms = CharOperation.splitOn('/', key, 1, key.length - 1);
        }
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new TypeSynonymsPattern();
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public char[][] getSynonyms() {
        return this.fSynonyms;
    }

    @Override
    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = CharOperation.concat(SEARCH_PATTERN_PREFIX, this.fSearchTypeName, SEARCH_PATTERN_SUFFIX);
        if (!this.isCaseSensitive) {
            key = CharOperation.toLowerCase(key);
        }
        return index.query(this.getIndexCategories(), key, this.getMatchRule());
    }

    public static char[] createIndexKey(char[] type, char[][] synonymTypes) {
        char[] key = null;
        if (type != null && type.length > 0 && synonymTypes != null && synonymTypes.length > 0) {
            key = CharOperation.concat(type, CharOperation.concatWith(synonymTypes, '/', true), '/');
            key = CharOperation.concat('/', key, '/');
        }
        return key;
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.fSearchTypeName != null) {
            output.append("SearchTypeName: ");
            output.append(this.fSearchTypeName);
            output.append("\n");
        }
        if (this.fSynonyms != null) {
            output.append("Synonyms: ");
            int i = 0;
            while (i < this.fSynonyms.length) {
                output.append(this.fSynonyms[i]);
                output.append(", ");
                ++i;
            }
        }
        return super.print(output);
    }
}

