/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.FieldCleanupPass;
import com.google.javascript.jscomp.GlobalVarReferenceMap;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.List;

class CleanupPasses
extends PassConfig {
    private PassConfig.State state;
    final PassFactory fieldCleanupPassFactory = new PassFactory.HotSwapPassFactory("FieldCleaupPassFactory", false){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new FieldCleanupPass(compiler);
        }
    };
    final PassFactory scopeCleanupPassFactory = new PassFactory.HotSwapPassFactory("ScopeCleanupPassFactory", false){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new MemoizedScopeCleanupPass(compiler);
        }
    };
    final PassFactory globalVarRefCleanupPassFactory = new PassFactory.HotSwapPassFactory("GlobalVarRefCleanupPassFactory", false){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GlobalVarReferenceMap.GlobalVarRefCleanupPass(compiler);
        }
    };

    public CleanupPasses(CompilerOptions options) {
        super(options);
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = new ArrayList<PassFactory>();
        checks.add(this.fieldCleanupPassFactory);
        checks.add(this.scopeCleanupPassFactory);
        checks.add(this.globalVarRefCleanupPassFactory);
        return checks;
    }

    @Override
    protected PassConfig.State getIntermediateState() {
        return this.state;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }

    static class MemoizedScopeCleanupPass
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        public MemoizedScopeCleanupPass(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            ScopeCreator creator = this.compiler.getTypedScopeCreator();
            if (creator instanceof MemoizedScopeCreator) {
                MemoizedScopeCreator scopeCreator = (MemoizedScopeCreator)creator;
                String newSrc = scriptRoot.getSourceFileName();
                for (TypedVar var : scopeCreator.getAllSymbols()) {
                    FunctionTypeI fnType;
                    JSType type = var.getType();
                    if (type == null || (fnType = type.toMaybeFunctionType()) == null || !newSrc.equals(NodeUtil.getSourceName(fnType.getSource()))) continue;
                    fnType.setSource(null);
                }
                scopeCreator.removeScopesForScript(originalRoot.getSourceFileName());
            }
        }

        @Override
        public void process(Node externs, Node root) {
        }
    }
}

