/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Version {
    private static final String SEPARATOR = ".";
    private String[] version;

    public Version(String s) {
        StringTokenizer st = new StringTokenizer(s, SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            int size = str.length();
            int i = 0;
            while (i < size) {
                if (!Character.isLetterOrDigit(str.charAt(i))) {
                    throw new NumberFormatException("Version strings cannot contain '" + str.charAt(i) + "'");
                }
                ++i;
            }
            list.add(str);
        }
        this.version = new String[list.size()];
        list.toArray(this.version);
    }

    public static Version parseVersion(String s) {
        return new Version(s);
    }

    public static int compare(Version v1, Version v2) {
        int v1l = v1.version.length;
        int v2l = v2.version.length;
        int size = Math.min(v1l, v2l);
        int i = 0;
        while (i < size) {
            try {
                double d1 = Double.parseDouble(v1.version[i]);
                double d2 = Double.parseDouble(v2.version[i]);
                int c = Double.compare(d1, d2);
                if (c != 0) {
                    return c;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            int c = v1.version[i].compareTo(v2.version[i]);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        if (v1l == v2l) {
            return 0;
        }
        if (v1l > v2l) {
            return 1;
        }
        return -1;
    }
}

