/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

public class MavenProjectMutableState {
    private static final String CTX_SNAPSHOT = MavenProjectMutableState.class.getName() + "/SNAPSHOT";
    private List<String> compileSourceRoots;
    private List<String> testCompileSourceRoots;
    private List<Resource> resources;
    private List<Resource> testResources;
    private Properties properties;
    private boolean nested = true;

    private MavenProjectMutableState() {
    }

    public static MavenProjectMutableState takeSnapshot(MavenProject project) {
        MavenProjectMutableState snapshot = new MavenProjectMutableState();
        if (project.getContextValue(CTX_SNAPSHOT) == null) {
            snapshot.compileSourceRoots = new ArrayList<String>(project.getCompileSourceRoots());
            snapshot.testCompileSourceRoots = new ArrayList<String>(project.getTestCompileSourceRoots());
            snapshot.resources = new ArrayList<Resource>(project.getResources());
            snapshot.testResources = new ArrayList<Resource>(project.getTestResources());
            snapshot.properties = new Properties();
            snapshot.properties.putAll((Map<?, ?>)project.getProperties());
            project.setContextValue(CTX_SNAPSHOT, (Object)Boolean.TRUE);
            snapshot.nested = false;
        }
        return snapshot;
    }

    public void restore(MavenProject project) {
        if (this.nested) {
            return;
        }
        this.setElements(project.getCompileSourceRoots(), this.compileSourceRoots);
        this.setElements(project.getTestCompileSourceRoots(), this.testCompileSourceRoots);
        this.setElements(project.getResources(), this.resources);
        this.setElements(project.getTestResources(), this.testResources);
        if (this.properties != null) {
            try {
                project.getProperties().clear();
                project.getProperties().putAll((Map<?, ?>)this.properties);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        project.setContextValue(CTX_SNAPSHOT, null);
    }

    private <T> void setElements(List<T> collection, List<T> elements) {
        try {
            if (elements != null) {
                collection.clear();
                collection.addAll(elements);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

