/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.generator.type;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.sdk.core.typescript.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.INodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class SortedNodeElementEntry
implements Comparable<SortedNodeElementEntry> {
    public static final int DEFAULT_ORDER = 20;
    public static final int FIELD_ORDER = 100000;
    private static final AtomicLong INPUT_ORDER = new AtomicLong();
    private final INodeElementGenerator<?> m_generator;
    private final FinalValue<CompositeObject> m_sortOrder;
    private final long m_index;

    public SortedNodeElementEntry(INodeElementGenerator<?> generator) {
        this(generator, null);
    }

    public SortedNodeElementEntry(INodeElementGenerator<?> generator, Object ... sortOrder) {
        this.m_generator = (INodeElementGenerator)Ensure.notNull(generator);
        this.m_sortOrder = new FinalValue();
        if (sortOrder != null && sortOrder.length > 0) {
            this.m_sortOrder.set((Object)new CompositeObject(sortOrder));
            this.m_index = 0L;
        } else {
            this.m_index = INPUT_ORDER.getAndIncrement();
        }
    }

    public INodeElementGenerator<?> generator() {
        return this.m_generator;
    }

    public CompositeObject sortOrder() {
        return (CompositeObject)this.m_sortOrder.computeIfAbsentAndGet(this::calculateDefaultOrder);
    }

    protected CompositeObject calculateDefaultOrder() {
        INodeElementGenerator<?> generator = this.generator();
        if (this.isField()) {
            return SortedNodeElementEntry.defaultFieldOrder((IFieldGenerator)generator, this.m_index);
        }
        return new CompositeObject(new Object[0]);
    }

    public boolean isField() {
        return this.hasType(IFieldGenerator.class);
    }

    public boolean hasType(Class<?> type) {
        return type.isAssignableFrom(this.generator().getClass());
    }

    @Override
    public int compareTo(SortedNodeElementEntry o) {
        return this.sortOrder().compareTo(o.sortOrder());
    }

    public int hashCode() {
        return this.sortOrder().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SortedNodeElementEntry other = (SortedNodeElementEntry)obj;
        return this.sortOrder().equals((Object)other.sortOrder());
    }

    protected static CompositeObject defaultFieldOrder(IFieldGenerator<?> generator, long insertionOrder) {
        Collection<Modifier> modifiers = generator.modifiers();
        boolean isDeclare = modifiers.contains((Object)Modifier.DECLARE);
        int pos = isDeclare ? 1000 : 2000;
        return new CompositeObject(new Object[]{20, 100000, pos, insertionOrder});
    }

    public static Object[] createDefaultFieldPos(Object ... order) {
        return SortedNodeElementEntry.combine(100000, order);
    }

    static Object[] combine(int objectOrder, Object ... orders) {
        if (orders == null || orders.length < 1) {
            return new Object[]{20, objectOrder};
        }
        Object[] result = new Object[orders.length + 2];
        result[0] = 20;
        result[1] = objectOrder;
        System.arraycopy(orders, 0, result, 2, orders.length);
        return result;
    }
}

