/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CommentStrategy;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvCallbackHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvParseException;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvParser;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Nullable;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Preconditions;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Util;

final class RelaxedCsvParser
implements CsvParser {
    private static final char SPACE = ' ';
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final char fsep;
    @Nullable
    private final char[] fsepRemainder;
    private final char qChar;
    private final CommentStrategy cStrat;
    private final char cChar;
    private final boolean trimWhitespacesAroundQuotes;
    private final CsvCallbackHandler<?> callbackHandler;
    private final int maxBufferSize;
    private final LookaheadReader reader;
    private long startingLineNumber;
    private char[] currentField;
    private int currentFieldIndex;
    private int lines = 1;

    RelaxedCsvParser(String fsep, char qChar, CommentStrategy cStrat, char cChar, boolean trimWhitespacesAroundQuotes, CsvCallbackHandler<?> callbackHandler, int maxBufferSize, Reader reader) {
        RelaxedCsvParser.assertFields(fsep, qChar, cChar, cStrat);
        this.fsep = fsep.charAt(0);
        this.fsepRemainder = RelaxedCsvParser.extractFsepRemainder(fsep);
        this.qChar = qChar;
        this.cStrat = cStrat;
        this.cChar = cChar;
        this.trimWhitespacesAroundQuotes = trimWhitespacesAroundQuotes;
        this.callbackHandler = callbackHandler;
        this.maxBufferSize = maxBufferSize;
        this.reader = new LookaheadReader(reader, 8192);
        this.currentField = new char[Math.min(maxBufferSize, 8192)];
    }

    RelaxedCsvParser(String fsep, char qChar, CommentStrategy cStrat, char cChar, boolean trimWhitespacesAroundQuotes, CsvCallbackHandler<?> callbackHandler, int maxBufferSize, String data) {
        RelaxedCsvParser.assertFields(fsep, qChar, cChar, cStrat);
        this.fsep = fsep.charAt(0);
        this.fsepRemainder = RelaxedCsvParser.extractFsepRemainder(fsep);
        this.qChar = qChar;
        this.cStrat = cStrat;
        this.cChar = cChar;
        this.trimWhitespacesAroundQuotes = trimWhitespacesAroundQuotes;
        this.callbackHandler = callbackHandler;
        this.maxBufferSize = maxBufferSize;
        this.reader = new LookaheadReader(new StringReader(data), Math.max(data.length(), 1));
        this.currentField = new char[Math.min(maxBufferSize, data.length())];
    }

    private static void assertFields(String fieldSeparator, char quoteCharacter, char commentCharacter, CommentStrategy commentStrategy) {
        Preconditions.checkArgument(!Util.containsNewline(fieldSeparator), "fieldSeparator must not contain newline chars");
        Preconditions.checkArgument(!Util.isNewline(quoteCharacter), "quoteCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.isNewline(commentCharacter), "commentCharacter must not be a newline char");
        if (commentStrategy == CommentStrategy.NONE) {
            Preconditions.checkArgument(!Util.containsDupe(fieldSeparator.charAt(0), quoteCharacter), "Control characters must differ (fieldSeparator=%s, quoteCharacter=%s)".formatted(Character.valueOf(fieldSeparator.charAt(0)), Character.valueOf(quoteCharacter)));
        } else {
            Preconditions.checkArgument(!Util.containsDupe(fieldSeparator.charAt(0), quoteCharacter, commentCharacter), "Control characters must differ (fieldSeparator=%s, quoteCharacter=%s, commentCharacter=%s)".formatted(Character.valueOf(fieldSeparator.charAt(0)), Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter)));
        }
    }

    @Nullable
    private static char[] extractFsepRemainder(String fsep) {
        if (fsep.length() <= 1) {
            return null;
        }
        char[] fsepRemainder = new char[fsep.length() - 1];
        fsep.getChars(1, fsep.length(), fsepRemainder, 0);
        return fsepRemainder;
    }

    @Override
    public boolean parse() throws IOException {
        this.startingLineNumber += (long)this.lines;
        this.lines = 1;
        this.callbackHandler.beginRecord(this.startingLineNumber);
        int ch = this.reader.read();
        if (ch == -1) {
            return false;
        }
        if (ch == 13) {
            this.reader.consumeLF();
            this.callbackHandler.setEmpty();
            return true;
        }
        if (ch == 10) {
            this.callbackHandler.setEmpty();
            return true;
        }
        if (ch == this.cChar && this.cStrat != CommentStrategy.NONE) {
            this.parseComment();
            return true;
        }
        do {
            if (!(ch == this.qChar ? this.parseQuoted() : this.parseUnquoted(ch))) continue;
            return true;
        } while ((ch = this.reader.read()) != -1);
        this.callbackHandler.addField(this.currentField, 0, this.currentFieldIndex, false);
        this.currentFieldIndex = 0;
        return true;
    }

    private boolean parseUnquoted(int ch) throws IOException {
        boolean endOfRecord = true;
        while (true) {
            if (this.currentFieldIndex < this.currentField.length && this.reader.len > this.reader.start && ch != 13 && ch != 10 && ch != this.fsep && ch != this.qChar) {
                this.currentField[this.currentFieldIndex++] = (char)ch;
                ch = this.reader.buffer[this.reader.start++];
                continue;
            }
            if (ch == this.fsep && (this.fsepRemainder == null || this.reader.consumeIf(this.fsepRemainder))) {
                endOfRecord = false;
                break;
            }
            if (ch == 13) {
                this.reader.consumeLF();
                break;
            }
            if (ch == 10) break;
            if (ch == this.qChar && this.trimWhitespacesAroundQuotes && this.currentFieldHasOnlyWhitespace()) {
                this.currentFieldIndex = 0;
                return this.parseQuoted();
            }
            this.appendChar(ch);
            ch = this.reader.read();
            if (ch == -1) break;
        }
        this.callbackHandler.addField(this.currentField, 0, this.currentFieldIndex, false);
        this.currentFieldIndex = 0;
        return endOfRecord;
    }

    private boolean currentFieldHasOnlyWhitespace() {
        for (int i = 0; i < this.currentFieldIndex; ++i) {
            if (this.currentField[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    private boolean parseQuoted() throws IOException {
        int ch;
        boolean endOfRecord = true;
        block0: while ((ch = this.reader.read()) != -1) {
            while (this.currentFieldIndex < this.currentField.length && this.reader.len > this.reader.start && ch != 13 && ch != 10 && ch != this.qChar) {
                this.currentField[this.currentFieldIndex++] = (char)ch;
                ch = this.reader.buffer[this.reader.start++];
            }
            if (ch == this.qChar && (ch = this.reader.read()) != this.qChar) {
                while (ch != -1) {
                    if (ch == 13) {
                        this.reader.consumeLF();
                        break block0;
                    }
                    if (ch == 10) break block0;
                    if (ch == this.fsep && (this.fsepRemainder == null || this.reader.consumeIf(this.fsepRemainder))) {
                        endOfRecord = false;
                        break block0;
                    }
                    if (!this.trimWhitespacesAroundQuotes || ch > 32) {
                        throw new CsvParseException("Unexpected character after closing quote: '%c' (0x%x)".formatted(ch, ch));
                    }
                    ch = this.reader.read();
                }
                break;
            }
            this.appendChar(ch);
            if (ch == 13) {
                if (this.reader.consumeLF()) {
                    this.appendChar(10);
                }
                ++this.lines;
                continue;
            }
            if (ch != 10) continue;
            ++this.lines;
        }
        this.callbackHandler.addField(this.currentField, 0, this.currentFieldIndex, true);
        this.currentFieldIndex = 0;
        return endOfRecord;
    }

    private void parseComment() throws IOException {
        int ch;
        while ((ch = this.reader.read()) != -1 && ch != 10) {
            if (ch == 13) {
                this.reader.consumeLF();
                break;
            }
            this.appendChar(ch);
        }
        this.callbackHandler.setComment(this.currentField, 0, this.currentFieldIndex);
        this.currentFieldIndex = 0;
    }

    private void appendChar(int ch) {
        if (this.currentField.length == this.currentFieldIndex) {
            if (this.currentField.length == this.maxBufferSize) {
                throw new CsvParseException("The maximum buffer size of %d is insufficient to read the data of a single field. This issue typically arises when a quotation begins but does not conclude within the confines of this buffer's maximum limit. ".formatted(this.maxBufferSize));
            }
            char[] newField = new char[Math.min(this.maxBufferSize, this.currentField.length * 2)];
            System.arraycopy(this.currentField, 0, newField, 0, this.currentField.length);
            this.currentField = newField;
        }
        this.currentField[this.currentFieldIndex++] = (char)ch;
    }

    @Override
    public String peekLine() throws IOException {
        return this.reader.peekLine();
    }

    @Override
    public void skipLine(int numCharsToSkip) throws IOException {
        this.reader.skip(numCharsToSkip);
        int c = this.reader.read();
        if (c == -1) {
            if (numCharsToSkip == 0) {
                throw new EOFException();
            }
            return;
        }
        do {
            if (c == 13) {
                this.reader.consumeLF();
                ++this.startingLineNumber;
                break;
            }
            if (c != 10) continue;
            ++this.startingLineNumber;
            break;
        } while ((c = this.reader.read()) != -1);
    }

    @Override
    public long getStartingLineNumber() {
        return this.startingLineNumber;
    }

    @Override
    public void reset(long startingLineNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static final class LookaheadReader
    implements Closeable {
        private final Reader reader;
        private final char[] buffer;
        private int start;
        private int len;

        LookaheadReader(Reader reader, int bufferSize) {
            this.reader = reader;
            this.buffer = new char[bufferSize];
        }

        int read() throws IOException {
            this.ensureBuffered(1);
            return this.start >= this.len ? -1 : this.buffer[this.start++];
        }

        boolean consumeLF() throws IOException {
            this.ensureBuffered(1);
            if (this.start >= this.len || this.buffer[this.start] != '\n') {
                return false;
            }
            ++this.start;
            return true;
        }

        boolean consumeIf(char[] chars) throws IOException {
            this.ensureBuffered(chars.length);
            if (this.len - this.start < chars.length) {
                return false;
            }
            for (int i = 0; i < chars.length; ++i) {
                if (this.buffer[this.start + i] == chars[i]) continue;
                return false;
            }
            this.start += chars.length;
            return true;
        }

        String peekLine() throws IOException {
            int endIndex;
            this.ensureBuffered(this.buffer.length);
            if (this.start >= this.len) {
                throw new EOFException();
            }
            for (endIndex = this.start; endIndex < this.len && this.buffer[endIndex] != '\r' && this.buffer[endIndex] != '\n'; ++endIndex) {
            }
            return new String(this.buffer, this.start, endIndex - this.start);
        }

        private void ensureBuffered(int required) throws IOException {
            int available = this.len - this.start;
            if (this.len == -1 || required <= available) {
                return;
            }
            if (this.start > 0 && required > this.buffer.length - this.start) {
                int remaining = this.len - this.start;
                System.arraycopy(this.buffer, this.start, this.buffer, 0, remaining);
                this.start = 0;
                this.len = remaining;
            }
            while (this.len - this.start < required) {
                int count = this.reader.read(this.buffer, this.len, this.buffer.length - this.len);
                if (count == -1) {
                    this.len = this.start >= this.len ? -1 : this.len;
                    break;
                }
                this.len += count;
            }
        }

        void skip(int numCharsToSkip) {
            this.start += numCharsToSkip;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

