/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.eclemma.internal.ui.coverageview.CellTextConverter;
import org.eclipse.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

class CopyHandler
extends AbstractHandler
implements ISelectionChangedListener {
    private final ViewSettings settings;
    private final CellTextConverter converter;
    private final Display display;
    private final ISelectionProvider selectionSource;

    public CopyHandler(ViewSettings settings, Display display, ISelectionProvider selectionSource) {
        this.settings = settings;
        this.converter = new CellTextConverter(settings);
        this.display = display;
        this.selectionSource = selectionSource;
        selectionSource.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public boolean isEnabled() {
        return !this.selectionSource.getSelection().isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StringBuilder sb = new StringBuilder();
        String[] headers = this.settings.getColumnHeaders();
        sb.append(headers[0]).append('\t');
        sb.append(headers[1]).append('\t');
        sb.append(headers[2]).append('\t');
        sb.append(headers[3]).append('\t');
        sb.append(headers[4]).append(Text.DELIMITER);
        IStructuredSelection selection = (IStructuredSelection)this.selectionSource.getSelection();
        for (Object element : selection.toList()) {
            sb.append(this.converter.getElementName(element)).append('\t');
            sb.append(this.converter.getRatio(element)).append('\t');
            sb.append(this.converter.getCovered(element)).append('\t');
            sb.append(this.converter.getMissed(element)).append('\t');
            sb.append(this.converter.getTotal(element)).append(Text.DELIMITER);
        }
        this.copy(sb.toString());
        return null;
    }

    private void copy(String text) {
        Clipboard cb = new Clipboard(this.display);
        TextTransfer transfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text}, new Transfer[]{transfer});
        cb.dispose();
    }

    public void dispose() {
        this.selectionSource.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }
}

