/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.tracepointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.AbstractTracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.MessagesForTracepointActions;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CollectAction
extends AbstractTracepointAction {
    private static final String COLLECT_ACTION_ID = "org.eclipse.cdt.dsf.gdb.tracepointactions.CollectAction";
    private static final String COLLECT_ACTION_ELEMENT_NAME = "collectData";
    private static final String COLLECT_STRING_ATTR = "collectString";
    private static final String COLLECT_AS_STRING_ATTR = "collectAsString";
    private static final String COLLECT_AS_STRING_LIMIT_ATTR = "collectAsStringLimit";
    private String fCollectString = "";
    private boolean fCharPtrAsStrings;
    private Integer fCharPtrAsStringsLimit;

    public String getDefaultName() {
        return MessagesForTracepointActions.TracepointActions_Untitled_Collect;
    }

    public String getCollectString() {
        return this.fCollectString;
    }

    public void setCollectString(String str) {
        this.fCollectString = str;
    }

    public boolean getCharPtrAsStrings() {
        return this.fCharPtrAsStrings;
    }

    public void setCharPtrAsStrings(boolean enable) {
        this.fCharPtrAsStrings = enable;
    }

    public Integer getCharPtrAsStringsLimit() {
        return this.fCharPtrAsStringsLimit;
    }

    public void setCharPtrAsStringsLimit(Integer limit) {
        this.fCharPtrAsStringsLimit = limit;
    }

    public String getIdentifier() {
        return COLLECT_ACTION_ID;
    }

    public String getMemento() {
        String collectData = "";
        try {
            DocumentBuilder docBuilder = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(COLLECT_ACTION_ELEMENT_NAME);
            rootElement.setAttribute(COLLECT_STRING_ATTR, this.fCollectString);
            rootElement.setAttribute(COLLECT_AS_STRING_ATTR, Boolean.toString(this.fCharPtrAsStrings));
            rootElement.setAttribute(COLLECT_AS_STRING_LIMIT_ATTR, this.fCharPtrAsStringsLimit == null ? "" : this.fCharPtrAsStringsLimit.toString());
            doc.appendChild(rootElement);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            collectData = s.toString("UTF8");
        }
        catch (Exception e) {
            GdbPlugin.log(e);
        }
        return collectData;
    }

    public String getSummary() {
        StringBuilder collectCmd = new StringBuilder("collect ");
        if (this.fCharPtrAsStrings) {
            collectCmd.append("/s");
            if (this.fCharPtrAsStringsLimit != null) {
                collectCmd.append(this.fCharPtrAsStringsLimit.toString());
            }
            collectCmd.append(" ");
        }
        collectCmd.append(this.fCollectString);
        return collectCmd.toString();
    }

    public String getTypeName() {
        return MessagesForTracepointActions.TracepointActions_Collect_Name;
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            String asStrings;
            DocumentBuilder parser = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            this.fCollectString = root.getAttribute(COLLECT_STRING_ATTR);
            if (this.fCollectString == null) {
                this.fCollectString = "";
            }
            this.fCharPtrAsStrings = (asStrings = root.getAttribute(COLLECT_AS_STRING_ATTR)) != null ? Boolean.valueOf(asStrings) : false;
            this.fCharPtrAsStringsLimit = null;
            String asStringsLimit = root.getAttribute(COLLECT_AS_STRING_LIMIT_ATTR);
            if (asStringsLimit != null) {
                try {
                    this.fCharPtrAsStringsLimit = Integer.valueOf(asStringsLimit);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception e) {
            GdbPlugin.log(e);
        }
    }

    public String toString() {
        return this.getSummary();
    }
}

