/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class ResourcesPlugin
extends Plugin {
    public static final String PI_RESOURCES = "org.eclipse.core.resources";
    public static final String PT_BUILDERS = "builders";
    public static final String PT_NATURES = "natures";
    public static final String PT_MARKERS = "markers";
    public static final String PT_FILE_MODIFICATION_VALIDATOR = "fileModificationValidator";
    public static final String PT_MOVE_DELETE_HOOK = "moveDeleteHook";
    public static final String PT_TEAM_HOOK = "teamHook";
    public static final String PT_REFRESH_PROVIDERS = "refreshProviders";
    public static final String PT_MODEL_PROVIDERS = "modelProviders";
    public static final String PT_VARIABLE_PROVIDERS = "variableResolvers";
    public static final String PT_FILTER_MATCHERS = "filterMatchers";
    public static final Object FAMILY_AUTO_BUILD = new Object();
    public static final Object FAMILY_AUTO_REFRESH = new Object();
    public static final Object FAMILY_MANUAL_BUILD = new Object();
    public static final Object FAMILY_MANUAL_REFRESH = new Object();
    public static final Object FAMILY_SNAPSHOT = new Object();
    public static final String PREF_ENCODING = "encoding";
    private static final String PREF_DESCRIPTION_PREFIX = "description.";
    @Deprecated
    public static final String PREF_MAX_NOTIFICATION_DELAY = "maxnotifydelay";
    public static final String PREF_AUTO_BUILDING = "description.autobuilding";
    public static final String PREF_BUILD_ORDER = "description.buildorder";
    public static final String PREF_DEFAULT_BUILD_ORDER = "description.defaultbuildorder";
    public static final String PREF_MAX_BUILD_ITERATIONS = "description.maxbuilditerations";
    public static final String PREF_APPLY_FILE_STATE_POLICY = "description.applyfilestatepolicy";
    public static final String PREF_FILE_STATE_LONGEVITY = "description.filestatelongevity";
    public static final String PREF_MAX_FILE_STATE_SIZE = "description.maxfilestatesize";
    public static final String PREF_KEEP_DERIVED_STATE = "description.keepDerivedState";
    public static final String PREF_MAX_FILE_STATES = "description.maxfilestates";
    public static final String PREF_SNAPSHOT_INTERVAL = "description.snapshotinterval";
    public static final String PREF_DISABLE_LINKING = "description.disableLinking";
    public static final String PREF_AUTO_REFRESH = "refresh.enabled";
    public static final String PREF_LIGHTWEIGHT_AUTO_REFRESH = "refresh.lightweight.enabled";
    public static final String PREF_SEPARATE_DERIVED_ENCODINGS = "separateDerivedEncodings";
    public static final boolean DEFAULT_PREF_SEPARATE_DERIVED_ENCODINGS = false;
    public static final String PREF_MISSING_NATURE_MARKER_SEVERITY = "missingNatureMarkerSeverity";
    public static final String PREF_MISSING_ENCODING_MARKER_SEVERITY = "missingEncodingMarkerSeverity";
    public static final String PREF_MAX_CONCURRENT_BUILDS = "maxConcurrentBuilds";
    private static volatile ResourcesPlugin plugin;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private ServiceTracker<Location, Workspace> instanceLocationTracker;
    private WorkspaceInitCustomizer workspaceInitCustomizer;
    private static String systemEncoding;

    public static String getEncoding() {
        ResourcesPlugin resourcesPlugin = plugin;
        if (resourcesPlugin == null) {
            return ResourcesPlugin.getSystemEncoding();
        }
        Workspace workspace = resourcesPlugin.workspaceInitCustomizer.workspace;
        if (workspace == null) {
            return ResourcesPlugin.getSystemEncoding();
        }
        try {
            String enc = workspace.getRoot().getDefaultCharset(false);
            if (enc == null) {
                return ResourcesPlugin.getSystemEncoding();
            }
            return enc;
        }
        catch (CoreException e) {
            return ResourcesPlugin.getSystemEncoding();
        }
    }

    private static String getSystemEncoding() {
        if (systemEncoding == null) {
            String encoding = null;
            List<String> commandLineArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : commandLineArgs) {
                if (!arg.startsWith("-Dfile.encoding=")) continue;
                encoding = arg.substring("-Dfile.encoding=".length());
            }
            if (encoding == null || encoding.isBlank()) {
                encoding = Platform.getSystemCharset().name();
            }
            systemEncoding = encoding;
        }
        return systemEncoding;
    }

    public static ResourcesPlugin getPlugin() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        ResourcesPlugin resourcesPlugin = plugin;
        if (resourcesPlugin == null) {
            throw new IllegalStateException(Messages.resources_workspaceClosedStatic);
        }
        Workspace workspace = resourcesPlugin.workspaceInitCustomizer.workspace;
        if (workspace == null) {
            throw new IllegalStateException(Messages.resources_workspaceClosedStatic);
        }
        return workspace;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.debugRegistration.unregister();
        this.instanceLocationTracker.close();
        ResourcesPlugin.getPlugin().savePluginPreferences();
        plugin = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.workspaceInitCustomizer = new WorkspaceInitCustomizer(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", PI_RESOURCES);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.RESOURCES_DEBUG_OPTIONS_LISTENER, properties);
        this.instanceLocationTracker = new ServiceTracker(context, context.createFilter(String.format("(&%s(%s=*))", Location.INSTANCE_FILTER, "url")), (ServiceTrackerCustomizer)this.workspaceInitCustomizer);
        plugin = this;
        this.instanceLocationTracker.open();
    }

    private final class WorkspaceInitCustomizer
    implements ServiceTrackerCustomizer<Location, Workspace> {
        private final BundleContext context;
        private volatile Workspace workspace;
        private ServiceRegistration<IWorkspace> workspaceRegistration;

        private WorkspaceInitCustomizer(BundleContext context) {
            this.context = context;
        }

        public Workspace addingService(ServiceReference<Location> reference) {
            if (this.workspace != null) {
                return null;
            }
            Location location = (Location)this.context.getService(reference);
            if (location == null) {
                return null;
            }
            this.workspace = new Workspace();
            try {
                IStatus result = this.workspace.open(null);
                if (!result.isOK()) {
                    ResourcesPlugin.this.getLog().log(result);
                }
                this.workspaceRegistration = this.context.registerService(IWorkspace.class, (Object)this.workspace, null);
                return this.workspace;
            }
            catch (CoreException e) {
                ResourcesPlugin.this.getLog().log(e.getStatus());
            }
            catch (IllegalStateException e) {
                ResourcesPlugin.this.getLog().log(Status.error((String)"Internal error open workspace", (Throwable)e));
            }
            return null;
        }

        public void modifiedService(ServiceReference<Location> reference, Workspace service) {
        }

        public void removedService(ServiceReference<Location> reference, Workspace service) {
            if (service == this.workspace) {
                try {
                    this.workspaceRegistration.unregister();
                }
                catch (RuntimeException e) {
                    ResourcesPlugin.this.getLog().log((IStatus)Status.warning((String)"Unregistering workspaces throws an exception", (Throwable)e));
                }
                try {
                    try {
                        service.close(null);
                    }
                    catch (CoreException e) {
                        ResourcesPlugin.this.getLog().log(e.getStatus());
                        this.workspace = null;
                        this.context.ungetService(reference);
                    }
                }
                finally {
                    this.workspace = null;
                    this.context.ungetService(reference);
                }
            }
        }
    }
}

