/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.backend;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendException;
import org.eclipse.oomph.resources.backend.BackendFile;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.resources.backend.BackendSystem;
import org.eclipse.oomph.util.StringUtil;

public final class LocalBackendSystem
extends BackendSystem {
    private final File root;

    private LocalBackendSystem(URI systemURI) throws BackendException {
        super(systemURI);
        this.root = new File(systemURI.toFileString());
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    protected File getDelegate(BackendResource backendResource) throws Exception {
        if (backendResource == this) {
            return this.root;
        }
        return new File(this.root, backendResource.getSystemRelativeURI().toFileString());
    }

    @Override
    protected Object[] getDelegateMembers(Object containerDelegate, IProgressMonitor monitor) throws Exception {
        return ((File)containerDelegate).listFiles();
    }

    @Override
    protected Object getDelegateMember(Object containerDelegate, String relativePath, IProgressMonitor monitor) throws Exception {
        return new File((File)containerDelegate, relativePath);
    }

    @Override
    protected String getDelegateName(Object resourceDelegate) throws Exception {
        return ((File)resourceDelegate).getName();
    }

    @Override
    protected BackendResource.Type getDelegateType(Object resourceDelegate, boolean checkExists) throws Exception {
        if (resourceDelegate.equals(this.getDelegate())) {
            return BackendResource.Type.SYSTEM;
        }
        File file = (File)resourceDelegate;
        if (file.isDirectory()) {
            return BackendResource.Type.FOLDER;
        }
        if (file.isFile()) {
            return BackendResource.Type.FILE;
        }
        return null;
    }

    @Override
    protected IPath getLocation(BackendResource backendResource) throws Exception {
        return new Path(this.getDelegate(backendResource).getAbsolutePath());
    }

    @Override
    protected boolean exists(BackendResource backendResource, IProgressMonitor monitor) throws Exception {
        File file = this.getDelegate(backendResource);
        if (StringUtil.isEmpty((String)file.getName())) {
            return file.exists();
        }
        if (backendResource.isContainer()) {
            return file.isDirectory();
        }
        return file.isFile();
    }

    @Override
    protected long getLastModified(BackendResource backendResource, IProgressMonitor monitor) throws Exception {
        return this.getDelegate(backendResource).lastModified();
    }

    @Override
    protected InputStream getContents(BackendFile backendFile, IProgressMonitor monitor) throws Exception {
        return new FileInputStream(this.getDelegate(backendFile));
    }

    @Override
    protected ResourcesUtil.ImportResult importIntoWorkspace(BackendContainer container, IProject project, IProgressMonitor monitor) throws Exception {
        File projectLocation = container.getLocation().toFile();
        String projectName = project.getName();
        return ResourcesUtil.importProject(projectLocation, projectName, monitor);
    }

    public static final class Factory
    implements BackendSystem.IFactory {
        @Override
        public LocalBackendSystem createBackendSystem(URI systemURI) throws BackendException {
            return new LocalBackendSystem(systemURI);
        }
    }

    public static final class Member {
        private final String name;
        private final BackendResource.Type type;

        public Member(String name, BackendResource.Type type) {
            Assert.isNotNull((Object)name);
            Assert.isNotNull((Object)((Object)type));
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public BackendResource.Type getType() {
            return this.type;
        }

        public String toString() {
            Object string = this.name;
            if (this.type != BackendResource.Type.FILE) {
                string = (String)string + "/";
            }
            return string;
        }
    }
}

