/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ViewIntroAdapterSite;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class ViewIntroAdapterPart
extends ViewPart {
    private IIntroPart introPart;
    private IIntroSite introSite;
    private boolean handleZoomEvents = true;
    private IEventBroker eventBroker;
    private final EventHandler zoomChangeListener = event -> {
        if (!this.handleZoomEvents) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPartStack)) {
            return;
        }
        if (changedObj != this.getIntroStack()) {
            return;
        }
        if (UIEvents.isADD((Event)event) && UIEvents.contains((Event)event, (String)"NewValue", (Object)"Maximized")) {
            this.setStandby(false);
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"Maximized")) {
            this.setStandby(true);
        }
    };

    private void addZoomListener() {
        ViewSite site = (ViewSite)this.getViewSite();
        MPart introModelPart = site.getModel();
        if (introModelPart == null || introModelPart.getContext() == null) {
            return;
        }
        this.eventBroker = (IEventBroker)introModelPart.getContext().get(IEventBroker.class);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this.zoomChangeListener);
    }

    private MPartStack getIntroStack() {
        MElementContainer introPartParent;
        ViewSite site = (ViewSite)this.getViewSite();
        MPart introModelPart = site.getModel();
        if (introModelPart.getCurSharedRef() != null && (introPartParent = introModelPart.getCurSharedRef().getParent()) instanceof MPartStack) {
            return (MPartStack)introPartParent;
        }
        return null;
    }

    public void setStandby(boolean standby) {
        Control control = (Control)((PartSite)this.getSite()).getModel().getWidget();
        BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
            try {
                control.setRedraw(false);
                this.introPart.standbyStateChanged(standby);
            }
            finally {
                control.setRedraw(true);
            }
        });
    }

    public void setHandleZoomEvents(boolean handle) {
        this.handleZoomEvents = handle;
    }

    @Override
    public void createPartControl(Composite parent) {
        MElementContainer parentElement;
        this.addZoomListener();
        this.introPart.createPartControl(parent);
        ViewSite site = (ViewSite)this.getViewSite();
        MPart introModelPart = site.getModel();
        if (introModelPart.getCurSharedRef() != null && (parentElement = introModelPart.getCurSharedRef().getParent()) instanceof MPartStack) {
            this.setStandby(!parentElement.getTags().contains("Maximized"));
        }
    }

    @Override
    public void dispose() {
        this.eventBroker.unsubscribe(this.zoomChangeListener);
        this.getSite().getWorkbenchWindow().getWorkbench().getIntroManager().closeIntro(this.introPart);
        this.introPart.dispose();
        super.dispose();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return (T)Adapters.adapt((Object)this.introPart, adapter);
    }

    @Override
    public Image getTitleImage() {
        return this.introPart.getTitleImage();
    }

    @Override
    public String getTitle() {
        return this.introPart == null ? super.getTitle() : this.introPart.getTitle();
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site);
        Workbench workbench = (Workbench)site.getWorkbenchWindow().getWorkbench();
        try {
            this.introPart = workbench.getWorkbenchIntroManager().createNewIntroPart();
            this.setPartName(this.introPart.getTitle());
            this.introPart.addPropertyListener((source, propId) -> this.firePropertyChange(propId));
            this.introSite = new ViewIntroAdapterSite(site, workbench.getIntroDescriptor());
            this.introPart.init(this.introSite, memento);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(IntroMessages.Intro_could_not_create_proxy, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, IntroMessages.Intro_could_not_create_proxy, (Throwable)e));
        }
    }

    @Override
    public void setFocus() {
        this.introPart.setFocus();
    }

    @Override
    public void saveState(IMemento memento) {
        this.introPart.saveState(memento);
    }
}

