/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.ui.IFunctionSummary;

public class FunctionPrototypeSummary
implements IFunctionSummary.IFunctionPrototypeSummary {
    String fname;
    String freturn;
    String farguments;

    public FunctionPrototypeSummary(String proto) {
        int leftbracket = ((String)proto).indexOf(40);
        int rightbracket = ((String)proto).lastIndexOf(41);
        if (leftbracket == -1 || rightbracket == -1) {
            proto = leftbracket != -1 ? ((String)proto).substring(leftbracket) + ")" : (rightbracket != -1 ? ((String)proto).substring(rightbracket - 1) + "()" : (String)proto + "()");
            leftbracket = ((String)proto).indexOf(40);
            rightbracket = ((String)proto).lastIndexOf(41);
        }
        this.farguments = ((String)proto).substring(leftbracket + 1, rightbracket);
        if (this.farguments.equals("void")) {
            this.farguments = "";
        }
        int nameend = leftbracket - 1;
        while (((String)proto).charAt(nameend) == ' ') {
            --nameend;
        }
        int namestart = nameend;
        while (namestart > 0 && ((String)proto).charAt(namestart) != ' ') {
            --namestart;
        }
        this.fname = ((String)proto).substring(namestart, nameend + 1).trim();
        this.freturn = namestart == 0 ? "" : ((String)proto).substring(0, namestart).trim();
    }

    @Override
    public String getName() {
        return this.fname;
    }

    @Override
    public String getReturnType() {
        return this.freturn;
    }

    @Override
    public String getArguments() {
        return this.farguments;
    }

    @Override
    public String getPrototypeString(boolean namefirst) {
        return this.getPrototypeString(namefirst, true);
    }

    public String getPrototypeString(boolean namefirst, boolean appendReturnType) {
        StringBuilder buffer = new StringBuilder();
        if (!namefirst && appendReturnType) {
            buffer.append(this.getReturnType());
            buffer.append(" ");
        }
        buffer.append(this.getName());
        buffer.append("(");
        if (this.getArguments() != null) {
            buffer.append(this.getArguments());
        }
        buffer.append(")");
        if (namefirst && appendReturnType && this.getReturnType().length() > 0) {
            buffer.append(" ");
            buffer.append(this.getReturnType());
        }
        buffer.append(";");
        return buffer.toString();
    }
}

