/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.ElementOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;
import org.eclipse.uml2.uml.internal.operations.ValueSpecificationOperations;

public class PropertyOperations
extends RedefinableElementOperations {
    protected PropertyOperations() {
    }

    public static boolean validateMultiplicityOfComposite(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Property otherEnd;
        int upperBound = property.upperBound();
        if ((upperBound == -1 || upperBound > 1) && (otherEnd = property.getOtherEnd()) != null && otherEnd.isComposite()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 44, UMLPlugin.INSTANCE.getString("_UI_Property_MultiplicityOfComposite_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property)), new Object[]{property, new Integer(upperBound)}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateSubsettingContextConforms(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        block0: for (Property subsettedProperty : property.getSubsettedProperties()) {
            for (Type subsettingContext : property.subsettingContext()) {
                for (Type spSubsettingContext : subsettedProperty.subsettingContext()) {
                    if (subsettingContext.conformsTo(spSubsettingContext)) continue block0;
                }
            }
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 42, UMLPlugin.INSTANCE.getString("_UI_Property_SubsettingContextConforms_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property, (Object)subsettedProperty)), new Object[]{property, subsettedProperty}));
        }
        return result;
    }

    public static boolean validateRedefinedPropertyInherited(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSubsettingRules(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Type type = property.getType();
        int upperBound = property.upperBound();
        for (Property subsettedProperty : property.getSubsettedProperties()) {
            Type subsettedType = subsettedProperty.getType();
            int subsettedUpperBound = subsettedProperty.upperBound();
            if ((type == null ? subsettedType == null : type.conformsTo(subsettedProperty.getType())) && (subsettedUpperBound == -1 || upperBound != -1 && upperBound <= subsettedUpperBound)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 46, UMLPlugin.INSTANCE.getString("_UI_Property_SubsettingRules_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property, (Object)subsettedProperty)), new Object[]{property, subsettedProperty}));
        }
        return result;
    }

    public static boolean validateDerivedUnionIsDerived(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (property.isDerivedUnion() && !property.isDerived()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 48, UMLPlugin.INSTANCE.getString("_UI_Property_DerivedUnionIsDerived_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property)), new Object[]{property}));
            }
        }
        return result;
    }

    public static boolean validateDerivedUnionIsReadOnly(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (property.isDerivedUnion() && !property.isReadOnly()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 43, UMLPlugin.INSTANCE.getString("_UI_Property_DerivedUnionIsReadOnly_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property)), new Object[]{property}));
            }
        }
        return result;
    }

    public static boolean validateSubsettedPropertyNames(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String name = property.getName();
        for (Property subsettedProperty : property.getSubsettedProperties()) {
            if (!PropertyOperations.safeEquals((Object)name, (Object)subsettedProperty.getName())) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 50, UMLPlugin.INSTANCE.getString("_UI_Property_SubsettingPropertyNames_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property, (Object)subsettedProperty)), new Object[]{property, subsettedProperty}));
        }
        return result;
    }

    public static boolean validateTypeOfOppositeEnd(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateQualifiedIsAssociationEnd(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateDeploymentTarget(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (!(property.getDeployments().isEmpty() || property.isComposite() && property.getType() instanceof Node && property.getOwner() instanceof Node)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 49, UMLPlugin.INSTANCE.getString("_UI_Property_DeploymentTarget_diagnostic", PropertyOperations.getMessageSubstitutions(context, (Object)property)), new Object[]{property}));
            }
        }
        return result;
    }

    public static boolean validateBindingToAttribute(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static void setBooleanDefaultValue(Property property, boolean value) {
        ValueSpecification defaultValue = property.getDefaultValue();
        ((LiteralBoolean)(defaultValue instanceof LiteralBoolean ? defaultValue : property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_BOOLEAN))).setValue(value);
    }

    public static void setIntegerDefaultValue(Property property, int value) {
        ValueSpecification defaultValue = property.getDefaultValue();
        ((LiteralInteger)(defaultValue instanceof LiteralInteger ? defaultValue : property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_INTEGER))).setValue(value);
    }

    public static void setStringDefaultValue(Property property, String value) {
        ValueSpecification defaultValue = property.getDefaultValue();
        ((LiteralString)(defaultValue instanceof LiteralString ? defaultValue : property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_STRING))).setValue(value);
    }

    public static void setUnlimitedNaturalDefaultValue(Property property, int value) {
        ValueSpecification defaultValue = property.getDefaultValue();
        ((LiteralUnlimitedNatural)(defaultValue instanceof LiteralUnlimitedNatural ? defaultValue : property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL))).setValue(value);
    }

    public static void unsetDefault(Property property) {
        if (property.getDefault() != null) {
            property.eUnset((EStructuralFeature)UMLPackage.Literals.PROPERTY__DEFAULT_VALUE);
        }
    }

    public static void setNullDefaultValue(Property property) {
        if (!(property.getDefaultValue() instanceof LiteralNull)) {
            property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_NULL);
        }
    }

    public static Property getOpposite(Property property) {
        int index;
        EList<Property> memberEnds;
        Association association = property.getAssociation();
        if (association != null && (memberEnds = association.getMemberEnds()).size() == 2 && (index = memberEnds.indexOf((Object)property)) != -1) {
            return (Property)((InternalEList)memberEnds).basicGet(1 - index);
        }
        return null;
    }

    public static boolean isComposite(Property property) {
        return property.getAggregation() == AggregationKind.COMPOSITE_LITERAL;
    }

    public static EList<Type> subsettingContext(Property property) {
        UniqueEList.FastCompare subsettingContext = new UniqueEList.FastCompare();
        Association association = property.getAssociation();
        if (association == null) {
            Namespace namespace = property.getNamespace();
            if (namespace instanceof Type) {
                subsettingContext.add((Object)((Type)((Object)namespace)));
            }
        } else {
            for (Property memberEnd : association.getMemberEnds()) {
                Type memberEndType;
                if (memberEnd == property || !((memberEndType = memberEnd.getType()) instanceof Classifier)) continue;
                subsettingContext.add((Object)memberEndType);
            }
        }
        return ECollections.unmodifiableEList((EList)subsettingContext);
    }

    public static boolean isNavigable(Property property) {
        Association owningAssociation = property.getOwningAssociation();
        return owningAssociation == null ? property.eGet((EStructuralFeature)UMLPackage.Literals.ELEMENT__OWNER, false) instanceof Classifier : owningAssociation.getNavigableOwnedEnds().contains((Object)property);
    }

    public static String getDefault(Property property) {
        ValueSpecification defaultValue = property.getDefaultValue();
        return defaultValue == null ? null : defaultValue.stringValue();
    }

    public static void setDefault(Property property, String newDefault) {
        ValueSpecification defaultValue = property.getDefaultValue();
        if (defaultValue != null) {
            ValueSpecificationOperations.setValue(defaultValue, newDefault);
        } else {
            property.setStringDefaultValue(newDefault);
        }
    }

    public static void setIsComposite(Property property, boolean newIsComposite) {
        property.setAggregation(newIsComposite ? AggregationKind.COMPOSITE_LITERAL : AggregationKind.NONE_LITERAL);
    }

    public static void setOpposite(Property property, Property newOpposite) {
        if (property.getOwningAssociation() != null) {
            throw new IllegalStateException();
        }
        if (newOpposite != null && newOpposite.getOwningAssociation() != null) {
            throw new IllegalArgumentException(String.valueOf(newOpposite));
        }
        Association association = property.getAssociation();
        if (association == null) {
            association = UMLFactory.eINSTANCE.createAssociation();
            Package owningPackage = (Package)ElementOperations.getOwningElement(property, UMLPackage.Literals.PACKAGE, true);
            if (owningPackage != null) {
                owningPackage.getPackagedElements().add((Object)association);
            }
        }
        EList<Property> memberEnds = association.getMemberEnds();
        switch (memberEnds.size()) {
            case 0: {
                memberEnds.add((Object)property);
            }
            case 1: {
                if (newOpposite == null) break;
                memberEnds.add((Object)newOpposite);
                break;
            }
            case 2: {
                if (newOpposite == null) {
                    memberEnds.remove(Math.abs(memberEnds.indexOf((Object)property) - 1));
                    break;
                }
                memberEnds.set(Math.abs(memberEnds.indexOf((Object)property) - 1), (Object)newOpposite);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static void setRealDefaultValue(Property property, double value) {
        ValueSpecification defaultValue = property.getDefaultValue();
        ((LiteralReal)(defaultValue instanceof LiteralReal ? defaultValue : property.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_REAL))).setValue(value);
    }

    public static boolean isAttribute(Property property) {
        for (EStructuralFeature.Setting inverseReference : PropertyOperations.getInverseReferences((EObject)property)) {
            EObject eObject = inverseReference.getEObject();
            if (!(eObject instanceof Classifier) || !((Classifier)eObject).getAttributes().contains((Object)property)) continue;
            return true;
        }
        return false;
    }

    public static void setIsNavigable(Property property, boolean isNavigable) {
        if (property.isNavigable() != isNavigable) {
            Association association = property.getAssociation();
            if (association == null) {
                throw new IllegalStateException();
            }
            EList<Property> navigableOwnedEnds = association.getNavigableOwnedEnds();
            if (isNavigable) {
                navigableOwnedEnds.add((Object)property);
            } else {
                navigableOwnedEnds.remove((Object)property);
                association.getOwnedEnds().add((Object)property);
            }
        }
    }

    public static Property getOtherEnd(Property property) {
        int index;
        EList<Property> memberEnds;
        Association association = property.getAssociation();
        if (association != null && (memberEnds = association.getMemberEnds()).size() == 2 && (index = memberEnds.indexOf((Object)property)) != -1) {
            return (Property)memberEnds.get(Math.abs(index - 1));
        }
        return null;
    }

    public static boolean isSetDefault(Property property) {
        return property.getDefault() != null;
    }

    public static boolean isConsistentWith(Property property, RedefinableElement redefiningElement) {
        if (redefiningElement instanceof Property && redefiningElement.isRedefinitionContextValid(property)) {
            Property prop = (Property)redefiningElement;
            Type type = property.getType();
            int upperBound = property.upperBound();
            Type propType = prop.getType();
            int propUpperBound = prop.upperBound();
            return (propType == null ? type == null : propType.conformsTo(type)) && prop.lowerBound() >= property.lowerBound() && (upperBound == -1 || propUpperBound != -1 && propUpperBound <= upperBound) && (!property.isComposite() || prop.isComposite());
        }
        return false;
    }

    public static boolean isCompatibleWith(Property property, ParameterableElement p) {
        if (property.eClass().isInstance((Object)p) && p instanceof TypedElement) {
            Type type = property.getType();
            return type == null ? ((TypedElement)((Object)p)).eGet((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, false) == null : type.conformsTo(((TypedElement)((Object)p)).getType());
        }
        return false;
    }
}

