/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.operations.PackageableElementOperations;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class TypeOperations
extends PackageableElementOperations {
    protected TypeOperations() {
    }

    protected static void validateTypeAndBounds(Type type, int lower, int upper) {
        if (type == null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        if (lower < 0) {
            throw new IllegalArgumentException(String.valueOf(lower));
        }
        if (upper != -1 && upper < lower) {
            throw new IllegalArgumentException(String.valueOf(upper));
        }
    }

    protected static Property createOwnedProperty(Type type, final String name, final Type propertyType, int lower, int upper) {
        Property ownedProperty = (Property)new UMLSwitch<Property>(){

            @Override
            public Property caseArtifact(Artifact artifact) {
                return artifact.createOwnedAttribute(name, propertyType);
            }

            @Override
            public Property caseAssociation(Association association) {
                return association.createOwnedEnd(name, propertyType);
            }

            @Override
            public Property caseAssociationClass(AssociationClass associationClass) {
                return associationClass.createOwnedAttribute(name, propertyType);
            }

            @Override
            public Property caseDataType(DataType dataType) {
                return dataType.createOwnedAttribute(name, propertyType);
            }

            @Override
            public Property caseInterface(Interface interface_) {
                return interface_.createOwnedAttribute(name, propertyType);
            }

            @Override
            public Property caseSignal(Signal signal) {
                return signal.createOwnedAttribute(name, propertyType);
            }

            @Override
            public Property caseStructuredClassifier(StructuredClassifier structuredClassifier) {
                return structuredClassifier.createOwnedAttribute(name, propertyType);
            }
        }.doSwitch((EObject)type);
        ownedProperty.setLower(lower);
        ownedProperty.setUpper(upper);
        return ownedProperty;
    }

    public static Property createOwnedAttribute(Type type, String name, Type attributeType, int lower, int upper) {
        if (TypeOperations.getOwnedAttributes(type) == null) {
            throw new UnsupportedOperationException();
        }
        if (TypeOperations.isEmpty((String)name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        TypeOperations.validateTypeAndBounds(attributeType, lower, upper);
        return TypeOperations.createOwnedProperty(type, name, attributeType, lower, upper);
    }

    protected static Property createAssociationEnd(Type type, Association association, boolean isNavigable, AggregationKind aggregation, String name, int lower, int upper, Type endType) {
        EList<Property> ownedAttributes = TypeOperations.getOwnedAttributes(type);
        Property associationEnd = TypeOperations.createOwnedProperty(ownedAttributes == null || !isNavigable ? association : type, name, endType, lower, upper);
        associationEnd.setAggregation(aggregation);
        if (isNavigable) {
            if (ownedAttributes == null) {
                association.getNavigableOwnedEnds().add((Object)associationEnd);
            } else {
                association.getMemberEnds().add((Object)associationEnd);
            }
        }
        return associationEnd;
    }

    public static Association createAssociation(Type type, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1Lower, int end1Upper, Type end1Type, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2Lower, int end2Upper) {
        return TypeOperations.createAssociation(type, end1IsNavigable, end1Aggregation, end1Name, end1Lower, end1Upper, end1Type, end2IsNavigable, end2Aggregation, end2Name, end2Lower, end2Upper, UMLPackage.Literals.ASSOCIATION);
    }

    protected static Association createAssociation(Type type, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1Lower, int end1Upper, Type end1Type, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2Lower, int end2Upper, EClass eClass) {
        TypeOperations.validateTypeAndBounds(end1Type, end1Lower, end1Upper);
        TypeOperations.validateTypeAndBounds(type, end2Lower, end2Upper);
        Package package_ = type.getNearestPackage();
        if (package_ == null) {
            throw new IllegalStateException();
        }
        if (end1Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf((Object)end1Aggregation));
        }
        if (end2Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf((Object)end2Aggregation));
        }
        Association association = (Association)package_.createOwnedType(null, eClass);
        TypeOperations.createAssociationEnd(type, association, end1IsNavigable, end1Aggregation, end1Name, end1Lower, end1Upper, end1Type);
        TypeOperations.createAssociationEnd(end1Type, association, end2IsNavigable, end2Aggregation, end2Name, end2Lower, end2Upper, type);
        return association;
    }

    public static EList<Association> getAssociations(Type type) {
        UniqueEList.FastCompare associations = new UniqueEList.FastCompare();
        for (EStructuralFeature.Setting nonNavigableInverseReference : TypeOperations.getNonNavigableInverseReferences((EObject)type)) {
            Association association;
            EObject eObject;
            if (nonNavigableInverseReference.getEStructuralFeature() != UMLPackage.Literals.TYPED_ELEMENT__TYPE || !((eObject = nonNavigableInverseReference.getEObject()) instanceof Property) || (association = ((Property)eObject).getAssociation()) == null) continue;
            associations.add((Object)association);
        }
        return ECollections.unmodifiableEList((EList)associations);
    }

    public static Operation createOwnedOperation(Type type, final String name, final EList<String> parameterNames, final EList<Type> parameterTypes, Type returnType) {
        if (TypeOperations.getOwnedOperations(type) == null) {
            throw new UnsupportedOperationException();
        }
        Operation ownedOperation = (Operation)new UMLSwitch<Operation>(){

            @Override
            public Operation caseArtifact(Artifact artifact) {
                return artifact.createOwnedOperation(name, (EList<String>)parameterNames, (EList<Type>)parameterTypes);
            }

            @Override
            public Operation caseClass(Class class_) {
                return class_.createOwnedOperation(name, (EList<String>)parameterNames, (EList<Type>)parameterTypes);
            }

            @Override
            public Operation caseDataType(DataType dataType) {
                return dataType.createOwnedOperation(name, (EList<String>)parameterNames, (EList<Type>)parameterTypes);
            }

            @Override
            public Operation caseInterface(Interface interface_) {
                return interface_.createOwnedOperation(name, (EList<String>)parameterNames, (EList<Type>)parameterTypes);
            }
        }.doSwitch((EObject)type);
        if (returnType != null) {
            ownedOperation.createReturnResult(null, returnType);
        }
        return ownedOperation;
    }

    public static boolean conformsTo(Type type, Type other) {
        return false;
    }
}

