/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.model.CursorConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.model.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.IndentForEnter;
import org.eclipse.tm4e.languageconfiguration.internal.supports.IndentRulesSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.Strings;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;

public final class IndentForEnterHelper {
    private static int getPrecedingValidLine(IVirtualModel model, int lineIndex, IndentRulesSupport indentRulesSupport) throws BadLocationException {
        if (lineIndex > 0) {
            int lastLineIndex = lineIndex - 1;
            while (lastLineIndex >= 0) {
                String text = model.getLineContent(lastLineIndex);
                if (!text.isBlank() && !indentRulesSupport.shouldIgnore(text)) {
                    return lastLineIndex;
                }
                --lastLineIndex;
            }
        }
        return -1;
    }

    private static @Nullable InheritedIndentation getInheritIndentForLine(IVirtualModel model, boolean honorIntentialIndent, int lineIndex, IndentRulesSupport indentRulesSupport) throws BadLocationException {
        int precedingUnIgnoredLineIndex;
        if (lineIndex < 1) {
            return InheritedIndentation.EMPTY;
        }
        int priorLineIndex = lineIndex - 1;
        while (priorLineIndex >= 0) {
            if (!model.getLineContent(priorLineIndex).isEmpty()) break;
            if (priorLineIndex == 0) {
                return InheritedIndentation.EMPTY;
            }
            --priorLineIndex;
        }
        if ((precedingUnIgnoredLineIndex = IndentForEnterHelper.getPrecedingValidLine(model, lineIndex, indentRulesSupport)) < -1) {
            return null;
        }
        if (precedingUnIgnoredLineIndex < 0) {
            return InheritedIndentation.EMPTY;
        }
        String precedingUnIgnoredLineContent = model.getLineContent(precedingUnIgnoredLineIndex);
        if (indentRulesSupport.shouldIncrease(precedingUnIgnoredLineContent) || indentRulesSupport.shouldIndentNextLine(precedingUnIgnoredLineContent)) {
            return new InheritedIndentation(Strings.getLeadingWhitespace(precedingUnIgnoredLineContent), EnterAction.IndentAction.Indent, precedingUnIgnoredLineIndex);
        }
        if (indentRulesSupport.shouldDecrease(precedingUnIgnoredLineContent)) {
            return new InheritedIndentation(Strings.getLeadingWhitespace(precedingUnIgnoredLineContent), null, precedingUnIgnoredLineIndex);
        }
        if (precedingUnIgnoredLineIndex == 0) {
            return new InheritedIndentation(Strings.getLeadingWhitespace(precedingUnIgnoredLineContent), null, precedingUnIgnoredLineIndex);
        }
        int previousLineIndex = precedingUnIgnoredLineIndex - 1;
        String previousLineContent = model.getLineContent(previousLineIndex);
        int previousLineIndentMetadata = indentRulesSupport.getIndentMetadata(previousLineContent);
        if ((previousLineIndentMetadata & 3) == 0 && (previousLineIndentMetadata & 4) != 0) {
            int stopLineIndex = -1;
            int i = previousLineIndex - 1;
            while (i >= 0) {
                if (!indentRulesSupport.shouldIndentNextLine(model.getLineContent(i))) {
                    stopLineIndex = i;
                    break;
                }
                --i;
            }
            return new InheritedIndentation(Strings.getLeadingWhitespace(model.getLineContent(stopLineIndex + 1)), null, stopLineIndex + 1);
        }
        if (honorIntentialIndent) {
            return new InheritedIndentation(Strings.getLeadingWhitespace(precedingUnIgnoredLineContent), null, precedingUnIgnoredLineIndex);
        }
        int i = precedingUnIgnoredLineIndex;
        while (i >= 0) {
            String lineContent = model.getLineContent(i);
            if (indentRulesSupport.shouldIncrease(lineContent)) {
                return new InheritedIndentation(Strings.getLeadingWhitespace(lineContent), null, i);
            }
            if (indentRulesSupport.shouldIndentNextLine(lineContent)) {
                int stopLineIndex = -1;
                int j = i - 1;
                while (j >= 0) {
                    if (!indentRulesSupport.shouldIndentNextLine(model.getLineContent(i))) {
                        stopLineIndex = j;
                        break;
                    }
                    --j;
                }
                return new InheritedIndentation(Strings.getLeadingWhitespace(model.getLineContent(stopLineIndex + 1)), null, stopLineIndex + 1);
            }
            if (indentRulesSupport.shouldDecrease(lineContent)) {
                return new InheritedIndentation(Strings.getLeadingWhitespace(lineContent), null, i);
            }
            --i;
        }
        return new InheritedIndentation(Strings.getLeadingWhitespace(model.getLineContent(0)), null, 0);
    }

    public static @Nullable String getGoodIndentForLine(IDocument doc, int lineIndex, IIndentConverter indentConverter, IndentRulesSupport indentRulesSupport, OnEnterSupport onEnterSupport) throws BadLocationException {
        IVirtualModel virtualModel = lineIndex1 -> DocumentHelper.getLineText((IDocument)doc, (int)lineIndex1, (boolean)false);
        InheritedIndentation indent = IndentForEnterHelper.getInheritIndentForLine(virtualModel, true, lineIndex, indentRulesSupport);
        if (indent != null) {
            String lineContent = virtualModel.getLineContent(lineIndex);
            Integer inheritLineIndex = indent.lineIndex;
            if (inheritLineIndex != null) {
                EnterAction enterResult;
                boolean shouldApplyEnterRules = true;
                int inBetweenLine = inheritLineIndex;
                while (inBetweenLine < lineIndex - 1) {
                    if (!virtualModel.getLineContent(inBetweenLine).isBlank()) {
                        shouldApplyEnterRules = false;
                        break;
                    }
                    ++inBetweenLine;
                }
                if (shouldApplyEnterRules && (enterResult = onEnterSupport.onEnter("", virtualModel.getLineContent(inheritLineIndex), "")) != null) {
                    Object indentation = Strings.getLeadingWhitespace(virtualModel.getLineContent(inheritLineIndex));
                    if (enterResult.removeText != null) {
                        indentation = Strings.getLeadingWhitespace(virtualModel.getLineContent(inheritLineIndex));
                    }
                    if (enterResult.indentAction == EnterAction.IndentAction.Indent || enterResult.indentAction == EnterAction.IndentAction.IndentOutdent) {
                        indentation = indentConverter.shiftIndent((String)indentation);
                    } else if (enterResult.indentAction == EnterAction.IndentAction.Outdent) {
                        indentation = indentConverter.unshiftIndent((String)indentation);
                    }
                    if (indentRulesSupport.shouldDecrease(lineContent)) {
                        indentation = indentConverter.unshiftIndent((String)indentation);
                    }
                    if (enterResult.appendText != null) {
                        indentation = (String)indentation + enterResult.appendText;
                    }
                    return Strings.getLeadingWhitespace((String)indentation);
                }
            }
            if (indentRulesSupport.shouldDecrease(lineContent)) {
                if (indent.action == EnterAction.IndentAction.Indent) {
                    return indent.indentation;
                }
                return indentConverter.unshiftIndent(indent.indentation);
            }
            if (indent.action == EnterAction.IndentAction.Indent) {
                return indentConverter.shiftIndent(indent.indentation);
            }
            return indent.indentation;
        }
        return null;
    }

    public static @Nullable IndentForEnter getIndentForEnter(IDocument doc, int offset, IIndentConverter indentConverter, IndentRulesSupport indentRulesSupport) {
        try {
            int lineIndex = doc.getLineOfOffset(offset);
            int lineLength = doc.getLineLength(lineIndex);
            int lineStartOffset = doc.getLineOffset(lineIndex);
            String beforeEnterText = doc.get(lineStartOffset, offset - lineStartOffset);
            String afterEnterText = doc.get(offset, lineLength - (offset - lineStartOffset));
            String beforeEnterResult = beforeEnterText;
            String beforeEnterIndent = Strings.getLeadingWhitespace(beforeEnterText);
            IVirtualModel virtualModel = theLineIndex -> {
                if (theLineIndex == lineIndex) {
                    return beforeEnterResult;
                }
                return DocumentHelper.getLineText((IDocument)doc, (int)theLineIndex, (boolean)false);
            };
            InheritedIndentation afterEnterAction = IndentForEnterHelper.getInheritIndentForLine(virtualModel, true, lineIndex + 1, indentRulesSupport);
            if (afterEnterAction == null) {
                String beforeEnter = beforeEnterIndent;
                return new IndentForEnter(beforeEnter, beforeEnter);
            }
            String afterEnterIndent = afterEnterAction.indentation;
            if (afterEnterAction.action == EnterAction.IndentAction.Indent) {
                afterEnterIndent = indentConverter.shiftIndent(afterEnterIndent);
            }
            if (indentRulesSupport.shouldDecrease(afterEnterText)) {
                afterEnterIndent = indentConverter.unshiftIndent(afterEnterIndent);
            }
            return new IndentForEnter(beforeEnterIndent, afterEnterIndent);
        }
        catch (RuntimeException | BadLocationException ex) {
            return null;
        }
    }

    private IndentForEnterHelper() {
    }

    public static interface IIndentConverter {
        public static IIndentConverter of(final CursorConfiguration cursorCfg) {
            return new IIndentConverter(){

                @Override
                public String shiftIndent(String indentation) {
                    return indentation + "\t";
                }

                @Override
                public String unshiftIndent(String indentation) {
                    return cursorCfg.outdentString(indentation);
                }

                @Override
                public String normalizeIndentation(String indent) {
                    return cursorCfg.normalizeIndentation(indent);
                }
            };
        }

        public String shiftIndent(String var1);

        public String unshiftIndent(String var1);

        public String normalizeIndentation(String var1);
    }

    public static interface IVirtualModel {
        public String getLineContent(int var1) throws BadLocationException;
    }

    private static final class InheritedIndentation {
        static final InheritedIndentation EMPTY = new InheritedIndentation("", null);
        final String indentation;
        final @Nullable EnterAction.IndentAction action;
        final @Nullable Integer lineIndex;

        InheritedIndentation(String indentation, @Nullable EnterAction.IndentAction action) {
            this.indentation = indentation;
            this.action = action;
            this.lineIndex = null;
        }

        InheritedIndentation(String indentation, @Nullable EnterAction.IndentAction action, int lineIndex) {
            this.indentation = indentation;
            this.action = action;
            this.lineIndex = lineIndex;
        }
    }
}

