/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.cdo.lm.SystemElement;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.ModelReference;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public interface TopicContainer
extends SystemElement {
    public Review getReview();

    public EList<Comment> getComments();

    public int getTopicCount();

    public int getUnresolvedCount();

    public int getResolvedCount();

    public EList<Topic> getTopics();

    default public EList<Topic> getTopics(ModelReference modelReference) {
        BasicEList result = new BasicEList();
        this.forEachTopic(arg_0 -> TopicContainer.lambda$0(modelReference, (EList)result, arg_0));
        return result;
    }

    default public Topic getTopic(ModelReference modelReference) {
        Topic[] result = new Topic[1];
        this.forEachTopic(topic -> {
            if (Objects.equals(topic.getModelReference(), modelReference)) {
                topicArray[0] = topic;
                return false;
            }
            return true;
        });
        return result[0];
    }

    default public boolean forEachTopic(Predicate<Topic> consumer) {
        for (Topic topic : this.getTopics()) {
            if (topic.forEachTopic(consumer)) continue;
            return false;
        }
        return true;
    }

    default public boolean forEachComment(Predicate<Comment> consumer) {
        for (Comment comment : this.getComments()) {
            if (consumer.test(comment)) continue;
            return false;
        }
        return this.forEachTopic(topic -> topic.forEachComment(consumer));
    }

    private static /* synthetic */ boolean lambda$0(ModelReference modelReference, EList eList, Topic topic) {
        if (Objects.equals(topic.getModelReference(), modelReference)) {
            eList.add((Object)topic);
        }
        return true;
    }
}

