/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.configuration;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.ForwardingCompareConfiguration;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.impl.AdapterFactoryChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.impl.CompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.impl.ComparisonAndScopeChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.impl.DiffRelationshipComputerChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.impl.EMFComparatorChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.impl.MergePreviewModeChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDeactivableDiffFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;

public class EMFCompareConfiguration
extends ForwardingCompareConfiguration
implements IEMFCompareConfiguration {
    private static final String COMPARE_RESULT = "org.eclipse.emf.compare.ide.ui.COMPARE_RESULT";
    private static final String COMPARATOR = "org.eclipse.emf.compare.ide.ui.COMPARATOR";
    private static final String EDITING_DOMAIN = "org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN";
    private static final String ADAPTER_FACTORY = "org.eclipse.emf.compare.ide.ui.ADAPTER_FACTORY";
    private static final String DIFF_RELATIONSHIP_COMPUTER = "org.eclipse.emf.compare.ide.ui.DIFF_RELATIONSHIP_COMPUTER";
    private static final String PREVIEW_MERGE_MODE = "org.eclipse.emf.compare.ide.ui.PREVIEW_MERGE_MODE";
    private static final String COMPARISON_SCOPE = "org.eclipse.emf.compare.ide.ui.COMPARISON_SCOPE";
    private static final String SMV_FILTERS = "org.eclipse.emf.compare.ide.ui.SMV_FILTERS";
    private static final String EVENT_BUS = "org.eclipse.emf.compare.ide.ui.EVENT_BUS";
    private static final String SMV_GROUP_PROVIDERS = "org.eclipse.emf.compare.ide.ui.SMV_GROUP_PROVIDERS";
    public static final String DISPLAY_GROUP_PROVIDERS = "org.eclipse.emf.compare.ide.ui.DISPLAY_GROUP_PROVIDERS";
    public static final String DISPLAY_FILTERS = "org.eclipse.emf.compare.ide.ui.DISPLAY_FILTERS";
    public static final String DISPLAY_SAVE_ACTION = "org.eclipse.emf.compare.ide.ui.DISPLAY_SAVE_ACTION";
    public static final String DISPLAY_SELECT_UNRESOLVED_DIFF_ACTIONS = "org.eclipse.emf.compare.ide.ui.DISPLAY_SELECT_UNRESOLVED_DIFF_ACTIONS";
    public static final String MIRRORED = "MIRRORED";
    private final PropertyChangeListener propertyChangeListener;
    private final CompareConfiguration compareConfiguration;
    private final Map<Class<? extends ICompareInput>, ICompareInputLabelProvider> labelProviders = new HashMap<Class<? extends ICompareInput>, ICompareInputLabelProvider>();

    public EMFCompareConfiguration(CompareConfiguration compareConfiguration) {
        this.compareConfiguration = compareConfiguration;
        this.setDefaultValues();
        this.propertyChangeListener = new PropertyChangeListener();
        compareConfiguration.addPropertyChangeListener((IPropertyChangeListener)this.propertyChangeListener);
    }

    private void setDefaultValues() {
        EventBus eventBus = new EventBus();
        if (this.getProperty(SMV_FILTERS) == null) {
            this.setProperty(SMV_FILTERS, new StructureMergeViewerFilter(eventBus));
        }
        if (this.getProperty(SMV_GROUP_PROVIDERS) == null) {
            this.setProperty(SMV_GROUP_PROVIDERS, new StructureMergeViewerGrouper(eventBus));
        }
        if (this.getProperty(EVENT_BUS) == null) {
            this.setProperty(EVENT_BUS, eventBus);
        }
        if (this.getProperty(DISPLAY_GROUP_PROVIDERS) == null) {
            this.setProperty(DISPLAY_GROUP_PROVIDERS, Boolean.TRUE);
        }
        if (this.getProperty(DISPLAY_FILTERS) == null) {
            this.setProperty(DISPLAY_FILTERS, Boolean.TRUE);
        }
        if (this.getProperty(DISPLAY_SAVE_ACTION) == null) {
            this.setProperty(DISPLAY_SAVE_ACTION, Boolean.TRUE);
        }
        if (this.getProperty(DIFF_RELATIONSHIP_COMPUTER) == null) {
            this.setProperty(DIFF_RELATIONSHIP_COMPUTER, new DiffRelationshipComputer(EMFCompareRCPPlugin.getDefault().getMergerRegistry()));
        }
        if (this.getProperty(DISPLAY_SELECT_UNRESOLVED_DIFF_ACTIONS) == null) {
            this.setProperty(DISPLAY_SELECT_UNRESOLVED_DIFF_ACTIONS, Boolean.TRUE);
        }
    }

    public EventBus getEventBus() {
        return (EventBus)this.getProperty(EVENT_BUS);
    }

    @Override
    protected CompareConfiguration delegate() {
        return this.compareConfiguration;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeListeners();
        Comparison comparison = this.getComparison();
        this.disposeComparison();
        if (comparison != null) {
            comparison.eAdapters().clear();
        }
    }

    public void disposeListeners() {
        this.compareConfiguration.removePropertyChangeListener((IPropertyChangeListener)this.propertyChangeListener);
    }

    public void disposeComparison() {
        this.disposeListeners();
        this.compareConfiguration.setProperty(COMPARISON_SCOPE, null);
        this.compareConfiguration.setProperty(COMPARE_RESULT, null);
        this.compareConfiguration.setProperty(SMV_FILTERS, null);
        this.compareConfiguration.setProperty(EDITING_DOMAIN, null);
        this.compareConfiguration.setProperty(ADAPTER_FACTORY, null);
        this.compareConfiguration.setProperty(DIFF_RELATIONSHIP_COMPUTER, null);
        this.compareConfiguration.setProperty(SMV_GROUP_PROVIDERS, null);
        this.compareConfiguration.setProperty(PREVIEW_MERGE_MODE, null);
        this.compareConfiguration.setProperty(DISPLAY_GROUP_PROVIDERS, null);
        this.compareConfiguration.setProperty(DISPLAY_FILTERS, null);
        this.compareConfiguration.setProperty(DISPLAY_SAVE_ACTION, null);
        this.compareConfiguration.setProperty(DISPLAY_SELECT_UNRESOLVED_DIFF_ACTIONS, null);
    }

    public boolean getBooleanProperty(String key, boolean dflt) {
        Object value = this.getProperty(key);
        boolean ret = value instanceof Boolean ? (Boolean)value : dflt;
        return ret;
    }

    public Comparison getComparison() {
        return (Comparison)this.getProperty(COMPARE_RESULT);
    }

    public EMFCompare getEMFComparator() {
        return (EMFCompare)this.getProperty(COMPARATOR);
    }

    public ICompareEditingDomain getEditingDomain() {
        return (ICompareEditingDomain)this.getProperty(EDITING_DOMAIN);
    }

    public MergeMode getMergePreviewMode() {
        return (MergeMode)this.getProperty(PREVIEW_MERGE_MODE);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)this.getProperty(ADAPTER_FACTORY);
    }

    public IDiffRelationshipComputer getDiffRelationshipComputer() {
        return (IDiffRelationshipComputer)this.getProperty(DIFF_RELATIONSHIP_COMPUTER);
    }

    public IComparisonScope getComparisonScope() {
        return (IComparisonScope)this.getProperty(COMPARISON_SCOPE);
    }

    public void setEMFComparator(EMFCompare newComparator) {
        EMFCompare oldComparator = this.getEMFComparator();
        this.setProperty(COMPARATOR, newComparator);
        this.getEventBus().post((Object)new EMFComparatorChange(oldComparator, newComparator));
    }

    public void setEditingDomain(ICompareEditingDomain newValue) {
        ICompareEditingDomain oldValue = this.getEditingDomain();
        this.setProperty(EDITING_DOMAIN, newValue);
        this.getEventBus().post((Object)new CompareEditingDomainChange(oldValue, newValue));
    }

    public void setComparisonAndScope(Comparison newComparison, IComparisonScope newComparisonScope) {
        Comparison oldComparison = this.getComparison();
        IComparisonScope oldComparisonScope = this.getComparisonScope();
        this.setProperty(COMPARE_RESULT, newComparison);
        this.setProperty(COMPARISON_SCOPE, newComparisonScope);
        if (oldComparison == null && oldComparisonScope == null) {
            this.initStructureMergeViewerGroupProvider(newComparison, newComparisonScope);
            this.initStructureMergeViewerFilter(newComparison, newComparisonScope);
        }
        this.getEventBus().post((Object)new ComparisonAndScopeChange(oldComparison, newComparison, oldComparisonScope, newComparisonScope));
    }

    protected void initStructureMergeViewerGroupProvider(Comparison comparison, IComparisonScope comparisonScope) {
        EMFCompareRCPUIPlugin plugin = EMFCompareRCPUIPlugin.getDefault();
        IDifferenceGroupProvider.Descriptor.Registry groupProviderRegistry = plugin.getDifferenceGroupProviderRegistry();
        IDifferenceGroupProvider.Descriptor defaultGroupProvider = groupProviderRegistry.getDefaultGroupProvider(comparisonScope, comparison);
        IDifferenceGroupProvider defaultGroup = null;
        if (defaultGroupProvider != null) {
            defaultGroup = defaultGroupProvider.createGroupProvider();
        }
        if (defaultGroup == null) {
            defaultGroup = new DefaultGroupProvider();
        }
        this.getStructureMergeViewerGrouper().setProvider(defaultGroup);
    }

    protected void initStructureMergeViewerFilter(Comparison comparison, IComparisonScope comparisonScope) {
        EMFCompareRCPUIPlugin plugin = EMFCompareRCPUIPlugin.getDefault();
        IDifferenceFilter.Registry filterRegistry = plugin.getDifferenceFilterRegistry();
        Collection filters = filterRegistry.getFilters(comparisonScope, comparison);
        ArrayList selectedFilters = Lists.newArrayList();
        ArrayList unselectedFilters = Lists.newArrayList();
        ArrayList activeFilters = Lists.newArrayList();
        for (IDifferenceFilter filter : filters) {
            if (filter instanceof IDeactivableDiffFilter && !((IDeactivableDiffFilter)filter).isActive()) continue;
            if (filter.defaultSelected()) {
                selectedFilters.add(filter);
            } else {
                unselectedFilters.add(filter);
            }
            activeFilters.add(filter);
        }
        this.getStructureMergeViewerFilter().init((Collection)selectedFilters, (Collection)unselectedFilters, (Collection)activeFilters);
    }

    public void setMergePreviewMode(MergeMode previewMergeMode) {
        MergeMode oldValue = this.getMergePreviewMode();
        this.setProperty(PREVIEW_MERGE_MODE, previewMergeMode);
        this.getEventBus().post((Object)new MergePreviewModeChange(oldValue, previewMergeMode));
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        AdapterFactory oldValue = this.getAdapterFactory();
        this.setProperty(ADAPTER_FACTORY, adapterFactory);
        this.getEventBus().post((Object)new AdapterFactoryChange(oldValue, adapterFactory));
    }

    public void setDiffRelationshipComputer(IDiffRelationshipComputer diffRelationshipComputer) {
        IDiffRelationshipComputer oldValue = this.getDiffRelationshipComputer();
        this.setProperty(DIFF_RELATIONSHIP_COMPUTER, diffRelationshipComputer);
        this.getEventBus().post((Object)new DiffRelationshipComputerChange(oldValue, diffRelationshipComputer));
    }

    public StructureMergeViewerGrouper getStructureMergeViewerGrouper() {
        return (StructureMergeViewerGrouper)this.getProperty(SMV_GROUP_PROVIDERS);
    }

    public StructureMergeViewerFilter getStructureMergeViewerFilter() {
        return (StructureMergeViewerFilter)this.getProperty(SMV_FILTERS);
    }

    public void setLabelProvider(Class<? extends ICompareInput> inputType, ICompareInputLabelProvider labelProvider) {
        this.labelProviders.put(inputType, labelProvider);
    }

    @Override
    public String getLeftLabel(Object element) {
        String leftLabel;
        ICompareInputLabelProvider labelProvider = this.getLabelProviderForType(element);
        if (labelProvider != null && (leftLabel = labelProvider.getLeftLabel(element)) != null) {
            return leftLabel;
        }
        return super.getLeftLabel(element);
    }

    @Override
    public Image getLeftImage(Object element) {
        Image leftImage;
        ICompareInputLabelProvider labelProvider = this.getLabelProviderForType(element);
        if (labelProvider != null && (leftImage = labelProvider.getLeftImage(element)) != null) {
            return leftImage;
        }
        return super.getLeftImage(element);
    }

    @Override
    public String getRightLabel(Object element) {
        String rightLabel;
        ICompareInputLabelProvider labelProvider = this.getLabelProviderForType(element);
        if (labelProvider != null && (rightLabel = labelProvider.getRightLabel(element)) != null) {
            return rightLabel;
        }
        return super.getRightLabel(element);
    }

    @Override
    public Image getRightImage(Object element) {
        Image rightImage;
        ICompareInputLabelProvider labelProvider = this.getLabelProviderForType(element);
        if (labelProvider != null && (rightImage = labelProvider.getRightImage(element)) != null) {
            return rightImage;
        }
        return super.getRightImage(element);
    }

    @Override
    public String getAncestorLabel(Object element) {
        String ancestorLabel;
        ICompareInputLabelProvider labelProvider = this.getLabelProviderForType(element);
        if (labelProvider != null && (ancestorLabel = labelProvider.getAncestorLabel(element)) != null) {
            return ancestorLabel;
        }
        return super.getAncestorLabel(element);
    }

    @Override
    public Image getAncestorImage(Object element) {
        Image ancestorImage;
        ICompareInputLabelProvider labelProvider = this.getLabelProviderForType(element);
        if (labelProvider != null && (ancestorImage = labelProvider.getAncestorImage(element)) != null) {
            return ancestorImage;
        }
        return super.getLeftImage(element);
    }

    private ICompareInputLabelProvider getLabelProviderForType(Object element) {
        if (element instanceof ICompareInput) {
            return this.labelProviders.get(((ICompareInput)element).getClass());
        }
        return null;
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            EMFCompareConfiguration.this.fireChange(event.getProperty(), event.getOldValue(), event.getNewValue());
        }
    }
}

