/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import org.eclipse.egit.core.internal.signing.SigningSetup;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.util.StringUtils;

public class EGitGpgConfig
extends GpgConfig {
    private String exe;

    public EGitGpgConfig(Config config) {
        super(config);
    }

    public String getProgram() {
        GpgConfig.GpgFormat format = this.getKeyFormat();
        switch (format) {
            case OPENPGP: 
            case X509: {
                if (this.exe == null) {
                    this.exe = this.determineProgram(GpgConfig.GpgFormat.X509.equals((Object)format));
                }
                if (StringUtils.isEmptyOrNull((String)this.exe)) break;
                return this.exe;
            }
        }
        String fromConfig = super.getProgram();
        if (!StringUtils.isEmptyOrNull((String)fromConfig)) {
            return fromConfig;
        }
        return null;
    }

    private String determineProgram(boolean x509) {
        File f;
        if (SigningSetup.Signer.GPG.equals((Object)SigningSetup.getSigner()) && (f = GitSettings.getGpgExecutable()) != null) {
            String name;
            if (!x509) {
                return f.getAbsolutePath();
            }
            File parent = f.getParentFile();
            File gpgsm = new File(parent, name = f.getName().replace("gpg", "gpgsm"));
            if (gpgsm.isFile() && gpgsm.canExecute()) {
                return gpgsm.getAbsolutePath();
            }
        }
        return "";
    }
}

