/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.DTreeItemExpansionChangeCommand;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.RefreshTreeElementTask;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.AbstractDTreeItemRunnableWithProgress;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandAllDepthAdapter;

public class ExpandDTreeItemRunnableWithProgress
extends AbstractDTreeItemRunnableWithProgress {
    private final Map<DTreeItem, Integer> dTreeItemsWithDepth;

    public ExpandDTreeItemRunnableWithProgress(Session session, DTreeItem dTreeItem) {
        super(session, dTreeItem);
        this.dTreeItemsWithDepth = Map.of(dTreeItem, 0);
    }

    public ExpandDTreeItemRunnableWithProgress(Session session, Map<DTreeItem, Integer> dTreeItemsWithDepth, boolean all) {
        super(session, true, dTreeItemsWithDepth == null ? 0 : dTreeItemsWithDepth.size());
        this.dTreeItemsWithDepth = dTreeItemsWithDepth;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            String commandLabel = ExpandDTreeItemRunnableWithProgress.getCommandLabel(this.dTreeItemsWithDepth.keySet().iterator().next(), this.isCollapseOrExpandAll());
            monitor.beginTask(commandLabel, 1);
            CompoundCommand expandDTreeItemsCmd = new CompoundCommand(commandLabel);
            this.dTreeItemsWithDepth.forEach((dTreeItem, depth) -> expandDTreeItemsCmd.append((Command)ExpandDTreeItemRunnableWithProgress.getExpandCommandForDTreeItem(dTreeItem, this.getDomain(), this.getGlobalContext(), this.getSession().getSiriusPreferences().isAutoRefresh(), depth)));
            this.getCommandStack().execute((Command)expandDTreeItemsCmd);
            if (this.getCommandStack().getMostRecentCommand() != expandDTreeItemsCmd) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static CompoundCommand getExpandCommandForDTreeItem(DTreeItem dTreeItem, TransactionalEditingDomain domain, GlobalContext globalContext, boolean isAutoRefresh, int currentDepth) {
        CompoundCommand expandDTreeItemCmd = new CompoundCommand(MessageFormat.format(Messages.ExpandDTreeItemRunnableWithProgress_expandTreeItem, dTreeItem.getName()));
        ExpandAllDepthAdapter.createAdapterOnDTreeItem(dTreeItem, currentDepth + 1);
        expandDTreeItemCmd.append((Command)new DTreeItemExpansionChangeCommand(globalContext, domain, dTreeItem, (IProgressMonitor)new NullProgressMonitor(), true));
        if (!isAutoRefresh) {
            SiriusCommand result = new SiriusCommand(domain);
            result.getTasks().add(new RefreshTreeElementTask((EObject)dTreeItem));
            expandDTreeItemCmd.append((Command)result);
        }
        return expandDTreeItemCmd;
    }

    public static String getCommandLabel(DTreeItem dTreeItem, boolean isCollapseOrExpandAll) {
        return ExpandDTreeItemRunnableWithProgress.getCommandLabel(dTreeItem, Messages.ExpandDTreeItemRunnableWithProgress_expandTreeItem, Messages.ExpandDTreeItemRunnableWithProgress_expandAllTreeItems, isCollapseOrExpandAll);
    }
}

