/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManagerCore;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class ConstructorFromSuperclassProposalCore
extends LinkedCorrectionProposalCore {
    private TypeDeclaration fTypeNode;
    private IMethodBinding fSuperConstructor;

    public ConstructorFromSuperclassProposalCore(ICompilationUnit cu, TypeDeclaration typeNode, IMethodBinding superConstructor, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fTypeNode = typeNode;
        this.fSuperConstructor = superConstructor;
    }

    @Override
    public String getName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fTypeNode.getName().getIdentifier());
        buf.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] paramTypes = this.fSuperConstructor.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(paramTypes[i].getName());
                ++i;
            }
        }
        buf.append(')');
        return Messages.format(CorrectionMessages.ConstructorFromSuperclassProposal_description, BasicElementLabels.getJavaElementName(buf.toString()));
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fTypeNode.getRoot());
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit());
        if (!settings.createComments) {
            settings = null;
        }
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)this.fTypeNode, this.getImportRewrite());
        MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, this.fSuperConstructor, rewrite, importRewriteContext, settings);
        rewrite.getListRewrite((ASTNode)this.fTypeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethodDecl, null);
        this.addLinkedRanges(rewrite, newMethodDecl);
        return rewrite;
    }

    private void addLinkedRanges(ASTRewrite rewrite, MethodDeclaration newStub) {
        List parameters = newStub.parameters();
        for (SingleVariableDeclaration curr : parameters) {
            String name = curr.getName().getIdentifier();
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getType()), false, "arg_type_" + name);
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getName()), false, "arg_name_" + name);
        }
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, ImportRewrite.ImportRewriteContext importRewriteContext, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String name = this.fTypeNode.getName().getIdentifier();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(true);
        decl.setName(ast.newSimpleName(name));
        Block body = ast.newBlock();
        decl.setBody(body);
        SuperConstructorInvocation invocation = null;
        List parameters = decl.parameters();
        String[] paramNames = this.getArgumentNames(binding);
        ITypeBinding enclosingInstance = this.getEnclosingInstance();
        if (enclosingInstance != null) {
            invocation = this.addEnclosingInstanceAccess(rewrite, importRewriteContext, parameters, paramNames, enclosingInstance);
        }
        if (binding == null) {
            decl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        } else {
            decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, binding.getModifiers()));
            ITypeBinding[] params = binding.getParameterTypes();
            int i = 0;
            while (i < params.length) {
                AnnotatableType annotatedType;
                SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
                Type varType = this.getImportRewrite().addImport(params[i], ast, importRewriteContext, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
                var.setType(varType);
                var.setName(ast.newSimpleName(paramNames[i]));
                if (!(varType instanceof AnnotatableType) || (annotatedType = (AnnotatableType)varType).annotations().size() == 0) {
                    IAnnotationBinding[] annotations;
                    ITypeBinding[] paramTypes = binding.getParameterTypes();
                    IAnnotationBinding[] iAnnotationBindingArray = annotations = paramTypes[i].getTypeAnnotations();
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                        if (annotation.getDeclaredMemberValuePairs().length == 0) {
                            String annotationName = annotation.getName();
                            ITypeBinding annotationBinding = annotation.getAnnotationType();
                            String qualifiedName = annotationBinding.getQualifiedName();
                            this.getImportRewrite().addImport(qualifiedName, importRewriteContext);
                            MarkerAnnotation markerAnnotation = ast.newMarkerAnnotation();
                            markerAnnotation.setTypeName(ast.newName(annotationName));
                            List varModifiers = var.modifiers();
                            varModifiers.add(markerAnnotation);
                        }
                        ++n2;
                    }
                }
                parameters.add(var);
                ++i;
            }
            List thrownExceptions = decl.thrownExceptionTypes();
            ITypeBinding[] iTypeBindingArray = binding.getExceptionTypes();
            int n = iTypeBindingArray.length;
            int varType = 0;
            while (varType < n) {
                ITypeBinding t = iTypeBindingArray[varType];
                Type excType = this.getImportRewrite().addImport(t, ast, importRewriteContext, ImportRewrite.TypeLocation.EXCEPTION);
                thrownExceptions.add(excType);
                ++varType;
            }
            if (invocation == null) {
                invocation = ast.newSuperConstructorInvocation();
            }
            List arguments = invocation.arguments();
            String[] stringArray = paramNames;
            int n3 = paramNames.length;
            n = 0;
            while (n < n3) {
                String paramName = stringArray[n];
                SimpleName argument = ast.newSimpleName(paramName);
                arguments.add(argument);
                this.addLinkedPosition(rewrite.track((ASTNode)argument), false, "arg_name_" + paramName);
                ++n;
            }
        }
        String bodyStatement = invocation == null ? "" : ASTNodes.asFormattedString((ASTNode)invocation, 0, String.valueOf('\n'), FormatterProfileManagerCore.getProjectSettings(this.getCompilationUnit().getJavaProject()));
        String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), name, name, true, bodyStatement, String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), name, decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private SuperConstructorInvocation addEnclosingInstanceAccess(ASTRewrite rewrite, ImportRewrite.ImportRewriteContext importRewriteContext, List<SingleVariableDeclaration> parameters, String[] paramNames, ITypeBinding enclosingInstance) {
        AST ast = rewrite.getAST();
        SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
        SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
        var.setType(this.getImportRewrite().addImport(enclosingInstance, ast, importRewriteContext, ImportRewrite.TypeLocation.PARAMETER));
        String[] enclosingArgNames = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaProject(), enclosingInstance.getTypeDeclaration().getName(), 0, paramNames);
        String firstName = enclosingArgNames[0];
        var.setName(ast.newSimpleName(firstName));
        parameters.add(var);
        SimpleName enclosing = ast.newSimpleName(firstName);
        invocation.setExpression((Expression)enclosing);
        String key = "arg_name_" + firstName;
        this.addLinkedPosition(rewrite.track((ASTNode)enclosing), false, key);
        String[] stringArray = enclosingArgNames;
        int n = enclosingArgNames.length;
        int n2 = 0;
        while (n2 < n) {
            String enclosingArgName = stringArray[n2];
            this.addLinkedPositionProposal(key, enclosingArgName);
            ++n2;
        }
        return invocation;
    }

    private ITypeBinding getEnclosingInstance() {
        ITypeBinding currBinding = this.fTypeNode.resolveBinding();
        if (currBinding == null || Modifier.isStatic((int)currBinding.getModifiers())) {
            return null;
        }
        ITypeBinding superBinding = currBinding.getSuperclass();
        if (superBinding == null || superBinding.getDeclaringClass() == null || Modifier.isStatic((int)superBinding.getModifiers())) {
            return null;
        }
        ITypeBinding enclosing = superBinding.getDeclaringClass();
        while (currBinding != null) {
            if (Bindings.isSuperType(enclosing, currBinding)) {
                return null;
            }
            if (Modifier.isStatic((int)currBinding.getModifiers())) {
                return null;
            }
            currBinding = currBinding.getDeclaringClass();
        }
        return enclosing;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        if (binding == null) {
            return new String[0];
        }
        return StubUtility.suggestArgumentNames(this.getCompilationUnit().getJavaProject(), binding);
    }
}

