/*
 * Copyright (c) 2011, 2012, 2015, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.common.revision;

import org.eclipse.emf.cdo.common.id.CDOID;

import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * A strategy that specifies which list elememts must be present (loaded) in a {@link CDOID} list of a
 * {@link CDORevision revision} when a certain list index is accessed. Implementations of this interface can control the
 * exact characteristics of a certain <em>partial collection loading</em> strategy.
 *
 * @author Eike Stepper
 * @since 4.0
 */
public interface CDOListResolver
{
  /**
   * Defines a strategy to be used when the collection needs to resolve one element.
   */
  public Object resolveProxy(CDORevision revision, EStructuralFeature feature, int accessIndex, int serverIndex);

  /**
   * Defines a strategy to be used when the collection needs to resolve all elements.
   */
  public void resolveAllProxies(CDORevision revision, EStructuralFeature feature);
}
