/*
 * Copyright (c) 2008, 2011, 2012, 2015, 2016, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.net4j.util.security;

import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;

/**
 * @author Eike Stepper
 */
public class ChallengeNegotiatorConfigurer implements IElementProcessor
{
  public ChallengeNegotiatorConfigurer()
  {
  }

  @Override
  public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element)
  {
    if (element instanceof ChallengeNegotiator)
    {
      ChallengeNegotiator negotiator = (ChallengeNegotiator)element;
      if (negotiator.getRandomizer() == null)
      {
        IRandomizer randomizer = getRandomizer(container, description);
        negotiator.setRandomizer(randomizer);
      }

      if (negotiator.getUserManager() == null)
      {
        IUserManager userManager = getUserManager(container, description);
        negotiator.setUserManager(userManager);
      }
    }

    return element;
  }

  protected IRandomizer getRandomizer(IManagedContainer container, String description)
  {
    String productGroup = RandomizerFactory.PRODUCT_GROUP;
    String type = getRandomizerType(description);
    return (IRandomizer)container.getElement(productGroup, type, getRandomizerDescription(description));
  }

  protected String getRandomizerType(String description)
  {
    return RandomizerFactory.TYPE;
  }

  protected String getRandomizerDescription(String description)
  {
    return null;
  }

  protected IUserManager getUserManager(IManagedContainer container, String description)
  {
    String productGroup = FileUserManagerFactory.PRODUCT_GROUP;
    String type = getUserManagerType(description);
    return (IUserManager)container.getElement(productGroup, type, getUserManagerDescription(description));
  }

  protected String getUserManagerType(String description)
  {
    return FileUserManagerFactory.TYPE;
  }

  protected String getUserManagerDescription(String description)
  {
    return description;
  }
}
