/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.parts;

import java.util.ArrayList;
import org.eclipse.php.composer.ui.parts.IBooleanFormEntryListener;
import org.eclipse.php.composer.ui.utils.WidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BooleanFormEntry {
    private boolean enabled = true;
    private Label label;
    private Button checkbox;
    private boolean ignoreNotify = false;
    private ArrayList<IBooleanFormEntryListener> listeners = new ArrayList();

    public BooleanFormEntry(Composite parent, FormToolkit toolkit, String labelText) {
        this(parent, toolkit, labelText, 0x800000);
    }

    public BooleanFormEntry(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.createControl(parent, toolkit, labelText, style);
    }

    public Label getLabel() {
        return this.label;
    }

    public Button getCheckbox() {
        return this.checkbox;
    }

    public boolean getValue() {
        return this.checkbox.getSelection();
    }

    public void setValue(boolean value) {
        this.checkbox.setSelection(value);
    }

    public void setValue(boolean value, boolean ignoreNotify) {
        this.ignoreNotify = ignoreNotify;
        this.setValue(value);
        this.ignoreNotify = false;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.checkbox.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addBooleanFormEntryListener(IBooleanFormEntryListener listener) {
        this.listeners.add(listener);
    }

    public void removeBooleanFormEntryListener(IBooleanFormEntryListener listener) {
        this.listeners.remove(listener);
    }

    private void createControl(Composite parent, FormToolkit toolkit, String labelText, int style) {
        if (labelText != null) {
            this.label = toolkit.createLabel(parent, labelText);
            this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        this.checkbox = WidgetFactory.createButton(toolkit, parent, style | 0x20);
        this.addListener();
        this.fillIntoGrid(parent);
    }

    private void addListener() {
        this.checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BooleanFormEntry.this.ignoreNotify) {
                    return;
                }
                for (IBooleanFormEntryListener listener : BooleanFormEntry.this.listeners) {
                    listener.selectionChanged(BooleanFormEntry.this);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void fillIntoGrid(Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd;
            int span = ((GridLayout)layout).numColumns;
            if (this.label != null) {
                gd = new GridData(4);
                this.label.setLayoutData((Object)gd);
                --span;
            }
            gd = new GridData(256);
            gd.horizontalSpan = span;
            if (this.label != null) {
                gd.horizontalIndent = 3;
            }
            gd.grabExcessHorizontalSpace = span == 1;
            gd.widthHint = 10;
            this.checkbox.setLayoutData((Object)gd);
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData td;
            int span = ((TableWrapLayout)layout).numColumns;
            if (this.label != null) {
                td = new TableWrapData();
                td.valign = 32;
                this.label.setLayoutData((Object)td);
                --span;
            }
            td = new TableWrapData(128);
            td.colspan = span;
            if (this.label != null) {
                td.indent = 3;
            }
            td.grabHorizontal = span == 1;
            td.valign = 32;
            this.checkbox.setLayoutData((Object)td);
        }
    }
}

