/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class AutoscalingAccess {
    @Deprecated(since="2026-03", forRemoval=true)
    private static final String DATA_SHELL_ZOOM = "SHELL_ZOOM";
    @Deprecated(since="2026-03", forRemoval=true)
    private static final String DATA_AUTOSCALE_DISABLED = "AUTOSCALE_DISABLED";
    @Deprecated(since="2026-03", forRemoval=true)
    private static final String DATA_PROPOGATE_AUTOSCALE_DISABLED = "PROPOGATE_AUTOSCALE_DISABLED";
    private static final Set<Control> propagationDisabledControls = new HashSet<Control>();
    private static MethodHandle GETSHELLZOOM_HANDLE;
    private static MethodHandle SET_AUTOSCALINGMODE_HANDLE;
    private static Object AUTOSCALING_MODE_DISABLED_INHERITED;
    private static Object AUTOSCALING_MODE_DISABLED;

    static {
        try {
            GETSHELLZOOM_HANDLE = MethodHandles.publicLookup().findVirtual(Shell.class, "getZoom", MethodType.methodType(Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        try {
            Class<Enum> autoscalingModeEnumClass = Class.forName("org.eclipse.swt.graphics.AutoscalingMode").asSubclass(Enum.class);
            Objects.requireNonNull(autoscalingModeEnumClass);
            AUTOSCALING_MODE_DISABLED_INHERITED = Enum.valueOf(autoscalingModeEnumClass, "DISABLED_INHERITED");
            Objects.requireNonNull(AUTOSCALING_MODE_DISABLED_INHERITED);
            AUTOSCALING_MODE_DISABLED = Enum.valueOf(autoscalingModeEnumClass, "DISABLED");
            Objects.requireNonNull(AUTOSCALING_MODE_DISABLED);
            MethodType mt = MethodType.methodType(Boolean.TYPE, autoscalingModeEnumClass);
            SET_AUTOSCALINGMODE_HANDLE = MethodHandles.publicLookup().findVirtual(Control.class, "setAutoscalingMode", mt);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    AutoscalingAccess() {
    }

    static void setAutoscaleDisabled(Control control) {
        if (SET_AUTOSCALINGMODE_HANDLE != null) {
            Object disablementMode = propagationDisabledControls.contains(control) ? AUTOSCALING_MODE_DISABLED : AUTOSCALING_MODE_DISABLED_INHERITED;
            try {
                SET_AUTOSCALINGMODE_HANDLE.invoke(control, disablementMode);
            }
            catch (Throwable e) {
                throw new SWTException(e.getMessage());
            }
        } else {
            control.setData(DATA_AUTOSCALE_DISABLED, (Object)true);
        }
    }

    static void disablePropagateAutoscale(Control control) {
        if (SET_AUTOSCALINGMODE_HANDLE != null) {
            propagationDisabledControls.add(control);
            control.addDisposeListener(e -> {
                boolean bl = propagationDisabledControls.remove(control);
            });
        } else {
            control.setData(DATA_PROPOGATE_AUTOSCALE_DISABLED, (Object)false);
        }
    }

    static int getShellZoom(Control control) {
        int shellZoom;
        block5: {
            try {
                if (GETSHELLZOOM_HANDLE != null) {
                    try {
                        shellZoom = GETSHELLZOOM_HANDLE.invoke(control.getShell());
                        break block5;
                    }
                    catch (Throwable e) {
                        throw new SWTException(e.getMessage());
                    }
                }
                shellZoom = (Integer)control.getData(DATA_SHELL_ZOOM);
            }
            catch (NullPointerException e) {
                shellZoom = 100;
            }
        }
        return shellZoom;
    }
}

