/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONStructure;
import org.eclipse.wst.json.core.internal.document.JSONObjectImpl;

class JSONModelContext {
    private IJSONNode nextNode = null;
    private IJSONNode currentNode = null;
    private IJSONNode parentNode = null;
    private IJSONNode rootNode = null;

    JSONModelContext(IJSONNode rootNode) {
        this.rootNode = rootNode;
    }

    IJSONObject findParentObject() {
        if (this.parentNode != null && this.parentNode.getNodeType() == 0) {
            return (IJSONObject)this.parentNode;
        }
        return null;
    }

    IJSONArray findParentArray() {
        if (this.parentNode != null && this.parentNode.getNodeType() == 1) {
            return (IJSONArray)this.parentNode;
        }
        return null;
    }

    IJSONStructure findParentStructure() {
        if (this.parentNode != null && (this.parentNode.getNodeType() == 0 || this.parentNode.getNodeType() == 1)) {
            return (IJSONStructure)this.parentNode;
        }
        return null;
    }

    IJSONNode getCurrentNode() {
        return this.currentNode;
    }

    IJSONNode getNextNode() {
        return this.nextNode;
    }

    IJSONNode getParentNode() {
        return this.parentNode;
    }

    IJSONNode getRootNode() {
        return this.rootNode;
    }

    void setLast() {
        if (this.parentNode == null) {
            return;
        }
        if (this.nextNode != null) {
            IJSONNode prev = this.nextNode.getPreviousSibling();
            if (prev == null || prev.getNodeType() != 0) {
                return;
            }
            JSONObjectImpl element = (JSONObjectImpl)prev;
            if (element.hasEndTag() || !element.isContainer() || element.isEmptyTag()) {
                return;
            }
            this.setParentNode(prev);
        }
        IJSONNode parent = this.parentNode;
        IJSONNode last = parent.getLastChild();
        while (last != null) {
            JSONObjectImpl element;
            if (last.getNodeType() != 0 || (element = (JSONObjectImpl)last).hasEndTag() || !element.isContainer() || element.isEmptyTag()) break;
            parent = element;
            last = parent.getLastChild();
        }
        if (parent != this.parentNode) {
            this.setParentNode(parent);
        }
    }

    void setCurrentNode(IJSONNode currentNode) {
        this.currentNode = currentNode;
        if (currentNode == null) {
            return;
        }
        this.parentNode = currentNode.getParentNode();
        this.nextNode = currentNode.getNextSibling();
    }

    void setParentNode(IJSONNode parentNode) {
        this.parentNode = parentNode;
        this.nextNode = null;
    }
}

