/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class LinkIconFigure
extends Polygon {
    private AbstractGraphicalEditPart editPart;
    private Point figLocation;
    private PointList points = new PointList();
    public int horizontalBuffer = 5;
    public int verticalBuffer = 7;

    public LinkIconFigure(AbstractGraphicalEditPart ep) {
        this.editPart = ep;
        this.points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 9, 4 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 9, 0 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 14, 5 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 9, 10 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 9, 6 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 0, 6 + this.verticalBuffer));
        this.points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
        this.setFill(true);
        this.setPoints(this.points);
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
    }

    public void setFigureLocation(Point newStartingLocation) {
        int dy = newStartingLocation.y;
        if (this.figLocation != null) {
            dy = newStartingLocation.y - this.figLocation.y;
        }
        PointList newPoints = new PointList();
        PointList pList = this.getPoints();
        int index = 0;
        while (index < pList.size()) {
            Point point = pList.getPoint(index);
            Point newPoint = new Point(point.x + this.horizontalBuffer, point.y + dy);
            newPoints.addPoint(newPoint);
            ++index;
        }
        this.setPoints(newPoints);
        this.figLocation = newStartingLocation;
    }

    public void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
        PointList pList = this.getPoints();
        PointList newList = new PointList();
        int index = 0;
        while (index < pList.size()) {
            Point point = pList.getPoint(index);
            Point newPoint = new Point(point.x + dx, point.y);
            newList.addPoint(newPoint);
            ++index;
        }
        this.setPoints(newList);
        if (this.useLocalCoordinates()) {
            this.fireCoordinateSystemChanged();
            return;
        }
    }

    public AbstractGraphicalEditPart getAssociatedEditPart() {
        return this.editPart;
    }
}

