/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.jupiter.engine.extension.DefaultRepetitionInfo;

class RepetitionExtension
implements ParameterResolver,
TestWatcher,
ExecutionCondition {
    private final DefaultRepetitionInfo repetitionInfo;

    RepetitionExtension(DefaultRepetitionInfo repetitionInfo) {
        this.repetitionInfo = repetitionInfo;
    }

    public TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == RepetitionInfo.class;
    }

    public RepetitionInfo resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.repetitionInfo;
    }

    public void testFailed(ExtensionContext context, @Nullable Throwable cause) {
        this.repetitionInfo.failureCount().incrementAndGet();
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        int failureThreshold = this.repetitionInfo.getFailureThreshold();
        if (this.repetitionInfo.getFailureCount() >= failureThreshold) {
            return ConditionEvaluationResult.disabled((String)("Failure threshold [" + failureThreshold + "] exceeded"));
        }
        return ConditionEvaluationResult.enabled((String)"Failure threshold not exceeded");
    }
}

