/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.lemminx.commons.ModelTextDocument;

public class ModelValidatorDelayer<T> {
    private static final long DEFAULT_VALIDATION_DELAY_MS = 500L;
    private final ScheduledExecutorService executorService;
    private final Consumer<ModelTextDocument<T>> validator;
    private final Map<String, Future<?>> pendingValidationRequests;
    private final long validationDelayMs;

    public ModelValidatorDelayer(Consumer<ModelTextDocument<T>> validator) {
        this(Executors.newScheduledThreadPool(2), validator, 500L);
    }

    public ModelValidatorDelayer(ScheduledExecutorService executorService, Consumer<ModelTextDocument<T>> validator, long validationDelayMs) {
        this.executorService = executorService;
        this.validator = validator;
        this.pendingValidationRequests = new HashMap();
        this.validationDelayMs = validationDelayMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateWithDelay(ModelTextDocument<T> document) {
        String uri = document.getUri();
        this.cleanPendingValidation(uri);
        int version = document.getVersion();
        ScheduledFuture<?> request = this.executorService.schedule(() -> {
            Map<String, Future<?>> map = this.pendingValidationRequests;
            synchronized (map) {
                this.pendingValidationRequests.remove(uri);
            }
            if (version == document.getVersion()) {
                this.validator.accept(document);
            }
        }, this.validationDelayMs, TimeUnit.MILLISECONDS);
        Map<String, Future<?>> map = this.pendingValidationRequests;
        synchronized (map) {
            this.pendingValidationRequests.put(uri, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanPendingValidation(String uri) {
        Map<String, Future<?>> map = this.pendingValidationRequests;
        synchronized (map) {
            Future<?> request = this.pendingValidationRequests.get(uri);
            if (request != null) {
                request.cancel(true);
                this.pendingValidationRequests.remove(uri);
            }
        }
    }
}

