/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class cvc_complex_type_4CodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        Range range = request.getRange();
        if (diagnostic == null) {
            return;
        }
        if (this.codeAlreadyActionExists(codeActions, diagnostic)) {
            return;
        }
        Range diagnosticRange = diagnostic.getRange();
        try {
            int offset = document.offsetAt(range.getStart());
            DOMNode node = document.findNodeAt(offset);
            if (!node.isElement()) {
                return;
            }
            SharedSettings sharedSettings = request.getSharedSettings();
            DOMElement element = (DOMElement)node;
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
                CMElementDeclaration elementDeclaration = cmDocument.findCMElement(element);
                if (elementDeclaration == null) continue;
                List<CMAttributeDeclaration> requiredAttributes = elementDeclaration.getAttributes().stream().filter(CMAttributeDeclaration::isRequired).filter(cmAttr -> !element.hasAttribute(cmAttr.getLocalName())).collect(Collectors.toList());
                boolean supportSnippet = false;
                XMLGenerator generator = new XMLGenerator(sharedSettings, "", "", supportSnippet, 0);
                String xmlAttributes = generator.generate(requiredAttributes, element.getTagName());
                CodeAction insertRequiredAttributesAction = CodeActionFactory.insert("Insert required attributes", diagnosticRange.getEnd(), xmlAttributes, document.getTextDocument(), diagnostic);
                codeActions.add(insertRequiredAttributesAction);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean codeAlreadyActionExists(List<CodeAction> codeActions, Diagnostic diagnostic) {
        for (CodeAction codeAction : codeActions) {
            for (Diagnostic codeActionDiagnostic : codeAction.getDiagnostics()) {
                if (!codeActionDiagnostic.getCode().equals(diagnostic.getCode()) || !codeActionDiagnostic.getRange().equals(diagnostic.getRange())) continue;
                return true;
            }
        }
        return false;
    }
}

