/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.utils;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.util.URI;
import org.apache.xerces.xs.StringList;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.URIUtils;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDUtils {
    public static final String SCHEMA_LOCATION_ATTR = "schemaLocation";
    public static final String TARGET_NAMESPACE_ATTR = "targetNamespace";
    public static final String NAMESPACE_ATTR = "namespace";
    public static final String XS_IMPORT_TAG = "xs:import";
    public static final String XS_SCHEMA_TAG = "xs:schema";

    public static BindingType getBindingType(DOMAttr originAttr) {
        if (originAttr != null) {
            String name = originAttr.getName();
            if ("type".equals(name)) {
                if ("attribute".equals(originAttr.getOwnerElement().getLocalName())) {
                    return BindingType.SIMPLE;
                }
                return BindingType.COMPLEX_AND_SIMPLE;
            }
            if ("base".equals(name)) {
                DOMElement element = originAttr.getOwnerElement();
                DOMElement parent = element.getParentElement();
                if (parent != null) {
                    if (parent.getLocalName().equals("complexContent") || XSDUtils.isXSComplexType(parent)) {
                        return BindingType.COMPLEX;
                    }
                    if (parent.getLocalName().equals("simpleContent") || XSDUtils.isXSSimpleType(parent)) {
                        return BindingType.SIMPLE;
                    }
                }
                return BindingType.NONE;
            }
            if ("ref".equals(name)) {
                return BindingType.REF;
            }
            if ("itemType".equals(name)) {
                return BindingType.COMPLEX_AND_SIMPLE;
            }
            if ("memberTypes".equals(name)) {
                return BindingType.COMPLEX_AND_SIMPLE;
            }
            if ("substitutionGroup".equals(name)) {
                return BindingType.ELEMENT;
            }
        }
        return BindingType.NONE;
    }

    public static void searchXSTargetAttributes(DOMAttr originAttr, BindingType bindingType, boolean matchAttr, boolean searchInExternalSchema, BiConsumer<String, DOMAttr> collector) {
        DOMElement documentElement;
        if (bindingType == BindingType.NONE) {
            return;
        }
        DOMDocument document = originAttr.getOwnerDocument();
        DOMElement dOMElement = documentElement = document != null ? document.getDocumentElement() : null;
        if (documentElement == null) {
            return;
        }
        String originAttrValue = originAttr.getValue();
        if (matchAttr && StringUtils.isEmpty(originAttrValue)) {
            return;
        }
        String targetNamespacePrefix = null;
        int index = originAttrValue.indexOf(58);
        if (index != -1) {
            targetNamespacePrefix = originAttrValue.substring(0, index);
        } else {
            String targetNamespace = documentElement.getAttribute(TARGET_NAMESPACE_ATTR);
            targetNamespacePrefix = documentElement.getPrefix(targetNamespace);
        }
        String originName = null;
        if (matchAttr) {
            originName = XSDUtils.getOriginName(originAttrValue, targetNamespacePrefix);
        }
        XSDUtils.searchXSTargetAttributes(originAttr, bindingType, matchAttr, collector, documentElement, targetNamespacePrefix, originName, new HashSet<String>(), searchInExternalSchema);
    }

    private static void searchXSTargetAttributes(DOMAttr originAttr, BindingType bindingType, boolean matchAttr, BiConsumer<String, DOMAttr> collector, DOMElement documentElement, String targetNamespacePrefix, String originName, Set<String> visitedURIs, boolean searchInExternalSchema) {
        DOMDocument document = documentElement.getOwnerDocument();
        String documentURI = document.getDocumentURI();
        if (visitedURIs.contains(documentURI)) {
            return;
        }
        visitedURIs.add(documentURI);
        HashSet<String> externalURIS = null;
        NodeList children = documentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String schemaLocation;
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element targetElement = (Element)node;
            if (XSDUtils.isBounded(originAttr.getOwnerElement(), bindingType, targetElement)) {
                DOMAttr targetAttr = (DOMAttr)targetElement.getAttributeNode("name");
                if (targetAttr == null || matchAttr && !Objects.equal(originName, targetAttr.getValue())) continue;
                collector.accept(targetNamespacePrefix, targetAttr);
                continue;
            }
            if (!XSDUtils.isXSInclude(targetElement) && !XSDUtils.isXSImport(targetElement) || (schemaLocation = targetElement.getAttribute(SCHEMA_LOCATION_ATTR)) == null) continue;
            if (externalURIS == null) {
                externalURIS = new HashSet<String>();
            }
            externalURIS.add(schemaLocation);
        }
        if (searchInExternalSchema && externalURIS != null) {
            URIResolverExtensionManager resolverExtensionManager = document.getResolverExtensionManager();
            for (String externalURI : externalURIS) {
                DOMDocument externalDocument;
                String resourceURI = resolverExtensionManager.resolve(documentURI, null, externalURI);
                if (!URIUtils.isFileResource(resourceURI) || (externalDocument = DOMUtils.loadDocument(resourceURI, document.getResolverExtensionManager())) == null) continue;
                XSDUtils.searchXSTargetAttributes(originAttr, bindingType, matchAttr, collector, externalDocument.getDocumentElement(), targetNamespacePrefix, originName, visitedURIs, searchInExternalSchema);
            }
        }
    }

    private static String getOriginName(String originAttrValue, String targetNamespacePrefix) {
        int index = originAttrValue.indexOf(":");
        if (index != -1) {
            String prefix = originAttrValue.substring(0, index);
            if (!Objects.equal(prefix, targetNamespacePrefix)) {
                return null;
            }
            return originAttrValue.substring(index + 1, originAttrValue.length());
        }
        return originAttrValue;
    }

    private static boolean isBounded(Element originElement, BindingType originBinding, Element targetElement) {
        if (XSDUtils.isXSComplexType(targetElement)) {
            return originBinding.isComplex();
        }
        if (XSDUtils.isXSSimpleType(targetElement)) {
            return originBinding.isSimple();
        }
        if (originBinding == BindingType.REF) {
            return originElement.getLocalName().equals(targetElement.getLocalName());
        }
        if (originBinding == BindingType.ELEMENT) {
            return XSDUtils.isXSElement(targetElement);
        }
        return false;
    }

    public static void searchXSOriginAttributes(DOMNode targetNode, BiConsumer<DOMAttr, DOMAttr> collector, CancelChecker cancelChecker) {
        List<DOMAttr> targetAttrs = XSDUtils.getTargetAttrs(targetNode);
        if (targetAttrs.isEmpty()) {
            return;
        }
        DOMDocument document = targetNode.getOwnerDocument();
        DOMElement documentElement = document.getDocumentElement();
        String targetNamespace = documentElement.getAttribute(TARGET_NAMESPACE_ATTR);
        String targetNamespacePrefix = documentElement.getPrefix(targetNamespace);
        NodeList nodes = documentElement.getChildNodes();
        XSDUtils.searchXSOriginAttributes(nodes, targetAttrs, targetNamespacePrefix, collector, cancelChecker);
    }

    private static List<DOMAttr> getTargetAttrs(DOMNode referencedNode) {
        if (referencedNode == null) {
            return Collections.emptyList();
        }
        ArrayList<DOMAttr> referencedNodes = new ArrayList<DOMAttr>();
        DOMDocument document = referencedNode.getOwnerDocument();
        switch (referencedNode.getNodeType()) {
            case 1: 
            case 2: {
                XSDUtils.addTargetNode(referencedNode, referencedNodes);
                break;
            }
            case 9: {
                Element documentElement = document.getDocumentElement();
                if (documentElement == null) break;
                NodeList nodes = documentElement.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    DOMElement element;
                    Node n = nodes.item(i);
                    if (n.getNodeType() != 1 || !XSDUtils.isXSTargetElement(element = (DOMElement)n)) continue;
                    XSDUtils.addTargetNode(element, referencedNodes);
                }
                break;
            }
        }
        return referencedNodes;
    }

    private static void addTargetNode(DOMNode node, List<DOMAttr> targetAttrs) {
        DOMAttr attr = null;
        switch (node.getNodeType()) {
            case 2: {
                attr = (DOMAttr)node;
                break;
            }
            case 1: {
                attr = ((DOMElement)node).getAttributeNode("name");
            }
        }
        if (attr != null && !StringUtils.isEmpty(attr.getValue())) {
            targetAttrs.add(attr);
        }
    }

    private static void searchXSOriginAttributes(NodeList nodes, List<DOMAttr> targetAttrs, String targetNamespacePrefix, BiConsumer<DOMAttr, DOMAttr> collector, CancelChecker cancelChecker) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            DOMElement originElement;
            NamedNodeMap originAttributes;
            Node node;
            if (cancelChecker != null) {
                cancelChecker.checkCanceled();
            }
            if ((node = nodes.item(i)).getNodeType() == 1 && (originAttributes = (originElement = (DOMElement)node).getAttributes()) != null) {
                for (int j = 0; j < originAttributes.getLength(); ++j) {
                    DOMAttr originAttr = (DOMAttr)originAttributes.item(j);
                    BindingType originBnding = XSDUtils.getBindingType(originAttr);
                    if (originBnding == BindingType.NONE) continue;
                    String originName = XSDUtils.getOriginName(originAttr.getValue(), targetNamespacePrefix);
                    for (DOMAttr targetAttr : targetAttrs) {
                        DOMElement targetElement = targetAttr.getOwnerElement();
                        if (!XSDUtils.isBounded(originAttr.getOwnerElement(), originBnding, targetElement) || targetAttr == null || !Objects.equal(originName, targetAttr.getValue())) continue;
                        collector.accept(originAttr, targetAttr);
                    }
                }
            }
            if (!node.hasChildNodes()) continue;
            XSDUtils.searchXSOriginAttributes(node.getChildNodes(), targetAttrs, targetNamespacePrefix, collector, cancelChecker);
        }
    }

    public static boolean isXSComplexType(Element element) {
        return element != null && "complexType".equals(element.getLocalName());
    }

    public static boolean isXSSimpleType(Element element) {
        return element != null && "simpleType".equals(element.getLocalName());
    }

    public static boolean isXSElement(Element element) {
        return element != null && "element".equals(element.getLocalName());
    }

    public static boolean isXSGroup(Element element) {
        return element != null && "group".equals(element.getLocalName());
    }

    public static boolean isXSInclude(Element element) {
        return element != null && "include".equals(element.getLocalName());
    }

    public static boolean isXSImport(Element element) {
        return element != null && "import".equals(element.getLocalName());
    }

    public static boolean isXSTargetElement(Element element) {
        return XSDUtils.isXSComplexType(element) || XSDUtils.isXSSimpleType(element) || XSDUtils.isXSElement(element) || XSDUtils.isXSGroup(element);
    }

    public static boolean isXSAttribute(DOMElement element) {
        return element != null && "attribute".equals(element.getLocalName());
    }

    public static boolean isXSSchema(Element element) {
        return element != null && "schema".equals(element.getLocalName());
    }

    public static FilesChangedTracker createFilesChangedTracker(SchemaGrammar grammar) {
        return XSDUtils.createFilesChangedTracker(Collections.singleton(grammar));
    }

    public static FilesChangedTracker createFilesChangedTracker(Set<SchemaGrammar> grammars) {
        FilesChangedTracker tracker = new FilesChangedTracker();
        HashSet<SchemaGrammar> trackedGrammars = new HashSet<SchemaGrammar>();
        HashSet<String> trackedURIs = new HashSet<String>();
        for (SchemaGrammar grammar : grammars) {
            XSDUtils.updateTracker(grammar, trackedGrammars, trackedURIs, tracker);
        }
        return tracker;
    }

    private static void updateTracker(SchemaGrammar grammar, Set<SchemaGrammar> trackedGrammars, Set<String> trackedURIs, FilesChangedTracker tracker) {
        if (grammar == null || trackedGrammars.contains(grammar)) {
            return;
        }
        trackedGrammars.add(grammar);
        StringList locations = grammar.getDocumentLocations();
        for (int i = 0; i < locations.getLength(); ++i) {
            String location = locations.item(i);
            if (!trackedURIs.contains(location)) {
                trackedURIs.add(location);
            }
            if (location == null || !URIUtils.isFileResource(location)) continue;
            tracker.addFileURI(location);
        }
        Vector importedGrammars = grammar.getImportedGrammars();
        if (importedGrammars != null) {
            for (Object importedGrammar : importedGrammars) {
                XSDUtils.updateTracker((SchemaGrammar)importedGrammar, trackedGrammars, trackedURIs, tracker);
            }
        }
    }

    public static DOMAttr getSchemaLocation(DOMElement element) {
        if (!XSDUtils.isXSInclude(element) && !XSDUtils.isXSImport(element)) {
            return null;
        }
        return element.getAttributeNode(SCHEMA_LOCATION_ATTR);
    }

    public static DOMAttr findSchemaLocationAttrByURI(DOMDocument document, String grammarURI) {
        DOMElement documentElement = document.getDocumentElement();
        if (documentElement != null) {
            List<DOMNode> children = documentElement.getChildren();
            for (DOMNode child : children) {
                String attrValue;
                DOMAttr schemaLocationAttr;
                DOMElement xsdElement;
                if (!child.isElement() || !XSDUtils.isXSInclude(xsdElement = (DOMElement)child) && !XSDUtils.isXSImport(xsdElement) || (schemaLocationAttr = XSDUtils.getSchemaLocation(xsdElement)) == null || !grammarURI.equals(attrValue = schemaLocationAttr.getValue()) && (!grammarURI.endsWith(attrValue) || !grammarURI.equals(XSDUtils.getResolvedLocation(document.getDocumentURI(), attrValue)))) continue;
                return schemaLocationAttr;
            }
        }
        return null;
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (StringUtils.isBlank(location)) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId(location, documentURI, false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }

    public static enum BindingType {
        COMPLEX,
        SIMPLE,
        COMPLEX_AND_SIMPLE,
        NONE,
        REF,
        ELEMENT;


        public boolean isSimple() {
            return COMPLEX_AND_SIMPLE.equals((Object)this) || SIMPLE.equals((Object)this);
        }

        public boolean isComplex() {
            return COMPLEX_AND_SIMPLE.equals((Object)this) || COMPLEX.equals((Object)this);
        }
    }
}

