/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions.codelens;

import java.util.Arrays;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;

public class ReferenceCommand
extends Command {
    private transient int nbReferences = 1;

    public ReferenceCommand(String uri, Position position, boolean supportedByClient) {
        super(ReferenceCommand.computeTitle(1), supportedByClient ? "xml.show.references" : "");
        super.setArguments(Arrays.asList(uri, position));
    }

    public void increment() {
        ++this.nbReferences;
        super.setTitle(ReferenceCommand.computeTitle(this.nbReferences));
    }

    private static String computeTitle(int nbReferences) {
        if (nbReferences == 1) {
            return nbReferences + " reference";
        }
        return nbReferences + " references";
    }
}

