/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions.completion;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.SnippetsBuilder;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.extensions.completion.AbstractElementCompletionItem;
import org.eclipse.lemminx.services.extensions.completion.ElementEndTagCompletionResolver;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.MarkupContent;

public class DOMElementCompletionItem
extends AbstractElementCompletionItem<DOMElement, Void> {
    public DOMElementCompletionItem(DOMElement element, ICompletionRequest request) {
        super(element.getTagName(), element, null, request);
    }

    @Override
    protected String generateFullElementContent(boolean generateEndTag) {
        DOMElement element = (DOMElement)this.getSourceElement();
        ICompletionRequest request = this.getRequest();
        String tag = element.getTagName();
        XMLBuilder xml = new XMLBuilder(this.getRequest().getSharedSettings(), "", DOMElementCompletionItem.getLineDelimiter(request));
        xml.startElement(tag, false);
        if (generateEndTag) {
            if (element.isSelfClosed()) {
                xml.selfCloseElement();
            } else {
                xml.closeStartElement();
                if (request.isCompletionSnippetsSupported()) {
                    xml.append(SnippetsBuilder.tabstops(1));
                }
                xml.endElement(tag);
            }
        } else if (!DOMElementCompletionItem.hasContentAfterTagName(element)) {
            xml.closeStartElement();
        }
        if (request.isCompletionSnippetsSupported()) {
            xml.append(SnippetsBuilder.tabstops(0));
        }
        return xml.toString();
    }

    private static String getLineDelimiter(ICompletionRequest request) {
        try {
            return request.getXMLDocument().getTextDocument().lineDelimiter(0);
        }
        catch (BadLocationException e) {
            return System.lineSeparator();
        }
    }

    @Override
    protected MarkupContent generateDocumentation() {
        return null;
    }

    @Override
    protected String getResolverParticipantId() {
        return ElementEndTagCompletionResolver.PARTICIPANT_ID;
    }
}

