/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.RelativePattern;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class FileSystemWatcher {
    @NonNull
    private Either<String, RelativePattern> globPattern;
    private Integer kind;

    public FileSystemWatcher() {
    }

    public FileSystemWatcher(@NonNull Either<String, RelativePattern> globPattern) {
        this.globPattern = Preconditions.checkNotNull(globPattern, "globPattern");
    }

    public FileSystemWatcher(@NonNull Either<String, RelativePattern> globPattern, Integer kind) {
        this(globPattern);
        this.kind = kind;
    }

    @NonNull
    public Either<String, RelativePattern> getGlobPattern() {
        return this.globPattern;
    }

    public void setGlobPattern(@NonNull Either<String, RelativePattern> globPattern) {
        this.globPattern = Preconditions.checkNotNull(globPattern, "globPattern");
    }

    public void setGlobPattern(String globPattern) {
        if (globPattern == null) {
            Preconditions.checkNotNull(globPattern, "globPattern");
            this.globPattern = null;
            return;
        }
        this.globPattern = Either.forLeft(globPattern);
    }

    public void setGlobPattern(RelativePattern globPattern) {
        if (globPattern == null) {
            Preconditions.checkNotNull(globPattern, "globPattern");
            this.globPattern = null;
            return;
        }
        this.globPattern = Either.forRight(globPattern);
    }

    public Integer getKind() {
        return this.kind;
    }

    public void setKind(Integer kind) {
        this.kind = kind;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("globPattern", this.globPattern);
        b.add("kind", this.kind);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSystemWatcher other = (FileSystemWatcher)obj;
        if (this.globPattern == null ? other.globPattern != null : !this.globPattern.equals(other.globPattern)) {
            return false;
        }
        return !(this.kind == null ? other.kind != null : !this.kind.equals(other.kind));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.globPattern == null ? 0 : this.globPattern.hashCode());
        return 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
    }
}

