/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.SchemaLocationHint;

public class SchemaLocation {
    private final Map<String, SchemaLocationHint> schemaLocationValuePairs;
    private final DOMAttr attr;
    private static final Pattern SCHEMA_LOCATION_PAIR_PATTERN = Pattern.compile("\\s*([^\\s]+)\\s+([^\\s]+)\\s*");

    public SchemaLocation(DOMAttr attr) {
        this.attr = attr;
        this.schemaLocationValuePairs = new HashMap<String, SchemaLocationHint>();
        String value = attr.getValue();
        Matcher locPairMatcher = SCHEMA_LOCATION_PAIR_PATTERN.matcher(value);
        while (locPairMatcher.find()) {
            String namespaceURI = locPairMatcher.group(1);
            String locationHint = locPairMatcher.group(2);
            if (namespaceURI == null || locationHint == null) break;
            DOMRange valNode = attr.getNodeAttrValue();
            int start = valNode.getStart() + locPairMatcher.start(2) + 1;
            int end = valNode.getStart() + locPairMatcher.end(2) + 1;
            this.schemaLocationValuePairs.put(namespaceURI, new SchemaLocationHint(start, end, locationHint, this));
        }
    }

    public SchemaLocationHint getLocationHint(String namespaceURI) {
        return this.schemaLocationValuePairs.get(namespaceURI);
    }

    public DOMAttr getAttr() {
        return this.attr;
    }

    public Collection<SchemaLocationHint> getSchemaLocationHints() {
        return this.schemaLocationValuePairs.values();
    }
}

