/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.extensions.references.search.IXMLReferenceCollector;
import org.eclipse.lemminx.extensions.references.search.ReferenceLink;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.extensions.references.search.SearchNodeFactory;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.extensions.references.settings.XMLReferenceExpression;
import org.eclipse.lemminx.extensions.references.settings.XMLReferencesSettings;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.URIUtils;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SearchEngine {
    private static final SearchEngine INSTANCE = new SearchEngine();
    private static final String INCLUDE_TAG = "include";
    private static final String HREF_ATTR = "href";

    public static SearchEngine getInstance() {
        return INSTANCE;
    }

    public final void search(SearchQuery query, IXMLReferenceCollector collector, CancelChecker cancelChecker) {
        DOMDocument document = query.getNode().getOwnerDocument();
        HashSet<String> visitedURIs = query.isSearchInIncludedFiles() ? new HashSet<String>() : null;
        this.searchInDocument(document, query, collector, visitedURIs, cancelChecker);
    }

    public Collection<ReferenceLink> searchLinks(DOMDocument document, XMLReferencesSettings settings, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createQuery((DOMNode)document, settings, SearchQuery.QueryDirection.BOTH);
        if (query != null) {
            query.setSearchInIncludedFiles(true);
            HashMap linksMap = new HashMap();
            SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> {
                ReferenceLink link = (ReferenceLink)linksMap.get(expression);
                if (link == null) {
                    link = new ReferenceLink(expression);
                    linksMap.put(expression, link);
                }
                if (fromSearchNode != null) {
                    link.addFrom(fromSearchNode);
                }
                if (toSearchNode != null) {
                    link.addTo(toSearchNode);
                }
            }, cancelChecker);
            return linksMap.values();
        }
        return Collections.emptyList();
    }

    private void searchInDocument(DOMDocument document, SearchQuery query, IXMLReferenceCollector collector, Set<String> visitedURIs, CancelChecker cancelChecker) {
        HashSet<String> externalURIsForDocument = query.isSearchInIncludedFiles() ? new HashSet<String>() : null;
        this.searchInNode(document, query, collector, externalURIsForDocument, cancelChecker);
        if (externalURIsForDocument != null && !externalURIsForDocument.isEmpty()) {
            URIResolverExtensionManager resolverExtensionManager = document.getResolverExtensionManager();
            for (String externalURI : externalURIsForDocument) {
                DOMDocument externalDocument;
                String baseURI = document.getDocumentURI();
                String resourceURI = resolverExtensionManager.resolve(baseURI, null, externalURI);
                if (!URIUtils.isFileResource(resourceURI) || !this.canPerformSearch(resourceURI, visitedURIs)) continue;
                if (visitedURIs != null) {
                    visitedURIs.add(baseURI);
                }
                if ((externalDocument = DOMUtils.loadDocument(resourceURI, document.getResolverExtensionManager())) == null) continue;
                this.searchInDocument(externalDocument, query, collector, visitedURIs, cancelChecker);
            }
        }
    }

    private boolean canPerformSearch(String documentURI, Set<String> visitedURIs) {
        return visitedURIs == null || !visitedURIs.contains(documentURI);
    }

    private void searchInNode(DOMNode node, SearchQuery query, IXMLReferenceCollector collector, Set<String> externalURIs, CancelChecker cancelChecker) {
        if (cancelChecker != null) {
            cancelChecker.checkCanceled();
        }
        if (node.isElement()) {
            String includedFile;
            DOMElement element = (DOMElement)node;
            this.searchInAttributes(element, query, collector, cancelChecker);
            if (externalURIs != null && SearchEngine.isInclude(element) && (includedFile = element.getAttribute(HREF_ATTR)) != null) {
                externalURIs.add(includedFile);
            }
        } else if (node.isText()) {
            this.searchInText((DOMText)node, query, collector, cancelChecker);
        }
        if (node.hasChildNodes()) {
            for (DOMNode child : node.getChildren()) {
                this.searchInNode(child, query, collector, externalURIs, cancelChecker);
            }
        }
    }

    private void searchInText(DOMText text, SearchQuery query, IXMLReferenceCollector collector, CancelChecker cancelChecker) {
        if (query.isSearchInText()) {
            if (cancelChecker != null) {
                cancelChecker.checkCanceled();
            }
            this.collectNodes(text, query, collector);
        }
    }

    private void searchInAttributes(DOMElement element, SearchQuery query, IXMLReferenceCollector collector, CancelChecker cancelChecker) {
        NamedNodeMap toAttributes;
        if (query.isSearchInAttribute() && element.hasAttributes() && (toAttributes = element.getAttributes()) != null) {
            for (int j = 0; j < toAttributes.getLength(); ++j) {
                DOMAttr toAttr = (DOMAttr)toAttributes.item(j);
                if (cancelChecker != null) {
                    cancelChecker.checkCanceled();
                }
                this.collectNodes(toAttr, query, collector);
            }
        }
    }

    private void collectNodes(DOMNode node, SearchQuery query, IXMLReferenceCollector collector) {
        SearchQuery.QueryDirection queryDirection = query.getQueryDirection();
        for (XMLReferenceExpression expression : query.getExpressions()) {
            SearchNode.Direction nodeDirection = SearchQueryFactory.getInversedDirection(node, expression, queryDirection);
            if (nodeDirection == null) continue;
            List<SearchNode> searchNodes = this.findSearchNodes(node, expression, nodeDirection);
            for (SearchNode searchNode : searchNodes) {
                this.collect(query, searchNode, expression, collector);
            }
        }
    }

    private void collect(SearchQuery query, SearchNode searchNode, XMLReferenceExpression expression, IXMLReferenceCollector collector) {
        SearchNode requestedNode = query.getSearchNode();
        if (query.isMatchNode() && !requestedNode.matchesValue(searchNode)) {
            return;
        }
        SearchQuery.QueryDirection direction = query.getQueryDirection();
        switch (direction) {
            case FROM_2_TO: {
                collector.collect(requestedNode, searchNode, expression);
                break;
            }
            case TO_2_FROM: {
                collector.collect(searchNode, requestedNode, expression);
                break;
            }
            default: {
                SearchNode.Direction nodeDirection = searchNode.getDirection();
                if (nodeDirection == SearchNode.Direction.FROM) {
                    collector.collect(searchNode, requestedNode, expression);
                    break;
                }
                collector.collect(requestedNode, searchNode, expression);
            }
        }
    }

    private List<SearchNode> findSearchNodes(DOMNode node, XMLReferenceExpression expression, SearchNode.Direction nodeDirection) {
        if (nodeDirection == SearchNode.Direction.FROM) {
            return SearchNodeFactory.findSearchNodes(node, expression.getPrefix(), expression.isMultiple(), nodeDirection);
        }
        return SearchNodeFactory.findSearchNodes(node, null, false, nodeDirection);
    }

    private static boolean isInclude(Element element) {
        return element != null && INCLUDE_TAG.equals(element.getLocalName());
    }
}

