/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLSchemaDescription;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.utils.DOMUtils;

public class LSPXMLEntityManager
extends XMLEntityManager {
    private final AbstractLSPErrorReporter errorReporter;
    private final LSPXMLGrammarPool grammarPool;
    private boolean hasProblemsWithReferencedDTD;
    private static final XMLLocator NULL_LOCATOR = new XMLLocator(){

        @Override
        public String getXMLVersion() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getLiteralSystemId() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public String getExpandedSystemId() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public int getColumnNumber() {
            return 0;
        }

        @Override
        public int getCharacterOffset() {
            return 0;
        }

        @Override
        public String getBaseSystemId() {
            return null;
        }
    };

    public LSPXMLEntityManager() {
        this(null, null);
    }

    public LSPXMLEntityManager(AbstractLSPErrorReporter errorReporter, LSPXMLGrammarPool grammarPool) {
        this.errorReporter = errorReporter;
        this.grammarPool = grammarPool;
        this.hasProblemsWithReferencedDTD = false;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        if (resourceIdentifier instanceof XMLSchemaDescription) {
            try {
                return super.resolveEntity(resourceIdentifier);
            }
            catch (IOException e) {
                this.setCurrentError(e);
                throw e;
            }
        }
        try {
            return super.resolveEntity(resourceIdentifier);
        }
        catch (Exception e) {
            this.reportError(resourceIdentifier.getLiteralSystemId(), e);
            XMLInputSource in = new XMLInputSource(resourceIdentifier);
            in.setCharacterStream(new StringReader(""));
            return in;
        }
    }

    @Override
    public String setupCurrentEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
        String systemId = xmlInputSource.getSystemId();
        if (DOMUtils.isXSD(systemId)) {
            try {
                return super.setupCurrentEntity(name, xmlInputSource, literal, isExternal);
            }
            catch (IOException e) {
                this.setCurrentError(e);
                throw e;
            }
        }
        try {
            return super.setupCurrentEntity(name, xmlInputSource, literal, isExternal);
        }
        catch (Exception e) {
            this.reportError(xmlInputSource.getSystemId(), e);
            XMLInputSource in = new XMLInputSource(xmlInputSource.getPublicId(), xmlInputSource.getSystemId(), xmlInputSource.getBaseSystemId(), new StringReader(""), null);
            return super.setupCurrentEntity(name, in, literal, isExternal);
        }
    }

    private void reportError(String location, Exception e) {
        if (this.errorReporter == null) {
            return;
        }
        this.hasProblemsWithReferencedDTD = true;
        this.errorReporter.reportError(NULL_LOCATOR, "https://www.w3.org/TR/xml-model/", DTDErrorCode.DTDNotFound.getCode(), new Object[]{null, location}, (short)1, e);
    }

    private void setCurrentError(IOException e) {
        if (this.errorReporter == null) {
            return;
        }
        this.errorReporter.setCurrentError(e);
    }

    public void setResolveExternalEntities(boolean resolveExternalEntities) {
        this.fExternalGeneralEntities = resolveExternalEntities;
        this.fExternalParameterEntities = resolveExternalEntities;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.fSecurityManager = securityManager;
    }

    public void setEntityResolver(XMLEntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public void dispose() {
        if (this.hasProblemsWithReferencedDTD && this.grammarPool != null) {
            this.grammarPool.clear();
        }
    }
}

