/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.services.extensions.IPositionRequest;
import org.eclipse.lemminx.services.extensions.rename.IPrepareRenameRequest;
import org.eclipse.lemminx.services.extensions.rename.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.rename.IRenameRequest;
import org.eclipse.lemminx.services.extensions.rename.IRenameResponse;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.TextEditUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XSDRenameParticipant
implements IRenameParticipant {
    @Override
    public Either<Range, PrepareRenameResult> prepareRename(IPrepareRenameRequest request, CancelChecker cancelChecker) {
        DOMAttr attr = XSDRenameParticipant.findAttrToRename(request);
        if (attr != null) {
            Range range = XMLPositionUtility.selectAttributeValue(attr, true);
            String placeholder = attr.getValue();
            return Either.forRight(new PrepareRenameResult(range, placeholder));
        }
        return null;
    }

    @Override
    public void doRename(IRenameRequest request, IRenameResponse renameResponse, CancelChecker cancelChecker) {
        renameResponse.addTextDocumentEdit(this.getRenameTextDocumentEdit(request, cancelChecker));
    }

    private TextDocumentEdit getRenameTextDocumentEdit(IRenameRequest request, CancelChecker cancelChecker) {
        DOMAttr attr = XSDRenameParticipant.findAttrToRename(request);
        if (attr == null) {
            return null;
        }
        DOMElement ownerElement = attr.getOwnerElement();
        DOMDocument document = request.getXMLDocument();
        String newText = request.getNewText();
        List<Location> locations = this.getReferenceLocations(ownerElement, cancelChecker);
        return TextEditUtils.creatTextDocumentEdit(document, this.renameAttributeValueTextEdits(document, attr, newText, locations));
    }

    private List<Location> getReferenceLocations(DOMNode node, CancelChecker cancelChecker) {
        ArrayList<Location> locations = new ArrayList<Location>();
        XSDUtils.searchXSOriginAttributes(node, (origin, target) -> locations.add(XMLPositionUtility.createLocation(origin.getNodeAttrValue())), cancelChecker);
        return locations;
    }

    private List<TextEdit> renameAttributeValueTextEdits(DOMDocument document, DOMAttr attribute, String newText, List<Location> locations) {
        DOMRange attrValue = attribute.getNodeAttrValue();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        int valueStart = attrValue.getStart();
        int valueEnd = attrValue.getEnd();
        Range range = XMLPositionUtility.createRange(valueStart, valueEnd, document);
        this.reduceRangeFromBothEnds(range, 1);
        textEdits.add(new TextEdit(range, newText));
        for (Location location : locations) {
            String oldAttrValue;
            Range textEditRange = location.getRange();
            this.reduceRangeFromBothEnds(textEditRange, 1);
            try {
                oldAttrValue = this.getAttrTextValueFromPosition(document, location.getRange().getStart());
            }
            catch (BadLocationException e1) {
                return Collections.emptyList();
            }
            int colonIndex = oldAttrValue.indexOf(":");
            if (colonIndex > 0) {
                this.increaseStartRange(textEditRange, colonIndex + 1);
            }
            textEdits.add(new TextEdit(textEditRange, newText));
        }
        return textEdits;
    }

    private void reduceRangeFromBothEnds(Range range, int reduce) {
        this.increaseStartRange(range, reduce);
        this.decreaseEndRange(range, reduce);
    }

    private void increaseStartRange(Range range, int increase) {
        int startCharacter = range.getStart().getCharacter();
        range.getStart().setCharacter(startCharacter + increase);
    }

    private void decreaseEndRange(Range range, int decrease) {
        int endCharacter = range.getEnd().getCharacter();
        range.getEnd().setCharacter(endCharacter - decrease);
    }

    private String getAttrTextValueFromPosition(DOMDocument document, Position position) throws BadLocationException {
        int offset = document.offsetAt(position);
        return document.findAttrAt(offset).getValue();
    }

    private static DOMAttr findAttrToRename(IPositionRequest request) {
        DOMDocument xmlDocument = request.getXMLDocument();
        if (!DOMUtils.isXSD(xmlDocument)) {
            return null;
        }
        DOMNode node = request.getNode();
        if (node == null || !node.isAttribute()) {
            return null;
        }
        DOMAttr attr = (DOMAttr)node;
        DOMElement ownerElement = attr.getOwnerElement();
        if (ownerElement == null) {
            return null;
        }
        if ((XSDUtils.isXSComplexType(ownerElement) || XSDUtils.isXSSimpleType(ownerElement)) && attr.getName().equals("name")) {
            return attr;
        }
        return null;
    }
}

