/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsException
extends Exception {
    static final long serialVersionUID = 2765039493083748820L;
    private int lastError;
    private String msg;

    WindowsException(int n) {
        this.lastError = n;
        this.msg = null;
    }

    WindowsException(String string) {
        this.lastError = 0;
        this.msg = string;
    }

    int lastError() {
        return this.lastError;
    }

    String errorString() {
        if (this.msg == null) {
            this.msg = WindowsNativeDispatcher.FormatMessage(this.lastError);
            if (this.msg == null) {
                this.msg = "Unknown error: 0x" + Integer.toHexString(this.lastError);
            }
        }
        return this.msg;
    }

    @Override
    public String getMessage() {
        return this.errorString();
    }

    private IOException translateToIOException(String string, String string2) {
        if (this.lastError() == 0) {
            return new IOException(this.errorString());
        }
        if (this.lastError() == 2 || this.lastError() == 3) {
            return new NoSuchFileException(string, string2, null);
        }
        if (this.lastError() == 80 || this.lastError() == 183) {
            return new FileAlreadyExistsException(string, string2, null);
        }
        if (this.lastError() == 5) {
            return new AccessDeniedException(string, string2, null);
        }
        return new FileSystemException(string, string2, this.errorString());
    }

    void rethrowAsIOException(String string) throws IOException {
        IOException iOException = this.translateToIOException(string, null);
        throw iOException;
    }

    void rethrowAsIOException(WindowsPath windowsPath, WindowsPath windowsPath2) throws IOException {
        String string = windowsPath == null ? null : windowsPath.getPathForExceptionMessage();
        String string2 = windowsPath2 == null ? null : windowsPath2.getPathForExceptionMessage();
        IOException iOException = this.translateToIOException(string, string2);
        throw iOException;
    }

    void rethrowAsIOException(WindowsPath windowsPath) throws IOException {
        this.rethrowAsIOException(windowsPath, null);
    }

    IOException asIOException(WindowsPath windowsPath) {
        return this.translateToIOException(windowsPath.getPathForExceptionMessage(), null);
    }
}

