/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static final String decode(String string) throws MalformedURLException {
        try {
            return UrlUtil.decode(string, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MalformedURLException("ISO-Latin-1 decoder unavailable");
        }
    }

    public static final String decode(String string, String string2) throws MalformedURLException, UnsupportedEncodingException {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MalformedURLException malformedURLException = new MalformedURLException("Invalid URI encoding: " + string);
            malformedURLException.initCause(illegalArgumentException);
            throw malformedURLException;
        }
    }

    public static final String encode(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        int n = byArray.length;
        char[] cArray = new char[3 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] >= 97 && byArray[i] <= 122 || byArray[i] >= 65 && byArray[i] <= 90 || byArray[i] >= 48 && byArray[i] <= 57 || "=,+;.'-@&/$_()!~*:".indexOf(byArray[i]) >= 0) {
                cArray[n2++] = (char)byArray[i];
                continue;
            }
            cArray[n2++] = 37;
            cArray[n2++] = Character.forDigit(0xF & byArray[i] >>> 4, 16);
            cArray[n2++] = Character.forDigit(0xF & byArray[i], 16);
        }
        return new String(cArray, 0, n2);
    }
}

