"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_workspace_lib_browser_workspace-frontend-module_js"],{

/***/ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CanonicalUriService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "../../node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
let CanonicalUriService = class CanonicalUriService {
    constructor() {
        this.providers = new Map();
    }
    registerCanonicalUriProvider(scheme, provider) {
        if (this.providers.has(scheme)) {
            throw new Error(`Canonical URI provider for scheme: '${scheme}' already exists`);
        }
        this.providers.set(scheme, provider);
        return vscode_languageserver_protocol_1.Disposable.create(() => { this.removeCanonicalUriProvider(scheme); });
    }
    removeCanonicalUriProvider(scheme) {
        const provider = this.providers.get(scheme);
        if (!provider) {
            throw new Error(`No Canonical URI provider for scheme: '${scheme}' exists`);
        }
        this.providers.delete(scheme);
        provider.dispose();
    }
    async provideCanonicalUri(uri, targetScheme, token = common_1.CancellationToken.None) {
        const provider = this.providers.get(uri.scheme);
        if (!provider) {
            console.warn(`No Canonical URI provider for scheme: '${uri.scheme}' exists`);
            return undefined;
        }
        return provider.provideCanonicalUri(uri, targetScheme, token);
    }
};
exports.CanonicalUriService = CanonicalUriService;
exports.CanonicalUriService = CanonicalUriService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CanonicalUriService);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/diff-service.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/diff-service.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiffService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const diff_uris_1 = __webpack_require__(/*! @theia/core/lib/browser/diff-uris */ "../../node_modules/@theia/core/lib/browser/diff-uris.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "../../node_modules/@theia/core/lib/common/message-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
let DiffService = class DiffService {
    async openDiffEditor(left, right, label, options) {
        if (left.scheme === 'file' && right.scheme === 'file') {
            const [resolvedLeft, resolvedRight] = await this.fileService.resolveAll([{ resource: left }, { resource: right }]);
            if (resolvedLeft.success && resolvedRight.success) {
                const leftStat = resolvedLeft.stat;
                const rightStat = resolvedRight.stat;
                if (leftStat && rightStat) {
                    if (!leftStat.isDirectory && !rightStat.isDirectory) {
                        const uri = diff_uris_1.DiffUris.encode(left, right, label);
                        await (0, browser_1.open)(this.openerService, uri, options);
                    }
                    else {
                        const details = (() => {
                            if (leftStat.isDirectory && rightStat.isDirectory) {
                                return 'Both resource were a directory.';
                            }
                            else {
                                if (leftStat.isDirectory) {
                                    return `'${left.path.base}' was a directory.`;
                                }
                                else {
                                    return `'${right.path.base}' was a directory.`;
                                }
                            }
                        });
                        this.messageService.warn(`Directories cannot be compared. ${details()}`);
                    }
                }
            }
        }
        else {
            const uri = diff_uris_1.DiffUris.encode(left, right, label);
            await (0, browser_1.open)(this.openerService, uri, options);
        }
    }
};
exports.DiffService = DiffService;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], DiffService.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], DiffService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    tslib_1.__metadata("design:type", message_service_1.MessageService)
], DiffService.prototype, "messageService", void 0);
exports.DiffService = DiffService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DiffService);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/quick-open-workspace.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/quick-open-workspace.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.QuickOpenWorkspace = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const untitled_workspace_service_1 = __webpack_require__(/*! ../common/untitled-workspace-service */ "../../node_modules/@theia/workspace/lib/common/untitled-workspace-service.js");
let QuickOpenWorkspace = class QuickOpenWorkspace {
    constructor() {
        this.removeRecentWorkspaceButton = {
            iconClass: 'codicon-remove-close',
            tooltip: common_1.nls.localizeByDefault('Remove from Recently Opened')
        };
    }
    async open(workspaces) {
        var _a, _b, _c, _d;
        const homeDirUri = await this.envServer.getHomeDirUri();
        const home = new uri_1.default(homeDirUri).path.fsPath();
        const items = [{
                type: 'separator',
                label: common_1.nls.localizeByDefault('folders & workspaces')
            }];
        for (const workspace of workspaces) {
            const uri = new uri_1.default(workspace);
            const label = (_c = await ((_b = (_a = this.workspaceOpenHandlers.getContributions()
                .find(handler => handler.getWorkspaceLabel && handler.canHandle(uri))) === null || _a === void 0 ? void 0 : _a.getWorkspaceLabel) === null || _b === void 0 ? void 0 : _b.call(_a, uri))) !== null && _c !== void 0 ? _c : uri.path.base;
            if (!label || this.untitledWorkspaceService.isUntitledWorkspace(uri)) {
                continue; // skip temporary workspace files & empty workspace names
            }
            items.push({
                label: label,
                description: common_1.Path.tildify(uri.path.fsPath(), home),
                buttons: [this.removeRecentWorkspaceButton],
                resource: uri,
                execute: () => {
                    const current = this.workspaceService.workspace;
                    if ((current && current.resource.toString() !== workspace) || !current) {
                        this.workspaceService.open(uri);
                    }
                }
            });
        }
        (_d = this.quickInputService) === null || _d === void 0 ? void 0 : _d.showQuickPick(items, {
            placeholder: common_1.nls.localize('theia/workspace/openRecentPlaceholder', 'Type the name of the workspace you want to open'),
            onDidTriggerItemButton: async (context) => {
                const resource = context.item.resource;
                if (resource) {
                    await this.workspaceService.removeRecentWorkspace(resource.toString());
                    context.removeItem();
                }
            }
        });
    }
    select() {
        this.opened = this.workspaceService.opened;
        this.workspaceService.recentWorkspaces().then(workspaceRoots => {
            if (workspaceRoots) {
                this.open(workspaceRoots);
            }
        });
    }
};
exports.QuickOpenWorkspace = QuickOpenWorkspace;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], QuickOpenWorkspace.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], QuickOpenWorkspace.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], QuickOpenWorkspace.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], QuickOpenWorkspace.prototype, "envServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(untitled_workspace_service_1.UntitledWorkspaceService),
    tslib_1.__metadata("design:type", untitled_workspace_service_1.UntitledWorkspaceService)
], QuickOpenWorkspace.prototype, "untitledWorkspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ContributionProvider),
    (0, inversify_1.named)(workspace_service_1.WorkspaceOpenHandlerContribution),
    tslib_1.__metadata("design:type", Object)
], QuickOpenWorkspace.prototype, "workspaceOpenHandlers", void 0);
exports.QuickOpenWorkspace = QuickOpenWorkspace = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], QuickOpenWorkspace);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/untitled-workspace-exit-dialog.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/untitled-workspace-exit-dialog.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var UntitledWorkspaceExitDialog_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UntitledWorkspaceExitDialog = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let UntitledWorkspaceExitDialog = UntitledWorkspaceExitDialog_1 = class UntitledWorkspaceExitDialog extends browser_1.AbstractDialog {
    get value() {
        return this._value;
    }
    constructor(props) {
        super(props);
        this._value = 'Cancel';
        const messageNode = document.createElement('div');
        messageNode.textContent = core_1.nls.localizeByDefault('Save your workspace if you plan to open it again.');
        this.contentNode.appendChild(messageNode);
        this.dontSaveButton = this.createButton(core_1.nls.localizeByDefault("Don't Save" /* UntitledWorkspaceExitDialog.Values["Don't Save"] */));
        this.dontSaveButton.classList.add('secondary');
        this.controlPanel.appendChild(this.dontSaveButton);
        this.appendCloseButton(browser_1.Dialog.CANCEL);
        this.appendAcceptButton(core_1.nls.localizeByDefault("Save" /* UntitledWorkspaceExitDialog.Values.Save */));
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.addAction(this.dontSaveButton, () => this.dontSave(), 'click');
    }
    addAcceptAction(element, ...additionalEventTypes) {
        this.addAction(element, () => this.doSave(), 'click');
    }
    dontSave() {
        this._value = "Don't Save" /* UntitledWorkspaceExitDialog.Values["Don't Save"] */;
        this.accept();
    }
    doSave() {
        this._value = "Save" /* UntitledWorkspaceExitDialog.Values.Save */;
        this.accept();
    }
};
exports.UntitledWorkspaceExitDialog = UntitledWorkspaceExitDialog;
exports.UntitledWorkspaceExitDialog = UntitledWorkspaceExitDialog = UntitledWorkspaceExitDialog_1 = tslib_1.__decorate([
    tslib_1.__param(0, (0, inversify_1.inject)(browser_1.DialogProps)),
    tslib_1.__metadata("design:paramtypes", [browser_1.DialogProps])
], UntitledWorkspaceExitDialog);
(function (UntitledWorkspaceExitDialog) {
    ;
})(UntitledWorkspaceExitDialog || (exports.UntitledWorkspaceExitDialog = UntitledWorkspaceExitDialog = {}));


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-breadcrumbs-contribution.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-breadcrumbs-contribution.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceBreadcrumbsContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const filepath_breadcrumbs_contribution_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution */ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
let WorkspaceBreadcrumbsContribution = class WorkspaceBreadcrumbsContribution extends filepath_breadcrumbs_contribution_1.FilepathBreadcrumbsContribution {
    getContainerClassCreator(fileURI) {
        const workspaceRoot = this.workspaceService.getWorkspaceRootUri(fileURI);
        return (location, index) => {
            if (location.isEqual(fileURI)) {
                return 'file';
            }
            else if (workspaceRoot === null || workspaceRoot === void 0 ? void 0 : workspaceRoot.isEqual(location)) {
                return 'root_folder';
            }
            return 'folder';
        };
    }
    getIconClassCreator(fileURI) {
        const workspaceRoot = this.workspaceService.getWorkspaceRootUri(fileURI);
        return (location, index) => {
            if (location.isEqual(fileURI) || (workspaceRoot === null || workspaceRoot === void 0 ? void 0 : workspaceRoot.isEqual(location))) {
                return this.labelProvider.getIcon(location) + ' file-icon';
            }
            return '';
        };
    }
    filterBreadcrumbs(uri, breadcrumb) {
        const workspaceRootUri = this.workspaceService.getWorkspaceRootUri(uri);
        const firstCrumbToHide = this.workspaceService.isMultiRootWorkspaceOpened ? workspaceRootUri === null || workspaceRootUri === void 0 ? void 0 : workspaceRootUri.parent : workspaceRootUri;
        return super.filterBreadcrumbs(uri, breadcrumb) && (!firstCrumbToHide || !breadcrumb.uri.isEqualOrParent(firstCrumbToHide));
    }
};
exports.WorkspaceBreadcrumbsContribution = WorkspaceBreadcrumbsContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceBreadcrumbsContribution.prototype, "workspaceService", void 0);
exports.WorkspaceBreadcrumbsContribution = WorkspaceBreadcrumbsContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceBreadcrumbsContribution);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-commands.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceRootUriAwareCommandHandler = exports.WorkspaceCommandContribution = exports.EditMenuContribution = exports.FileMenuContribution = exports.WorkspaceCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const selection_service_1 = __webpack_require__(/*! @theia/core/lib/common/selection-service */ "../../node_modules/@theia/core/lib/common/selection-service.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "../../node_modules/@theia/core/lib/common/command.js");
const common_frontend_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/common-frontend-contribution */ "../../node_modules/@theia/core/lib/browser/common-frontend-contribution.js");
const browser_1 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const dialogs_1 = __webpack_require__(/*! @theia/core/lib/browser/dialogs */ "../../node_modules/@theia/core/lib/browser/dialogs.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const uri_command_handler_1 = __webpack_require__(/*! @theia/core/lib/common/uri-command-handler */ "../../node_modules/@theia/core/lib/common/uri-command-handler.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "../../node_modules/@theia/core/lib/common/message-service.js");
const workspace_preferences_1 = __webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js");
const workspace_delete_handler_1 = __webpack_require__(/*! ./workspace-delete-handler */ "../../node_modules/@theia/workspace/lib/browser/workspace-delete-handler.js");
const workspace_duplicate_handler_1 = __webpack_require__(/*! ./workspace-duplicate-handler */ "../../node_modules/@theia/workspace/lib/browser/workspace-duplicate-handler.js");
const common_1 = __webpack_require__(/*! @theia/filesystem/lib/common */ "../../node_modules/@theia/filesystem/lib/common/index.js");
const workspace_compare_handler_1 = __webpack_require__(/*! ./workspace-compare-handler */ "../../node_modules/@theia/workspace/lib/browser/workspace-compare-handler.js");
const file_download_command_contribution_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/download/file-download-command-contribution */ "../../node_modules/@theia/filesystem/lib/browser/download/file-download-command-contribution.js");
const filesystem_frontend_contribution_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/filesystem-frontend-contribution */ "../../node_modules/@theia/filesystem/lib/browser/filesystem-frontend-contribution.js");
const workspace_input_dialog_1 = __webpack_require__(/*! ./workspace-input-dialog */ "../../node_modules/@theia/workspace/lib/browser/workspace-input-dialog.js");
const common_2 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
const validFilename = __webpack_require__(/*! valid-filename */ "../../node_modules/valid-filename/index.js");
var WorkspaceCommands;
(function (WorkspaceCommands) {
    const WORKSPACE_CATEGORY = 'Workspaces';
    const FILE_CATEGORY = browser_2.CommonCommands.FILE_CATEGORY;
    // On Linux and Windows, both files and folders cannot be opened at the same time in electron.
    // `OPEN_FILE` and `OPEN_FOLDER` must be available only on Linux and Windows in electron.
    // `OPEN` must *not* be available on Windows and Linux in electron.
    // VS Code does the same. See: https://github.com/eclipse-theia/theia/pull/3202#issuecomment-430585357
    WorkspaceCommands.OPEN = {
        ...command_1.Command.toDefaultLocalizedCommand({
            id: 'workspace:open',
            category: browser_2.CommonCommands.FILE_CATEGORY,
            label: 'Open...'
        }),
        dialogLabel: nls_1.nls.localizeByDefault('Open')
    };
    // No `label`. Otherwise, it shows up in the `Command Palette`.
    WorkspaceCommands.OPEN_FILE = {
        id: 'workspace:openFile',
        originalCategory: FILE_CATEGORY,
        category: nls_1.nls.localizeByDefault(browser_2.CommonCommands.FILE_CATEGORY),
        dialogLabel: nls_1.nls.localizeByDefault('Open File')
    };
    WorkspaceCommands.OPEN_FOLDER = {
        id: 'workspace:openFolder',
        dialogLabel: nls_1.nls.localizeByDefault('Open Folder') // No `label`. Otherwise, it shows up in the `Command Palette`.
    };
    WorkspaceCommands.OPEN_WORKSPACE = {
        ...command_1.Command.toDefaultLocalizedCommand({
            id: 'workspace:openWorkspace',
            category: browser_2.CommonCommands.FILE_CATEGORY,
            label: 'Open Workspace from File...',
        }),
        dialogLabel: nls_1.nls.localizeByDefault('Open Workspace from File')
    };
    WorkspaceCommands.OPEN_RECENT_WORKSPACE = command_1.Command.toLocalizedCommand({
        id: 'workspace:openRecent',
        category: FILE_CATEGORY,
        label: 'Open Recent Workspace...'
    }, 'theia/workspace/openRecentWorkspace', browser_2.CommonCommands.FILE_CATEGORY_KEY);
    WorkspaceCommands.CLOSE = command_1.Command.toDefaultLocalizedCommand({
        id: 'workspace:close',
        category: WORKSPACE_CATEGORY,
        label: 'Close Workspace'
    });
    WorkspaceCommands.NEW_FILE = command_1.Command.toDefaultLocalizedCommand({
        id: 'file.newFile',
        category: FILE_CATEGORY,
        label: 'New File...'
    });
    WorkspaceCommands.NEW_FOLDER = command_1.Command.toDefaultLocalizedCommand({
        id: 'file.newFolder',
        category: FILE_CATEGORY,
        label: 'New Folder...'
    });
    /** @deprecated Use the `OpenWithService` instead */
    WorkspaceCommands.FILE_OPEN_WITH = (opener) => ({
        id: `file.openWith.${opener.id}`
    });
    WorkspaceCommands.FILE_RENAME = command_1.Command.toDefaultLocalizedCommand({
        id: 'file.rename',
        category: FILE_CATEGORY,
        label: 'Rename'
    });
    WorkspaceCommands.FILE_DELETE = command_1.Command.toDefaultLocalizedCommand({
        id: 'file.delete',
        category: FILE_CATEGORY,
        label: 'Delete'
    });
    WorkspaceCommands.FILE_DUPLICATE = command_1.Command.toLocalizedCommand({
        id: 'file.duplicate',
        category: FILE_CATEGORY,
        label: 'Duplicate'
    }, 'theia/workspace/duplicate', browser_2.CommonCommands.FILE_CATEGORY_KEY);
    WorkspaceCommands.FILE_COMPARE = command_1.Command.toLocalizedCommand({
        id: 'file.compare',
        category: FILE_CATEGORY,
        label: 'Compare with Each Other'
    }, 'theia/workspace/compareWithEachOther', browser_2.CommonCommands.FILE_CATEGORY_KEY);
    WorkspaceCommands.ADD_FOLDER = command_1.Command.toDefaultLocalizedCommand({
        id: 'workspace:addFolder',
        category: WORKSPACE_CATEGORY,
        label: 'Add Folder to Workspace...'
    });
    WorkspaceCommands.REMOVE_FOLDER = command_1.Command.toDefaultLocalizedCommand({
        id: 'workspace:removeFolder',
        category: WORKSPACE_CATEGORY,
        label: 'Remove Folder from Workspace'
    });
    WorkspaceCommands.SAVE_WORKSPACE_AS = command_1.Command.toDefaultLocalizedCommand({
        id: 'workspace:saveAs',
        category: WORKSPACE_CATEGORY,
        label: 'Save Workspace As...'
    });
    WorkspaceCommands.OPEN_WORKSPACE_FILE = command_1.Command.toDefaultLocalizedCommand({
        id: 'workspace:openConfigFile',
        category: WORKSPACE_CATEGORY,
        label: 'Open Workspace Configuration File'
    });
    /** @deprecated @since 1.24.0 Use `CommonCommands.SAVE_AS` instead */
    WorkspaceCommands.SAVE_AS = browser_2.CommonCommands.SAVE_AS;
    WorkspaceCommands.COPY_RELATIVE_FILE_PATH = command_1.Command.toDefaultLocalizedCommand({
        id: 'navigator.copyRelativeFilePath',
        label: 'Copy Relative Path'
    });
})(WorkspaceCommands || (exports.WorkspaceCommands = WorkspaceCommands = {}));
let FileMenuContribution = class FileMenuContribution {
    registerMenus(registry) {
        registry.registerMenuAction(common_frontend_contribution_1.CommonMenus.FILE_NEW_TEXT, {
            commandId: WorkspaceCommands.NEW_FOLDER.id,
            order: 'b'
        });
        const downloadUploadMenu = [...common_frontend_contribution_1.CommonMenus.FILE, '4_downloadupload'];
        registry.registerMenuAction(downloadUploadMenu, {
            commandId: filesystem_frontend_contribution_1.FileSystemCommands.UPLOAD.id,
            order: 'a'
        });
        registry.registerMenuAction(downloadUploadMenu, {
            commandId: file_download_command_contribution_1.FileDownloadCommands.DOWNLOAD.id,
            order: 'b'
        });
    }
};
exports.FileMenuContribution = FileMenuContribution;
exports.FileMenuContribution = FileMenuContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileMenuContribution);
let EditMenuContribution = class EditMenuContribution {
    registerMenus(registry) {
        registry.registerMenuAction(common_frontend_contribution_1.CommonMenus.EDIT_CLIPBOARD, {
            commandId: file_download_command_contribution_1.FileDownloadCommands.COPY_DOWNLOAD_LINK.id,
            order: '9999'
        });
    }
};
exports.EditMenuContribution = EditMenuContribution;
exports.EditMenuContribution = EditMenuContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], EditMenuContribution);
let WorkspaceCommandContribution = class WorkspaceCommandContribution {
    constructor() {
        this.onDidCreateNewFileEmitter = new common_2.Emitter();
        this.onDidCreateNewFolderEmitter = new common_2.Emitter();
    }
    get onDidCreateNewFile() {
        return this.onDidCreateNewFileEmitter.event;
    }
    get onDidCreateNewFolder() {
        return this.onDidCreateNewFolderEmitter.event;
    }
    fireCreateNewFile(uri) {
        this.onDidCreateNewFileEmitter.fire(uri);
    }
    fireCreateNewFolder(uri) {
        this.onDidCreateNewFolderEmitter.fire(uri);
    }
    registerCommands(registry) {
        registry.registerCommand(WorkspaceCommands.NEW_FILE, this.newWorkspaceRootUriAwareCommandHandler({
            execute: uri => this.getDirectory(uri).then(parent => {
                if (parent) {
                    const parentUri = parent.resource;
                    const { fileName, fileExtension } = this.getDefaultFileConfig();
                    const targetUri = parentUri.resolve(fileName + fileExtension);
                    const vacantChildUri = common_1.FileSystemUtils.generateUniqueResourceURI(parent, targetUri, false);
                    const dialog = new workspace_input_dialog_1.WorkspaceInputDialog({
                        title: nls_1.nls.localizeByDefault('New File...'),
                        maxWidth: 400,
                        parentUri: parentUri,
                        initialValue: vacantChildUri.path.base,
                        placeholder: nls_1.nls.localize('theia/workspace/newFilePlaceholder', 'File Name'),
                        validate: name => this.validateFileName(name, parent, true)
                    }, this.labelProvider);
                    dialog.open().then(async (name) => {
                        if (name) {
                            const fileUri = parentUri.resolve(name);
                            await this.fileService.create(fileUri);
                            this.fireCreateNewFile({ parent: parentUri, uri: fileUri });
                            (0, browser_2.open)(this.openerService, fileUri);
                        }
                    });
                }
            })
        }));
        registry.registerCommand(WorkspaceCommands.NEW_FOLDER, this.newWorkspaceRootUriAwareCommandHandler({
            execute: uri => this.getDirectory(uri).then(parent => {
                if (parent) {
                    const parentUri = parent.resource;
                    const targetUri = parentUri.resolve('Untitled');
                    const vacantChildUri = common_1.FileSystemUtils.generateUniqueResourceURI(parent, targetUri, true);
                    const dialog = new workspace_input_dialog_1.WorkspaceInputDialog({
                        title: nls_1.nls.localizeByDefault('New Folder...'),
                        maxWidth: 400,
                        parentUri: parentUri,
                        initialValue: vacantChildUri.path.base,
                        placeholder: nls_1.nls.localize('theia/workspace/newFolderPlaceholder', 'Folder Name'),
                        validate: name => this.validateFileName(name, parent, true)
                    }, this.labelProvider);
                    dialog.open().then(async (name) => {
                        if (name) {
                            const folderUri = parentUri.resolve(name);
                            await this.fileService.createFolder(folderUri);
                            this.fireCreateNewFile({ parent: parentUri, uri: folderUri });
                        }
                    });
                }
            })
        }));
        registry.registerCommand(WorkspaceCommands.FILE_RENAME, this.newMultiUriAwareCommandHandler({
            isEnabled: uris => uris.some(uri => !this.isWorkspaceRoot(uri)) && uris.length === 1,
            isVisible: uris => uris.some(uri => !this.isWorkspaceRoot(uri)) && uris.length === 1,
            execute: async (uris) => {
                const uri = uris[0]; /* Since there is only one item in the array. */
                const parent = await this.getParent(uri);
                if (parent) {
                    const oldName = uri.path.base;
                    const dialog = new dialogs_1.SingleTextInputDialog({
                        title: nls_1.nls.localizeByDefault('Rename'),
                        maxWidth: 400,
                        initialValue: oldName,
                        initialSelectionRange: {
                            start: 0,
                            end: uri.path.name.length
                        },
                        validate: async (newName, mode) => {
                            if (oldName === newName && mode === 'preview') {
                                return false;
                            }
                            return this.validateFileRename(oldName, newName, parent);
                        }
                    });
                    const fileName = await dialog.open();
                    if (fileName) {
                        const oldUri = uri;
                        const newUri = uri.parent.resolve(fileName);
                        return this.fileService.move(oldUri, newUri);
                    }
                }
            }
        }));
        registry.registerCommand(WorkspaceCommands.FILE_DUPLICATE, this.newMultiUriAwareCommandHandler(this.duplicateHandler));
        registry.registerCommand(WorkspaceCommands.FILE_DELETE, this.newMultiUriAwareCommandHandler(this.deleteHandler));
        registry.registerCommand(WorkspaceCommands.FILE_COMPARE, this.newMultiUriAwareCommandHandler(this.compareHandler));
        registry.registerCommand(WorkspaceCommands.COPY_RELATIVE_FILE_PATH, uri_command_handler_1.UriAwareCommandHandler.MultiSelect(this.selectionService, {
            isEnabled: uris => !!uris.length,
            isVisible: uris => !!uris.length,
            execute: async (uris) => {
                const lineDelimiter = common_2.EOL;
                const text = uris.map((uri) => {
                    var _a;
                    const workspaceRoot = this.workspaceService.getWorkspaceRootUri(uri);
                    if (workspaceRoot) {
                        return (_a = workspaceRoot.relative(uri)) === null || _a === void 0 ? void 0 : _a.fsPath();
                    }
                    else {
                        return uri.path.fsPath();
                    }
                }).join(lineDelimiter);
                await this.clipboardService.writeText(text);
            }
        }));
        registry.registerCommand(WorkspaceCommands.ADD_FOLDER, {
            isEnabled: () => this.workspaceService.opened,
            isVisible: () => this.workspaceService.opened,
            execute: async () => {
                const selection = await this.fileDialogService.showOpenDialog({
                    title: WorkspaceCommands.ADD_FOLDER.label,
                    canSelectFiles: false,
                    canSelectFolders: true,
                    canSelectMany: true,
                });
                if (!selection) {
                    return;
                }
                const uris = Array.isArray(selection) ? selection : [selection];
                const workspaceSavedBeforeAdding = this.workspaceService.saved;
                await this.addFolderToWorkspace(...uris);
                if (!workspaceSavedBeforeAdding) {
                    this.saveWorkspaceWithPrompt(registry);
                }
            }
        });
        registry.registerCommand(WorkspaceCommands.REMOVE_FOLDER, this.newMultiUriAwareCommandHandler({
            execute: uris => this.removeFolderFromWorkspace(uris),
            isEnabled: () => this.workspaceService.isMultiRootWorkspaceOpened,
            isVisible: uris => this.areWorkspaceRoots(uris) && this.workspaceService.saved
        }));
    }
    newUriAwareCommandHandler(handler) {
        return uri_command_handler_1.UriAwareCommandHandler.MonoSelect(this.selectionService, handler);
    }
    newMultiUriAwareCommandHandler(handler) {
        return uri_command_handler_1.UriAwareCommandHandler.MultiSelect(this.selectionService, handler);
    }
    newWorkspaceRootUriAwareCommandHandler(handler) {
        return new WorkspaceRootUriAwareCommandHandler(this.workspaceService, this.selectionService, handler);
    }
    async validateFileRename(oldName, newName, parent) {
        if (common_2.OS.backend.isWindows && parent.resource.resolve(newName).isEqual(parent.resource.resolve(oldName), false)) {
            return '';
        }
        return this.validateFileName(newName, parent, false);
    }
    /**
     * Returns an error message if the file name is invalid. Otherwise, an empty string.
     *
     * @param name the simple file name of the file to validate.
     * @param parent the parent directory's file stat.
     * @param allowNested allow file or folder creation using recursive path
     */
    async validateFileName(name, parent, allowNested = false) {
        if (!name) {
            return '';
        }
        // do not allow recursive rename
        if (!allowNested && !validFilename(name)) {
            return nls_1.nls.localizeByDefault('The name **{0}** is not valid as a file or folder name. Please choose a different name.');
        }
        if (name.startsWith('/')) {
            return nls_1.nls.localizeByDefault('A file or folder name cannot start with a slash.');
        }
        else if (name.startsWith(' ') || name.endsWith(' ')) {
            return nls_1.nls.localizeByDefault('Leading or trailing whitespace detected in file or folder name.');
        }
        // check and validate each sub-paths
        if (name.split(/[\\/]/).some(file => !file || !validFilename(file) || /^\s+$/.test(file))) {
            return nls_1.nls.localizeByDefault('\'{0}\' is not a valid file name', this.trimFileName(name));
        }
        const childUri = parent.resource.resolve(name);
        const exists = await this.fileService.exists(childUri);
        if (exists) {
            return nls_1.nls.localizeByDefault('A file or folder **{0}** already exists at this location. Please choose a different name.', this.trimFileName(name));
        }
        return '';
    }
    trimFileName(name) {
        if (name && name.length > 30) {
            return `${name.substring(0, 30)}...`;
        }
        return name;
    }
    async getDirectory(candidate) {
        let stat;
        try {
            stat = await this.fileService.resolve(candidate);
        }
        catch { }
        if (stat && stat.isDirectory) {
            return stat;
        }
        return this.getParent(candidate);
    }
    async getParent(candidate) {
        try {
            return await this.fileService.resolve(candidate.parent);
        }
        catch {
            return undefined;
        }
    }
    async addFolderToWorkspace(...uris) {
        if (uris.length) {
            const foldersToAdd = [];
            try {
                for (const uri of uris) {
                    const stat = await this.fileService.resolve(uri);
                    if (stat.isDirectory) {
                        foldersToAdd.push(uri);
                    }
                }
                await this.workspaceService.addRoot(foldersToAdd);
            }
            catch { }
        }
    }
    areWorkspaceRoots(uris) {
        return this.workspaceService.areWorkspaceRoots(uris);
    }
    isWorkspaceRoot(uri) {
        const rootUris = new Set(this.workspaceService.tryGetRoots().map(root => root.resource.toString()));
        return rootUris.has(uri.toString());
    }
    getDefaultFileConfig() {
        return {
            fileName: 'Untitled',
            fileExtension: '.txt'
        };
    }
    /**
     * Removes the list of folders from the workspace upon confirmation from the user.
     * @param uris the list of folder uris to remove.
     */
    async removeFolderFromWorkspace(uris) {
        const roots = new Set(this.workspaceService.tryGetRoots().map(root => root.resource.toString()));
        const toRemove = uris.filter(uri => roots.has(uri.toString()));
        if (toRemove.length > 0) {
            const messageContainer = document.createElement('div');
            if (toRemove.length > 1) {
                messageContainer.textContent = nls_1.nls.localize('theia/workspace/removeFolders', 'Are you sure you want to remove the following folders from the workspace?');
            }
            else {
                messageContainer.textContent = nls_1.nls.localize('theia/workspace/removeFolder', 'Are you sure you want to remove the following folder from the workspace?');
            }
            messageContainer.title = nls_1.nls.localize('theia/workspace/noErasure', 'Note: Nothing will be erased from disk');
            const list = document.createElement('div');
            list.classList.add('theia-dialog-node');
            toRemove.forEach(uri => {
                const listItem = document.createElement('div');
                listItem.classList.add('theia-dialog-node-content');
                const folderIcon = document.createElement('span');
                folderIcon.classList.add('codicon', 'codicon-root-folder', 'theia-dialog-icon');
                listItem.appendChild(folderIcon);
                listItem.title = this.labelProvider.getLongName(uri);
                const listContent = document.createElement('span');
                listContent.classList.add('theia-dialog-node-segment');
                listContent.appendChild(document.createTextNode(this.labelProvider.getName(uri)));
                listItem.appendChild(listContent);
                list.appendChild(listItem);
            });
            messageContainer.appendChild(list);
            const dialog = new dialogs_1.ConfirmDialog({
                title: nls_1.nls.localizeByDefault('Remove Folder from Workspace'),
                msg: messageContainer
            });
            if (await dialog.open()) {
                await this.workspaceService.removeRoots(toRemove);
            }
        }
    }
    async saveWorkspaceWithPrompt(registry) {
        const saveCommand = registry.getCommand(WorkspaceCommands.SAVE_WORKSPACE_AS.id);
        if (saveCommand && await new dialogs_1.ConfirmDialog({
            title: nls_1.nls.localize('theia/workspace/workspaceFolderAddedTitle', 'Folder added to Workspace'),
            msg: nls_1.nls.localize('theia/workspace/workspaceFolderAdded', 'A workspace with multiple roots was created. Do you want to save your workspace configuration as a file?'),
            ok: dialogs_1.Dialog.YES,
            cancel: dialogs_1.Dialog.NO
        }).open()) {
            return registry.executeCommand(saveCommand.id);
        }
    }
};
exports.WorkspaceCommandContribution = WorkspaceCommandContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.LabelProvider),
    tslib_1.__metadata("design:type", browser_2.LabelProvider)
], WorkspaceCommandContribution.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceCommandContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceCommandContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(selection_service_1.SelectionService),
    tslib_1.__metadata("design:type", selection_service_1.SelectionService)
], WorkspaceCommandContribution.prototype, "selectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.OpenerService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceCommandContribution.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.FrontendApplication),
    tslib_1.__metadata("design:type", browser_2.FrontendApplication)
], WorkspaceCommandContribution.prototype, "app", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    tslib_1.__metadata("design:type", message_service_1.MessageService)
], WorkspaceCommandContribution.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_preferences_1.WorkspacePreferences),
    tslib_1.__metadata("design:type", Object)
], WorkspaceCommandContribution.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.FileDialogService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceCommandContribution.prototype, "fileDialogService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_delete_handler_1.WorkspaceDeleteHandler),
    tslib_1.__metadata("design:type", workspace_delete_handler_1.WorkspaceDeleteHandler)
], WorkspaceCommandContribution.prototype, "deleteHandler", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_duplicate_handler_1.WorkspaceDuplicateHandler),
    tslib_1.__metadata("design:type", workspace_duplicate_handler_1.WorkspaceDuplicateHandler)
], WorkspaceCommandContribution.prototype, "duplicateHandler", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_compare_handler_1.WorkspaceCompareHandler),
    tslib_1.__metadata("design:type", workspace_compare_handler_1.WorkspaceCompareHandler)
], WorkspaceCommandContribution.prototype, "compareHandler", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceCommandContribution.prototype, "clipboardService", void 0);
exports.WorkspaceCommandContribution = WorkspaceCommandContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceCommandContribution);
class WorkspaceRootUriAwareCommandHandler extends uri_command_handler_1.UriAwareCommandHandler {
    constructor(workspaceService, selectionService, handler) {
        super(selectionService, handler);
        this.workspaceService = workspaceService;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    isEnabled(...args) {
        return super.isEnabled(...args) && !!this.workspaceService.tryGetRoots().length;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    isVisible(...args) {
        return super.isVisible(...args) && !!this.workspaceService.tryGetRoots().length;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    getUri(...args) {
        const uri = super.getUri(...args);
        // Return the `uri` immediately if the resource exists in any of the workspace roots.
        if (uri && this.workspaceService.getWorkspaceRootUri(uri)) {
            return uri;
        }
        // Return the first root if available.
        if (!!this.workspaceService.tryGetRoots().length) {
            return this.workspaceService.tryGetRoots()[0].resource;
        }
    }
}
exports.WorkspaceRootUriAwareCommandHandler = WorkspaceRootUriAwareCommandHandler;


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-compare-handler.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-compare-handler.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceCompareHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const diff_service_1 = __webpack_require__(/*! ./diff-service */ "../../node_modules/@theia/workspace/lib/browser/diff-service.js");
let WorkspaceCompareHandler = class WorkspaceCompareHandler {
    /**
     * Determine if the command is visible.
     *
     * @param uris URIs of selected resources.
     * @returns `true` if the command is visible.
     */
    isVisible(uris) {
        return uris.length === 2;
    }
    /**
     * Determine if the command is enabled.
     *
     * @param uris URIs of selected resources.
     * @returns `true` if the command is enabled.
     */
    isEnabled(uris) {
        return uris.length === 2;
    }
    /**
     * Execute the command.
     *
     * @param uris URIs of selected resources.
     */
    async execute(uris) {
        const [left, right] = uris;
        await this.diffService.openDiffEditor(left, right);
    }
};
exports.WorkspaceCompareHandler = WorkspaceCompareHandler;
tslib_1.__decorate([
    (0, inversify_1.inject)(diff_service_1.DiffService),
    tslib_1.__metadata("design:type", diff_service_1.DiffService)
], WorkspaceCompareHandler.prototype, "diffService", void 0);
exports.WorkspaceCompareHandler = WorkspaceCompareHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceCompareHandler);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-delete-handler.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-delete-handler.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceDeleteHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const workspace_utils_1 = __webpack_require__(/*! ./workspace-utils */ "../../node_modules/@theia/workspace/lib/browser/workspace-utils.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const filesystem_preferences_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/filesystem-preferences */ "../../node_modules/@theia/filesystem/lib/browser/filesystem-preferences.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let WorkspaceDeleteHandler = class WorkspaceDeleteHandler {
    /**
     * Determine if the command is visible.
     *
     * @param uris URIs of selected resources.
     * @returns `true` if the command is visible.
     */
    isVisible(uris) {
        return !!uris.length && !this.workspaceUtils.containsRootDirectory(uris);
    }
    /**
     * Determine if the command is enabled.
     *
     * @param uris URIs of selected resources.
     * @returns `true` if the command is enabled.
     */
    isEnabled(uris) {
        return !!uris.length && !this.workspaceUtils.containsRootDirectory(uris);
    }
    /**
     * Execute the command.
     *
     * @param uris URIs of selected resources.
     */
    async execute(uris) {
        const distinctUris = uri_1.default.getDistinctParents(uris);
        const resolved = {
            recursive: true,
            useTrash: this.fsPreferences['files.enableTrash'] && distinctUris[0] && this.fileService.hasCapability(distinctUris[0], 4096 /* FileSystemProviderCapabilities.Trash */)
        };
        if (await this.confirm(distinctUris, resolved)) {
            await Promise.all(distinctUris.map(uri => this.delete(uri, resolved)));
        }
    }
    /**
     * Display dialog to confirm deletion.
     *
     * @param uris URIs of selected resources.
     */
    confirm(uris, options) {
        let title = uris.length === 1 ? nls_1.nls.localizeByDefault('File') : nls_1.nls.localizeByDefault('Files');
        if (options.useTrash) {
            title = nls_1.nls.localize('theia/workspace/trashTitle', 'Move {0} to Trash', title);
        }
        else {
            title = nls_1.nls.localizeByDefault('Delete {0}', title);
        }
        return new browser_1.ConfirmDialog({
            title,
            msg: this.getConfirmMessage(uris)
        }).open();
    }
    /**
     * Get the dialog confirmation message for deletion.
     *
     * @param uris URIs of selected resources.
     */
    getConfirmMessage(uris) {
        const dirty = this.getDirty(uris);
        if (dirty.length) {
            if (dirty.length === 1) {
                return nls_1.nls.localize('theia/workspace/confirmMessage.dirtySingle', 'Do you really want to delete {0} with unsaved changes?', dirty[0].path.base);
            }
            return nls_1.nls.localize('theia/workspace/confirmMessage.dirtyMultiple', 'Do you really want to delete {0} files with unsaved changes?', dirty.length);
        }
        if (uris.length === 1) {
            return nls_1.nls.localize('theia/workspace/confirmMessage.uriSingle', 'Do you really want to delete {0}?', uris[0].path.base);
        }
        if (uris.length > 10) {
            return nls_1.nls.localize('theia/workspace/confirmMessage.uriMultiple', 'Do you really want to delete all the {0} selected files?', uris.length);
        }
        const messageContainer = document.createElement('div');
        messageContainer.textContent = nls_1.nls.localize('theia/workspace/confirmMessage.delete', 'Do you really want to delete the following files?');
        const list = document.createElement('ul');
        list.style.listStyleType = 'none';
        for (const uri of uris) {
            const listItem = document.createElement('li');
            listItem.textContent = uri.path.base;
            list.appendChild(listItem);
        }
        messageContainer.appendChild(list);
        return messageContainer;
    }
    /**
     * Get which URI are presently dirty.
     *
     * @param uris URIs of selected resources.
     * @returns An array of dirty URI.
     */
    getDirty(uris) {
        const dirty = new Map();
        const widgets = browser_1.NavigatableWidget.getAffected(browser_1.SaveableWidget.getDirty(this.shell.widgets), uris);
        for (const [resourceUri] of widgets) {
            dirty.set(resourceUri.toString(), resourceUri);
        }
        return [...dirty.values()];
    }
    /**
     * Perform deletion of a given URI.
     *
     * @param uri URI of selected resource.
     * @param options deletion options.
     */
    async delete(uri, options) {
        try {
            await Promise.all([
                this.closeWithoutSaving(uri),
                options.useTrash ? this.moveFileToTrash(uri, options) : this.deleteFilePermanently(uri, options)
            ]);
        }
        catch (e) {
            console.error(e);
        }
    }
    async deleteFilePermanently(uri, options) {
        this.fileService.delete(uri, { ...options, useTrash: false });
    }
    async moveFileToTrash(uri, options) {
        try {
            await this.fileService.delete(uri, { ...options, useTrash: true });
        }
        catch (error) {
            console.error('Error deleting with trash:', error);
            if (await this.confirmDeletePermanently(uri)) {
                return this.deleteFilePermanently(uri, options);
            }
        }
    }
    /**
     * Display dialog to confirm the permanent deletion of a file.
     *
     * @param uri URI of selected resource.
     */
    async confirmDeletePermanently(uri) {
        const title = nls_1.nls.localize('theia/workspace/confirmDeletePermanently.title', 'Error deleting file');
        const msg = document.createElement('div');
        const question = document.createElement('p');
        question.textContent = nls_1.nls.localize('theia/workspace/confirmDeletePermanently.description', 'Failed to delete "{0}" using the Trash. Do you want to permanently delete instead?', uri.path.base);
        msg.append(question);
        const info = document.createElement('p');
        info.textContent = nls_1.nls.localize('theia/workspace/confirmDeletePermanently.solution', 'You can disable the use of Trash in the preferences.');
        msg.append(info);
        const response = await new browser_1.ConfirmDialog({ title, msg }).open();
        return response || false;
    }
    /**
     * Close widget without saving changes.
     *
     * @param uri URI of a selected resource.
     */
    async closeWithoutSaving(uri) {
        const toClose = [...browser_1.NavigatableWidget.getAffected(this.shell.widgets, uri)].map(([, widget]) => widget);
        await this.shell.closeMany(toClose, { save: false });
    }
};
exports.WorkspaceDeleteHandler = WorkspaceDeleteHandler;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceDeleteHandler.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], WorkspaceDeleteHandler.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_utils_1.WorkspaceUtils),
    tslib_1.__metadata("design:type", workspace_utils_1.WorkspaceUtils)
], WorkspaceDeleteHandler.prototype, "workspaceUtils", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceDeleteHandler.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(filesystem_preferences_1.FileSystemPreferences),
    tslib_1.__metadata("design:type", Object)
], WorkspaceDeleteHandler.prototype, "fsPreferences", void 0);
exports.WorkspaceDeleteHandler = WorkspaceDeleteHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceDeleteHandler);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-duplicate-handler.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-duplicate-handler.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceDuplicateHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const workspace_utils_1 = __webpack_require__(/*! ./workspace-utils */ "../../node_modules/@theia/workspace/lib/browser/workspace-utils.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const filesystem_utils_1 = __webpack_require__(/*! @theia/filesystem/lib/common/filesystem-utils */ "../../node_modules/@theia/filesystem/lib/common/filesystem-utils.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
let WorkspaceDuplicateHandler = class WorkspaceDuplicateHandler {
    /**
     * Determine if the command is visible.
     *
     * @param uris URIs of selected resources.
     * @returns `true` if the command is visible.
     */
    isVisible(uris) {
        return !!uris.length && !this.workspaceUtils.containsRootDirectory(uris);
    }
    /**
     * Determine if the command is enabled.
     *
     * @param uris URIs of selected resources.
     * @returns `true` if the command is enabled.
     */
    isEnabled(uris) {
        return !!uris.length && !this.workspaceUtils.containsRootDirectory(uris);
    }
    /**
     * Execute the command.
     *
     * @param uris URIs of selected resources.
     */
    async execute(uris) {
        await Promise.all(uris.map(async (uri) => {
            try {
                const parent = await this.fileService.resolve(uri.parent);
                const targetFileStat = await this.fileService.resolve(uri);
                const target = filesystem_utils_1.FileSystemUtils.generateUniqueResourceURI(parent, uri, targetFileStat.isDirectory, 'copy');
                await this.fileService.copy(uri, target);
            }
            catch (e) {
                console.error(e);
            }
        }));
    }
};
exports.WorkspaceDuplicateHandler = WorkspaceDuplicateHandler;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceDuplicateHandler.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_utils_1.WorkspaceUtils),
    tslib_1.__metadata("design:type", workspace_utils_1.WorkspaceUtils)
], WorkspaceDuplicateHandler.prototype, "workspaceUtils", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceDuplicateHandler.prototype, "workspaceService", void 0);
exports.WorkspaceDuplicateHandler = WorkspaceDuplicateHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceDuplicateHandler);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceFrontendContribution = exports.FILE_WORKSPACE = exports.WorkspaceStates = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const common_2 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/workspace/lib/common/index.js");
const workspace_commands_1 = __webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js");
const quick_open_workspace_1 = __webpack_require__(/*! ./quick-open-workspace */ "../../node_modules/@theia/workspace/lib/browser/quick-open-workspace.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const encoding_registry_1 = __webpack_require__(/*! @theia/core/lib/browser/encoding-registry */ "../../node_modules/@theia/core/lib/browser/encoding-registry.js");
const encodings_1 = __webpack_require__(/*! @theia/core/lib/common/encodings */ "../../node_modules/@theia/core/lib/common/encodings.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const preference_configurations_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-configurations */ "../../node_modules/@theia/core/lib/browser/preferences/preference-configurations.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const buffer_1 = __webpack_require__(/*! @theia/core/lib/common/buffer */ "../../node_modules/@theia/core/lib/common/buffer.js");
const untitled_workspace_exit_dialog_1 = __webpack_require__(/*! ./untitled-workspace-exit-dialog */ "../../node_modules/@theia/workspace/lib/browser/untitled-workspace-exit-dialog.js");
const filesystem_saveable_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/filesystem-saveable-service */ "../../node_modules/@theia/filesystem/lib/browser/filesystem-saveable-service.js");
const frontend_application_state_1 = __webpack_require__(/*! @theia/core/lib/common/frontend-application-state */ "../../node_modules/@theia/core/lib/common/frontend-application-state.js");
var WorkspaceStates;
(function (WorkspaceStates) {
    /**
     * The state is `empty` when no workspace is opened.
     */
    WorkspaceStates["empty"] = "empty";
    /**
     * The state is `workspace` when a workspace is opened.
     */
    WorkspaceStates["workspace"] = "workspace";
    /**
     * The state is `folder` when a folder is opened. (1 folder)
     */
    WorkspaceStates["folder"] = "folder";
})(WorkspaceStates || (exports.WorkspaceStates = WorkspaceStates = {}));
;
/** Create the workspace section after open {@link CommonMenus.FILE_OPEN}. */
exports.FILE_WORKSPACE = [...browser_1.CommonMenus.FILE, '2_workspace'];
let WorkspaceFrontendContribution = class WorkspaceFrontendContribution {
    constructor() {
        this.toDisposeOnUpdateEncodingOverrides = new disposable_1.DisposableCollection();
    }
    configure() {
        const workspaceExtensions = this.workspaceFileService.getWorkspaceFileExtensions();
        for (const extension of workspaceExtensions) {
            this.encodingRegistry.registerOverride({ encoding: encodings_1.UTF8, extension });
        }
        this.updateEncodingOverrides();
        const workspaceFolderCountKey = this.contextKeyService.createKey('workspaceFolderCount', 0);
        const updateWorkspaceFolderCountKey = () => workspaceFolderCountKey.set(this.workspaceService.tryGetRoots().length);
        updateWorkspaceFolderCountKey();
        const workspaceStateKey = this.contextKeyService.createKey('workspaceState', 'empty');
        const updateWorkspaceStateKey = () => workspaceStateKey.set(this.updateWorkspaceStateKey());
        updateWorkspaceStateKey();
        const workbenchStateKey = this.contextKeyService.createKey('workbenchState', 'empty');
        const updateWorkbenchStateKey = () => workbenchStateKey.set(this.updateWorkbenchStateKey());
        updateWorkbenchStateKey();
        this.updateStyles();
        this.workspaceService.onWorkspaceChanged(() => {
            this.updateEncodingOverrides();
            updateWorkspaceFolderCountKey();
            updateWorkspaceStateKey();
            updateWorkbenchStateKey();
            this.updateStyles();
        });
    }
    updateEncodingOverrides() {
        this.toDisposeOnUpdateEncodingOverrides.dispose();
        for (const root of this.workspaceService.tryGetRoots()) {
            for (const configPath of this.preferenceConfigurations.getPaths()) {
                const parent = root.resource.resolve(configPath);
                this.toDisposeOnUpdateEncodingOverrides.push(this.encodingRegistry.registerOverride({ encoding: encodings_1.UTF8, parent }));
            }
        }
    }
    updateStyles() {
        document.body.classList.remove('theia-no-open-workspace');
        // Display the 'no workspace opened' theme color when no folders are opened (single-root).
        if (!this.workspaceService.isMultiRootWorkspaceOpened &&
            !this.workspaceService.tryGetRoots().length) {
            document.body.classList.add('theia-no-open-workspace');
        }
    }
    registerCommands(commands) {
        // Not visible/enabled on Windows/Linux in electron.
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.OPEN, {
            isEnabled: () => core_1.isOSX || !this.isElectron(),
            isVisible: () => core_1.isOSX || !this.isElectron(),
            execute: () => this.doOpen()
        });
        // Visible/enabled only on Windows/Linux in electron.
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.OPEN_FILE, {
            isEnabled: () => true,
            execute: () => this.doOpenFile()
        });
        // Visible/enabled only on Windows/Linux in electron.
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.OPEN_FOLDER, {
            isEnabled: () => true,
            execute: () => this.doOpenFolder()
        });
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE, {
            isEnabled: () => true,
            execute: () => this.doOpenWorkspace()
        });
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.CLOSE, {
            isEnabled: () => this.workspaceService.opened,
            execute: () => this.closeWorkspace()
        });
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.OPEN_RECENT_WORKSPACE, {
            execute: () => this.quickOpenWorkspace.select()
        });
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.SAVE_WORKSPACE_AS, {
            isVisible: () => this.workspaceService.opened,
            isEnabled: () => this.workspaceService.opened,
            execute: () => this.saveWorkspaceAs()
        });
        commands.registerCommand(workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE_FILE, {
            isEnabled: () => this.workspaceService.saved,
            execute: () => {
                if (this.workspaceService.saved && this.workspaceService.workspace) {
                    (0, browser_1.open)(this.openerService, this.workspaceService.workspace.resource);
                }
            }
        });
    }
    registerMenus(menus) {
        if (core_1.isOSX || !this.isElectron()) {
            menus.registerMenuAction(browser_1.CommonMenus.FILE_OPEN, {
                commandId: workspace_commands_1.WorkspaceCommands.OPEN.id,
                order: 'a00'
            });
        }
        if (!core_1.isOSX && this.isElectron()) {
            menus.registerMenuAction(browser_1.CommonMenus.FILE_OPEN, {
                commandId: workspace_commands_1.WorkspaceCommands.OPEN_FILE.id,
                label: `${workspace_commands_1.WorkspaceCommands.OPEN_FILE.dialogLabel}...`,
                order: 'a01'
            });
            menus.registerMenuAction(browser_1.CommonMenus.FILE_OPEN, {
                commandId: workspace_commands_1.WorkspaceCommands.OPEN_FOLDER.id,
                label: `${workspace_commands_1.WorkspaceCommands.OPEN_FOLDER.dialogLabel}...`,
                order: 'a02'
            });
        }
        menus.registerMenuAction(browser_1.CommonMenus.FILE_OPEN, {
            commandId: workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE.id,
            order: 'a10'
        });
        menus.registerMenuAction(browser_1.CommonMenus.FILE_OPEN, {
            commandId: workspace_commands_1.WorkspaceCommands.OPEN_RECENT_WORKSPACE.id,
            order: 'a20'
        });
        menus.registerMenuAction(exports.FILE_WORKSPACE, {
            commandId: workspace_commands_1.WorkspaceCommands.ADD_FOLDER.id,
            order: 'a10'
        });
        menus.registerMenuAction(exports.FILE_WORKSPACE, {
            commandId: workspace_commands_1.WorkspaceCommands.SAVE_WORKSPACE_AS.id,
            order: 'a20'
        });
        menus.registerMenuAction(browser_1.CommonMenus.FILE_CLOSE, {
            commandId: workspace_commands_1.WorkspaceCommands.CLOSE.id
        });
        menus.registerMenuAction(browser_1.CommonMenus.FILE_SAVE, {
            commandId: workspace_commands_1.WorkspaceCommands.SAVE_AS.id,
        });
        menus.registerMenuAction(browser_1.SHELL_TABBAR_CONTEXT_COPY, {
            commandId: workspace_commands_1.WorkspaceCommands.COPY_RELATIVE_FILE_PATH.id,
            label: workspace_commands_1.WorkspaceCommands.COPY_RELATIVE_FILE_PATH.label,
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: core_1.isOSX || !this.isElectron() ? workspace_commands_1.WorkspaceCommands.OPEN.id : workspace_commands_1.WorkspaceCommands.OPEN_FILE.id,
            keybinding: this.isElectron() ? 'ctrlcmd+o' : 'ctrlcmd+alt+o',
        });
        if (!core_1.isOSX && this.isElectron()) {
            keybindings.registerKeybinding({
                command: workspace_commands_1.WorkspaceCommands.OPEN_FOLDER.id,
                keybinding: 'ctrl+k ctrl+o',
            });
        }
        keybindings.registerKeybinding({
            command: workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE.id,
            keybinding: 'ctrlcmd+alt+w',
        });
        keybindings.registerKeybinding({
            command: workspace_commands_1.WorkspaceCommands.OPEN_RECENT_WORKSPACE.id,
            keybinding: 'ctrlcmd+alt+r',
        });
        keybindings.registerKeybinding({
            command: workspace_commands_1.WorkspaceCommands.SAVE_AS.id,
            keybinding: 'ctrlcmd+shift+s',
        });
        keybindings.registerKeybinding({
            command: workspace_commands_1.WorkspaceCommands.COPY_RELATIVE_FILE_PATH.id,
            keybinding: common_1.isWindows ? 'ctrl+k ctrl+shift+c' : 'ctrlcmd+shift+alt+c',
            when: '!editorFocus'
        });
    }
    /**
     * This is the generic `Open` method. Opens files and directories too. Resolves to the opened URI.
     * Except when you are on either Windows or Linux `AND` running in electron. If so, it opens a file.
     */
    async doOpen() {
        var _a;
        if (!core_1.isOSX && this.isElectron()) {
            return this.doOpenFile();
        }
        const [rootStat] = await this.workspaceService.roots;
        let selectedUris = await this.fileDialogService.showOpenDialog({
            title: workspace_commands_1.WorkspaceCommands.OPEN.dialogLabel,
            canSelectFolders: true,
            canSelectFiles: true,
            canSelectMany: true
        }, rootStat);
        if (selectedUris) {
            if (!Array.isArray(selectedUris)) {
                selectedUris = [selectedUris];
            }
            const folders = [];
            //  Only open files then open all folders in a new workspace, as done with Electron see doOpenFolder.
            for (const uri of selectedUris) {
                const destination = await this.fileService.resolve(uri);
                if (destination.isDirectory) {
                    if (((_a = this.getCurrentWorkspaceUri()) === null || _a === void 0 ? void 0 : _a.toString()) !== uri.toString()) {
                        folders.push(uri);
                    }
                }
                else {
                    await (0, browser_1.open)(this.openerService, uri);
                }
            }
            if (folders.length > 0) {
                const openableURI = await this.getOpenableWorkspaceUri(folders);
                if (openableURI && (!this.workspaceService.workspace || !openableURI.isEqual(this.workspaceService.workspace.resource))) {
                    this.workspaceService.open(openableURI);
                }
            }
            return selectedUris;
        }
        return undefined;
    }
    /**
     * Opens a set of files after prompting the `Open File` dialog. Resolves to `undefined`, if
     *  - the workspace root is not set,
     *  - the file to open does not exist, or
     *  - it was not a file, but a directory.
     *
     * Otherwise, resolves to the set of URIs of the files.
     */
    async doOpenFile() {
        const props = {
            title: workspace_commands_1.WorkspaceCommands.OPEN_FILE.dialogLabel,
            canSelectFolders: false,
            canSelectFiles: true,
            canSelectMany: true
        };
        const [rootStat] = await this.workspaceService.roots;
        let selectedFilesUris = await this.fileDialogService.showOpenDialog(props, rootStat);
        if (selectedFilesUris) {
            if (!Array.isArray(selectedFilesUris)) {
                selectedFilesUris = [selectedFilesUris];
            }
            const result = [];
            for (const uri of selectedFilesUris) {
                const destination = await this.fileService.resolve(uri);
                if (destination.isFile) {
                    await (0, browser_1.open)(this.openerService, uri);
                    result.push(uri);
                }
            }
            return result;
        }
        return undefined;
    }
    /**
     * Opens one or more folders after prompting the `Open Folder` dialog. Resolves to `undefined`, if
     *  - the user's selection is empty or contains only files.
     *  - the new workspace is equal to the old workspace.
     *
     * Otherwise, resolves to the URI of the new workspace:
     *  - a single folder if a single folder was selected.
     *  - a new, untitled workspace file if multiple folders were selected.
     */
    async doOpenFolder() {
        const props = {
            title: workspace_commands_1.WorkspaceCommands.OPEN_FOLDER.dialogLabel,
            canSelectFolders: true,
            canSelectFiles: false,
            canSelectMany: true,
        };
        const [rootStat] = await this.workspaceService.roots;
        const targetFolders = await this.fileDialogService.showOpenDialog(props, rootStat);
        if (targetFolders) {
            const openableUri = await this.getOpenableWorkspaceUri(targetFolders);
            if (openableUri) {
                if (!this.workspaceService.workspace || !openableUri.isEqual(this.workspaceService.workspace.resource)) {
                    this.workspaceService.open(openableUri);
                    return openableUri;
                }
            }
            ;
        }
        return undefined;
    }
    async getOpenableWorkspaceUri(uris) {
        if (Array.isArray(uris)) {
            if (uris.length < 2) {
                return uris[0];
            }
            else {
                const foldersToOpen = (await Promise.all(uris.map(uri => this.fileService.resolve(uri))))
                    .filter(fileStat => !!(fileStat === null || fileStat === void 0 ? void 0 : fileStat.isDirectory));
                if (foldersToOpen.length === 1) {
                    return foldersToOpen[0].resource;
                }
                else {
                    return this.createMultiRootWorkspace(foldersToOpen);
                }
            }
        }
        else {
            return uris;
        }
    }
    async createMultiRootWorkspace(roots) {
        const untitledWorkspace = await this.workspaceService.getUntitledWorkspace();
        const folders = Array.from(new Set(roots.map(stat => stat.resource.path.toString())), path => ({ path }));
        const workspaceStat = await this.fileService.createFile(untitledWorkspace, buffer_1.BinaryBuffer.fromString(JSON.stringify({ folders }, null, 4)), // eslint-disable-line no-null/no-null
        { overwrite: true });
        return workspaceStat.resource;
    }
    /**
     * Opens a workspace after raising the `Open Workspace` dialog. Resolves to the URI of the recently opened workspace,
     * if it was successful. Otherwise, resolves to `undefined`.
     */
    async doOpenWorkspace() {
        var _a;
        const props = {
            title: workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE.dialogLabel,
            canSelectFiles: true,
            canSelectFolders: false,
            filters: this.getWorkspaceDialogFileFilters()
        };
        const [rootStat] = await this.workspaceService.roots;
        const workspaceFileUri = await this.fileDialogService.showOpenDialog(props, rootStat);
        if (workspaceFileUri &&
            ((_a = this.getCurrentWorkspaceUri()) === null || _a === void 0 ? void 0 : _a.toString()) !== workspaceFileUri.toString()) {
            if (await this.fileService.exists(workspaceFileUri)) {
                this.workspaceService.open(workspaceFileUri);
                return workspaceFileUri;
            }
        }
        return undefined;
    }
    async closeWorkspace() {
        await this.workspaceService.close();
    }
    /**
     * @returns whether the file was successfully saved.
     */
    async saveWorkspaceAs() {
        let exist = false;
        let overwrite = false;
        let selected;
        do {
            selected = await this.fileDialogService.showSaveDialog({
                title: workspace_commands_1.WorkspaceCommands.SAVE_WORKSPACE_AS.label,
                filters: this.getWorkspaceDialogFileFilters()
            });
            if (selected) {
                const displayName = selected.displayName;
                const extensions = this.workspaceFileService.getWorkspaceFileExtensions(true);
                if (!extensions.some(ext => displayName.endsWith(ext))) {
                    const defaultExtension = extensions[this.workspaceFileService.defaultFileTypeIndex];
                    selected = selected.parent.resolve(`${displayName}${defaultExtension}`);
                }
                exist = await this.fileService.exists(selected);
                if (exist) {
                    overwrite = await this.saveService.confirmOverwrite(selected);
                }
            }
        } while (selected && exist && !overwrite);
        if (selected) {
            try {
                await this.workspaceService.save(selected);
                return true;
            }
            catch {
                this.messageService.error(nls_1.nls.localizeByDefault("Unable to save workspace '{0}'", selected.path.fsPath()));
            }
        }
        return false;
    }
    canBeSavedAs(widget) {
        return this.saveService.canSaveAs(widget);
    }
    async saveAs(widget) {
        await this.saveService.saveAs(widget);
    }
    updateWorkspaceStateKey() {
        return this.doUpdateState();
    }
    updateWorkbenchStateKey() {
        return this.doUpdateState();
    }
    doUpdateState() {
        if (this.workspaceService.opened) {
            return this.workspaceService.isMultiRootWorkspaceOpened ? 'workspace' : 'folder';
        }
        return 'empty';
    }
    getWorkspaceDialogFileFilters() {
        const filters = {};
        for (const fileType of this.workspaceFileService.getWorkspaceFileTypes()) {
            filters[`${nls_1.nls.localizeByDefault('{0} workspace', fileType.name)} (*.${fileType.extension})`] = [fileType.extension];
        }
        return filters;
    }
    isElectron() {
        return core_1.environment.electron.is();
    }
    /**
     * Get the current workspace URI.
     *
     * @returns the current workspace URI.
     */
    getCurrentWorkspaceUri() {
        var _a;
        return (_a = this.workspaceService.workspace) === null || _a === void 0 ? void 0 : _a.resource;
    }
    onWillStop() {
        const { workspace } = this.workspaceService;
        if (workspace && this.workspaceService.isUntitledWorkspace(workspace.resource)) {
            return {
                prepare: async (reason) => reason === frontend_application_state_1.StopReason.Reload && this.workspaceService.isSafeToReload(workspace.resource),
                action: async (alreadyConfirmedSafe) => {
                    if (alreadyConfirmedSafe) {
                        return true;
                    }
                    const shouldSaveFile = await new untitled_workspace_exit_dialog_1.UntitledWorkspaceExitDialog({
                        title: nls_1.nls.localizeByDefault('Do you want to save your workspace configuration as a file?')
                    }).open();
                    if (shouldSaveFile === "Don't Save") {
                        return true;
                    }
                    else if (shouldSaveFile === 'Save') {
                        return this.saveWorkspaceAs();
                    }
                    return false; // If cancel, prevent exit.
                },
                reason: 'Untitled workspace.',
                // Since deleting the workspace would hobble any future functionality, run this late.
                priority: 100,
            };
        }
    }
};
exports.WorkspaceFrontendContribution = WorkspaceFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MessageService),
    tslib_1.__metadata("design:type", common_1.MessageService)
], WorkspaceFrontendContribution.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceFrontendContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceFrontendContribution.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceFrontendContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_open_workspace_1.QuickOpenWorkspace),
    tslib_1.__metadata("design:type", quick_open_workspace_1.QuickOpenWorkspace)
], WorkspaceFrontendContribution.prototype, "quickOpenWorkspace", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.FileDialogService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceFrontendContribution.prototype, "fileDialogService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceFrontendContribution.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(encoding_registry_1.EncodingRegistry),
    tslib_1.__metadata("design:type", encoding_registry_1.EncodingRegistry)
], WorkspaceFrontendContribution.prototype, "encodingRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_configurations_1.PreferenceConfigurations),
    tslib_1.__metadata("design:type", preference_configurations_1.PreferenceConfigurations)
], WorkspaceFrontendContribution.prototype, "preferenceConfigurations", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(filesystem_saveable_service_1.FilesystemSaveableService),
    tslib_1.__metadata("design:type", filesystem_saveable_service_1.FilesystemSaveableService)
], WorkspaceFrontendContribution.prototype, "saveService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_2.WorkspaceFileService),
    tslib_1.__metadata("design:type", common_2.WorkspaceFileService)
], WorkspaceFrontendContribution.prototype, "workspaceFileService", void 0);
exports.WorkspaceFrontendContribution = WorkspaceFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceFrontendContribution);
(function (WorkspaceFrontendContribution) {
    /**
     * File filter for all Theia and VS Code workspace file types.
     *
     * @deprecated Since 1.39.0 Use `WorkspaceFrontendContribution#getWorkspaceDialogFileFilters` instead.
     */
    WorkspaceFrontendContribution.DEFAULT_FILE_FILTER = {
        'Theia Workspace (*.theia-workspace)': [common_2.THEIA_EXT],
        'VS Code Workspace (*.code-workspace)': [common_2.VSCODE_EXT]
    };
})(WorkspaceFrontendContribution || (exports.WorkspaceFrontendContribution = WorkspaceFrontendContribution = {}));


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const storage_service_1 = __webpack_require__(/*! @theia/core/lib/browser/storage-service */ "../../node_modules/@theia/core/lib/browser/storage-service.js");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "../../node_modules/@theia/core/lib/browser/label-provider.js");
const browser_3 = __webpack_require__(/*! @theia/variable-resolver/lib/browser */ "../../node_modules/@theia/variable-resolver/lib/browser/index.js");
const common_2 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/workspace/lib/common/index.js");
const workspace_frontend_contribution_1 = __webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const workspace_commands_1 = __webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js");
const workspace_variable_contribution_1 = __webpack_require__(/*! ./workspace-variable-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-variable-contribution.js");
const workspace_storage_service_1 = __webpack_require__(/*! ./workspace-storage-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-storage-service.js");
const workspace_uri_contribution_1 = __webpack_require__(/*! ./workspace-uri-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-uri-contribution.js");
const workspace_preferences_1 = __webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js");
const quick_open_workspace_1 = __webpack_require__(/*! ./quick-open-workspace */ "../../node_modules/@theia/workspace/lib/browser/quick-open-workspace.js");
const workspace_delete_handler_1 = __webpack_require__(/*! ./workspace-delete-handler */ "../../node_modules/@theia/workspace/lib/browser/workspace-delete-handler.js");
const workspace_duplicate_handler_1 = __webpack_require__(/*! ./workspace-duplicate-handler */ "../../node_modules/@theia/workspace/lib/browser/workspace-duplicate-handler.js");
const workspace_utils_1 = __webpack_require__(/*! ./workspace-utils */ "../../node_modules/@theia/workspace/lib/browser/workspace-utils.js");
const workspace_compare_handler_1 = __webpack_require__(/*! ./workspace-compare-handler */ "../../node_modules/@theia/workspace/lib/browser/workspace-compare-handler.js");
const diff_service_1 = __webpack_require__(/*! ./diff-service */ "../../node_modules/@theia/workspace/lib/browser/diff-service.js");
const json_schema_store_1 = __webpack_require__(/*! @theia/core/lib/browser/json-schema-store */ "../../node_modules/@theia/core/lib/browser/json-schema-store.js");
const workspace_schema_updater_1 = __webpack_require__(/*! ./workspace-schema-updater */ "../../node_modules/@theia/workspace/lib/browser/workspace-schema-updater.js");
const workspace_breadcrumbs_contribution_1 = __webpack_require__(/*! ./workspace-breadcrumbs-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-breadcrumbs-contribution.js");
const filepath_breadcrumbs_contribution_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution */ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution.js");
const workspace_trust_service_1 = __webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js");
const workspace_trust_preferences_1 = __webpack_require__(/*! ./workspace-trust-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-preferences.js");
const user_working_directory_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/user-working-directory-provider */ "../../node_modules/@theia/core/lib/browser/user-working-directory-provider.js");
const workspace_user_working_directory_provider_1 = __webpack_require__(/*! ./workspace-user-working-directory-provider */ "../../node_modules/@theia/workspace/lib/browser/workspace-user-working-directory-provider.js");
const window_title_updater_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-title-updater */ "../../node_modules/@theia/core/lib/browser/window/window-title-updater.js");
const workspace_window_title_updater_1 = __webpack_require__(/*! ./workspace-window-title-updater */ "../../node_modules/@theia/workspace/lib/browser/workspace-window-title-updater.js");
const canonical_uri_service_1 = __webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js");
exports["default"] = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    (0, workspace_preferences_1.bindWorkspacePreferences)(bind);
    (0, workspace_trust_preferences_1.bindWorkspaceTrustPreferences)(bind);
    (0, common_1.bindContributionProvider)(bind, workspace_service_1.WorkspaceOpenHandlerContribution);
    bind(workspace_service_1.WorkspaceService).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(workspace_service_1.WorkspaceService);
    bind(canonical_uri_service_1.CanonicalUriService).toSelf().inSingletonScope();
    bind(common_2.WorkspaceServer).toDynamicValue(ctx => {
        const provider = ctx.container.get(browser_1.WebSocketConnectionProvider);
        return provider.createProxy(common_2.workspacePath);
    }).inSingletonScope();
    bind(workspace_frontend_contribution_1.WorkspaceFrontendContribution).toSelf().inSingletonScope();
    for (const identifier of [browser_1.FrontendApplicationContribution, common_1.CommandContribution, browser_1.KeybindingContribution, common_1.MenuContribution]) {
        bind(identifier).toService(workspace_frontend_contribution_1.WorkspaceFrontendContribution);
    }
    bind(browser_2.OpenFileDialogFactory).toFactory(ctx => (props) => (0, browser_2.createOpenFileDialogContainer)(ctx.container, props).get(browser_2.OpenFileDialog));
    bind(browser_2.SaveFileDialogFactory).toFactory(ctx => (props) => (0, browser_2.createSaveFileDialogContainer)(ctx.container, props).get(browser_2.SaveFileDialog));
    bind(workspace_commands_1.WorkspaceCommandContribution).toSelf().inSingletonScope();
    bind(common_1.CommandContribution).toService(workspace_commands_1.WorkspaceCommandContribution);
    bind(workspace_commands_1.FileMenuContribution).toSelf().inSingletonScope();
    bind(common_1.MenuContribution).toService(workspace_commands_1.FileMenuContribution);
    bind(workspace_commands_1.EditMenuContribution).toSelf().inSingletonScope();
    bind(common_1.MenuContribution).toService(workspace_commands_1.EditMenuContribution);
    bind(workspace_delete_handler_1.WorkspaceDeleteHandler).toSelf().inSingletonScope();
    bind(workspace_duplicate_handler_1.WorkspaceDuplicateHandler).toSelf().inSingletonScope();
    bind(workspace_compare_handler_1.WorkspaceCompareHandler).toSelf().inSingletonScope();
    bind(diff_service_1.DiffService).toSelf().inSingletonScope();
    bind(workspace_storage_service_1.WorkspaceStorageService).toSelf().inSingletonScope();
    rebind(storage_service_1.StorageService).toService(workspace_storage_service_1.WorkspaceStorageService);
    bind(label_provider_1.LabelProviderContribution).to(workspace_uri_contribution_1.WorkspaceUriLabelProviderContribution).inSingletonScope();
    bind(workspace_variable_contribution_1.WorkspaceVariableContribution).toSelf().inSingletonScope();
    bind(browser_3.VariableContribution).toService(workspace_variable_contribution_1.WorkspaceVariableContribution);
    bind(quick_open_workspace_1.QuickOpenWorkspace).toSelf().inSingletonScope();
    bind(workspace_utils_1.WorkspaceUtils).toSelf().inSingletonScope();
    bind(common_2.WorkspaceFileService).toSelf().inSingletonScope();
    bind(common_2.UntitledWorkspaceService).toSelf().inSingletonScope();
    bind(workspace_schema_updater_1.WorkspaceSchemaUpdater).toSelf().inSingletonScope();
    bind(json_schema_store_1.JsonSchemaContribution).toService(workspace_schema_updater_1.WorkspaceSchemaUpdater);
    rebind(filepath_breadcrumbs_contribution_1.FilepathBreadcrumbsContribution).to(workspace_breadcrumbs_contribution_1.WorkspaceBreadcrumbsContribution).inSingletonScope();
    bind(workspace_trust_service_1.WorkspaceTrustService).toSelf().inSingletonScope();
    rebind(user_working_directory_provider_1.UserWorkingDirectoryProvider).to(workspace_user_working_directory_provider_1.WorkspaceUserWorkingDirectoryProvider).inSingletonScope();
    rebind(window_title_updater_1.WindowTitleUpdater).to(workspace_window_title_updater_1.WorkspaceWindowTitleUpdater).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-input-dialog.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-input-dialog.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceInputDialog = exports.WorkspaceInputDialogProps = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let WorkspaceInputDialogProps = class WorkspaceInputDialogProps extends browser_1.SingleTextInputDialogProps {
};
exports.WorkspaceInputDialogProps = WorkspaceInputDialogProps;
exports.WorkspaceInputDialogProps = WorkspaceInputDialogProps = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceInputDialogProps);
let WorkspaceInputDialog = class WorkspaceInputDialog extends browser_1.SingleTextInputDialog {
    constructor(props, labelProvider) {
        super(props);
        this.props = props;
        this.labelProvider = labelProvider;
        this.appendParentPath();
    }
    /**
     * Append the human-readable parent `path` to the dialog.
     * When possible, display the relative path, else display the full path (ex: workspace root).
     */
    appendParentPath() {
        // Compute the label for the parent URI.
        const label = this.labelProvider.getLongName(this.props.parentUri);
        const element = document.createElement('div');
        // Create the `folder` icon.
        const icon = document.createElement('i');
        icon.classList.add(...(0, browser_1.codiconArray)('folder'));
        icon.style.marginRight = '0.5em';
        icon.style.verticalAlign = 'middle';
        element.style.verticalAlign = 'middle';
        element.style.paddingBottom = '1em';
        element.title = this.props.parentUri.path.fsPath();
        element.appendChild(icon);
        element.appendChild(document.createTextNode(label));
        // Add the path and icon div before the `inputField`.
        this.contentNode.insertBefore(element, this.inputField);
    }
};
exports.WorkspaceInputDialog = WorkspaceInputDialog;
exports.WorkspaceInputDialog = WorkspaceInputDialog = tslib_1.__decorate([
    tslib_1.__param(0, (0, inversify_1.inject)(WorkspaceInputDialogProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(browser_1.LabelProvider)),
    tslib_1.__metadata("design:paramtypes", [WorkspaceInputDialogProps,
        browser_1.LabelProvider])
], WorkspaceInputDialog);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-storage-service.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-storage-service.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceStorageService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const storage_service_1 = __webpack_require__(/*! @theia/core/lib/browser/storage-service */ "../../node_modules/@theia/core/lib/browser/storage-service.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
/*
 * Prefixes any stored data with the current workspace path.
 */
let WorkspaceStorageService = class WorkspaceStorageService {
    init() {
        this.initialized = this.workspaceService.roots.then(() => {
            this.updatePrefix();
            this.workspaceService.onWorkspaceLocationChanged(() => this.updatePrefix());
        });
    }
    async setData(key, data) {
        if (!this.prefix) {
            await this.initialized;
        }
        const fullKey = this.prefixWorkspaceURI(key);
        return this.storageService.setData(fullKey, data);
    }
    async getData(key, defaultValue) {
        await this.initialized;
        const fullKey = this.prefixWorkspaceURI(key);
        return this.storageService.getData(fullKey, defaultValue);
    }
    prefixWorkspaceURI(originalKey) {
        return `${this.prefix}:${originalKey}`;
    }
    getPrefix(workspaceStat) {
        return workspaceStat ? workspaceStat.resource.toString() : '_global_';
    }
    updatePrefix() {
        this.prefix = this.getPrefix(this.workspaceService.workspace);
    }
};
exports.WorkspaceStorageService = WorkspaceStorageService;
tslib_1.__decorate([
    (0, inversify_1.inject)(storage_service_1.LocalStorageService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceStorageService.prototype, "storageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceStorageService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], WorkspaceStorageService.prototype, "init", null);
exports.WorkspaceStorageService = WorkspaceStorageService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceStorageService);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-preferences.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-trust-preferences.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindWorkspaceTrustPreferences = exports.createWorkspaceTrustPreferences = exports.WorkspaceTrustPreferences = exports.WorkspaceTrustPreferenceContribution = exports.workspaceTrustPreferenceSchema = exports.WorkspaceTrustPrompt = exports.WORKSPACE_TRUST_EMPTY_WINDOW = exports.WORKSPACE_TRUST_STARTUP_PROMPT = exports.WORKSPACE_TRUST_ENABLED = void 0;
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.WORKSPACE_TRUST_ENABLED = 'security.workspace.trust.enabled';
exports.WORKSPACE_TRUST_STARTUP_PROMPT = 'security.workspace.trust.startupPrompt';
exports.WORKSPACE_TRUST_EMPTY_WINDOW = 'security.workspace.trust.emptyWindow';
var WorkspaceTrustPrompt;
(function (WorkspaceTrustPrompt) {
    WorkspaceTrustPrompt["ALWAYS"] = "always";
    WorkspaceTrustPrompt["ONCE"] = "once";
    WorkspaceTrustPrompt["NEVER"] = "never";
})(WorkspaceTrustPrompt || (exports.WorkspaceTrustPrompt = WorkspaceTrustPrompt = {}));
exports.workspaceTrustPreferenceSchema = {
    type: 'object',
    scope: preferences_1.PreferenceScope.User,
    properties: {
        [exports.WORKSPACE_TRUST_ENABLED]: {
            description: nls_1.nls.localize('theia/workspace/trustEnabled', 'Controls whether or not workspace trust is enabled. If disabled, all workspaces are trusted.'),
            type: 'boolean',
            defaultValue: true
        },
        [exports.WORKSPACE_TRUST_STARTUP_PROMPT]: {
            description: nls_1.nls.localizeByDefault('Controls when the startup prompt to trust a workspace is shown.'),
            enum: Object.values(WorkspaceTrustPrompt),
            defaultValue: WorkspaceTrustPrompt.ALWAYS
        },
        [exports.WORKSPACE_TRUST_EMPTY_WINDOW]: {
            description: nls_1.nls.localize('theia/workspace/trustEmptyWindow', 'Controls whether or not the empty workspace is trusted by default.'),
            type: 'boolean',
            defaultValue: true
        }
    }
};
exports.WorkspaceTrustPreferenceContribution = Symbol('WorkspaceTrustPreferenceContribution');
exports.WorkspaceTrustPreferences = Symbol('WorkspaceTrustPreferences');
function createWorkspaceTrustPreferences(preferences, schema = exports.workspaceTrustPreferenceSchema) {
    return (0, preferences_1.createPreferenceProxy)(preferences, schema);
}
exports.createWorkspaceTrustPreferences = createWorkspaceTrustPreferences;
function bindWorkspaceTrustPreferences(bind) {
    bind(exports.WorkspaceTrustPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.WorkspaceTrustPreferenceContribution);
        return createWorkspaceTrustPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.WorkspaceTrustPreferenceContribution).toConstantValue({ schema: exports.workspaceTrustPreferenceSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.WorkspaceTrustPreferenceContribution);
}
exports.bindWorkspaceTrustPreferences = bindWorkspaceTrustPreferences;


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceTrustService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const preference_service_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-service */ "../../node_modules/@theia/core/lib/browser/preferences/preference-service.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "../../node_modules/@theia/core/lib/common/message-service.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const window_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
const workspace_trust_preferences_1 = __webpack_require__(/*! ./workspace-trust-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-preferences.js");
const frontend_application_config_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/frontend-application-config-provider */ "../../node_modules/@theia/core/lib/browser/frontend-application-config-provider.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const STORAGE_TRUSTED = 'trusted';
let WorkspaceTrustService = class WorkspaceTrustService {
    constructor() {
        this.workspaceTrust = new promise_util_1.Deferred();
    }
    init() {
        this.doInit();
    }
    async doInit() {
        await this.workspaceService.ready;
        await this.resolveWorkspaceTrust();
        this.preferences.onPreferenceChanged(change => this.handlePreferenceChange(change));
    }
    getWorkspaceTrust() {
        return this.workspaceTrust.promise;
    }
    async resolveWorkspaceTrust(givenTrust) {
        if (!this.isWorkspaceTrustResolved()) {
            const trust = givenTrust !== null && givenTrust !== void 0 ? givenTrust : await this.calculateWorkspaceTrust();
            if (trust !== undefined) {
                await this.storeWorkspaceTrust(trust);
                this.contextKeyService.setContext('isWorkspaceTrusted', trust);
                this.workspaceTrust.resolve(trust);
            }
        }
    }
    isWorkspaceTrustResolved() {
        return this.workspaceTrust.state !== 'unresolved';
    }
    async calculateWorkspaceTrust() {
        if (!this.workspaceTrustPref[workspace_trust_preferences_1.WORKSPACE_TRUST_ENABLED]) {
            // in VS Code if workspace trust is disabled, we implicitly trust the workspace
            return true;
        }
        if (this.workspaceTrustPref[workspace_trust_preferences_1.WORKSPACE_TRUST_EMPTY_WINDOW] && !this.workspaceService.workspace) {
            return true;
        }
        if (this.workspaceTrustPref[workspace_trust_preferences_1.WORKSPACE_TRUST_STARTUP_PROMPT] === workspace_trust_preferences_1.WorkspaceTrustPrompt.NEVER) {
            return false;
        }
        return this.loadWorkspaceTrust();
    }
    async loadWorkspaceTrust() {
        if (this.workspaceTrustPref[workspace_trust_preferences_1.WORKSPACE_TRUST_STARTUP_PROMPT] === workspace_trust_preferences_1.WorkspaceTrustPrompt.ONCE) {
            return this.storage.getData(STORAGE_TRUSTED);
        }
    }
    async storeWorkspaceTrust(trust) {
        if (this.workspaceTrustPref[workspace_trust_preferences_1.WORKSPACE_TRUST_STARTUP_PROMPT] === workspace_trust_preferences_1.WorkspaceTrustPrompt.ONCE) {
            return this.storage.setData(STORAGE_TRUSTED, trust);
        }
    }
    async handlePreferenceChange(change) {
        if (change.scope === preference_service_1.PreferenceScope.User) {
            if (change.preferenceName === workspace_trust_preferences_1.WORKSPACE_TRUST_STARTUP_PROMPT && change.newValue !== workspace_trust_preferences_1.WorkspaceTrustPrompt.ONCE) {
                this.storage.setData(STORAGE_TRUSTED, undefined);
            }
            if (change.preferenceName === workspace_trust_preferences_1.WORKSPACE_TRUST_ENABLED && this.isWorkspaceTrustResolved() && await this.confirmRestart()) {
                this.windowService.setSafeToShutDown();
                this.windowService.reload();
            }
            if (change.preferenceName === workspace_trust_preferences_1.WORKSPACE_TRUST_ENABLED || change.preferenceName === workspace_trust_preferences_1.WORKSPACE_TRUST_EMPTY_WINDOW) {
                this.resolveWorkspaceTrust();
            }
        }
    }
    async confirmRestart() {
        const shouldRestart = await new browser_1.ConfirmDialog({
            title: nls_1.nls.localizeByDefault('A setting has changed that requires a restart to take effect.'),
            msg: nls_1.nls.localizeByDefault('Press the restart button to restart {0} and enable the setting.', frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().applicationName),
            ok: nls_1.nls.localizeByDefault('Restart'),
            cancel: browser_1.Dialog.CANCEL,
        }).open();
        return shouldRestart === true;
    }
    async requestWorkspaceTrust() {
        if (!this.isWorkspaceTrustResolved()) {
            const isTrusted = await this.messageService.info(nls_1.nls.localize('theia/workspace/trustRequest', 'An extension requests workspace trust but the corresponding API is not yet fully supported. Do you want to trust this workspace?'), browser_1.Dialog.YES, browser_1.Dialog.NO);
            const trusted = isTrusted === browser_1.Dialog.YES;
            this.resolveWorkspaceTrust(trusted);
        }
        return this.workspaceTrust.promise;
    }
};
exports.WorkspaceTrustService = WorkspaceTrustService;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceTrustService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_service_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceTrustService.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.StorageService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceTrustService.prototype, "storage", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    tslib_1.__metadata("design:type", message_service_1.MessageService)
], WorkspaceTrustService.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_trust_preferences_1.WorkspaceTrustPreferences),
    tslib_1.__metadata("design:type", Object)
], WorkspaceTrustService.prototype, "workspaceTrustPref", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceTrustService.prototype, "windowService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceTrustService.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], WorkspaceTrustService.prototype, "init", null);
exports.WorkspaceTrustService = WorkspaceTrustService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceTrustService);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-uri-contribution.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-uri-contribution.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceUriLabelProviderContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "../../node_modules/@theia/core/lib/browser/label-provider.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const files_1 = __webpack_require__(/*! @theia/filesystem/lib/common/files */ "../../node_modules/@theia/filesystem/lib/common/files.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const workspace_variable_contribution_1 = __webpack_require__(/*! ./workspace-variable-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-variable-contribution.js");
let WorkspaceUriLabelProviderContribution = class WorkspaceUriLabelProviderContribution extends label_provider_1.DefaultUriLabelProviderContribution {
    init() {
        // no-op, backward compatibility
    }
    canHandle(element) {
        if ((element instanceof uri_1.default && element.scheme === 'file' || label_provider_1.URIIconReference.is(element) || files_1.FileStat.is(element))) {
            return 10;
        }
        return 0;
    }
    getIcon(element) {
        return super.getIcon(this.asURIIconReference(element));
    }
    getName(element) {
        return super.getName(this.asURIIconReference(element));
    }
    /**
     * trims the workspace root from a file uri, if it is a child.
     */
    getLongName(element) {
        const uri = this.getUri(element);
        if (uri) {
            const formatting = this.findFormatting(uri);
            if (formatting) {
                return this.formatUri(uri, formatting);
            }
        }
        const relativePath = uri && this.workspaceVariable.getWorkspaceRelativePath(uri);
        return relativePath || super.getLongName(this.asURIIconReference(element));
    }
    getDetails(element) {
        const uri = this.getUri(element);
        if (!uri) {
            return this.getLongName(element);
        }
        // Parent in order to omit the name - that's what comes out of `getName`, and `getDetails` should supplement, not duplicate.
        const relativePath = uri && this.workspaceVariable.getWorkspaceRelativePath(uri.parent);
        if (relativePath !== undefined) {
            const prefix = this.workspaceService.tryGetRoots().length > 1 ? this.getName(this.workspaceVariable.getWorkspaceRootUri(uri)) : '';
            const separator = prefix && relativePath ? ' • ' : '';
            return prefix + separator + relativePath;
        }
        return this.getLongName(uri.parent);
    }
    asURIIconReference(element) {
        var _a;
        if (files_1.FileStat.is(element)) {
            return label_provider_1.URIIconReference.create(element.isDirectory ? 'folder' : 'file', element.resource);
        }
        const uri = this.getUri(element);
        if (uri && ((_a = this.workspaceVariable.getWorkspaceRootUri(uri)) === null || _a === void 0 ? void 0 : _a.isEqual(uri))) {
            return label_provider_1.URIIconReference.create('folder', uri);
        }
        return element;
    }
    getUri(element) {
        if (files_1.FileStat.is(element)) {
            return element.resource;
        }
        return super.getUri(element);
    }
};
exports.WorkspaceUriLabelProviderContribution = WorkspaceUriLabelProviderContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_variable_contribution_1.WorkspaceVariableContribution),
    tslib_1.__metadata("design:type", workspace_variable_contribution_1.WorkspaceVariableContribution)
], WorkspaceUriLabelProviderContribution.prototype, "workspaceVariable", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceUriLabelProviderContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], WorkspaceUriLabelProviderContribution.prototype, "init", null);
exports.WorkspaceUriLabelProviderContribution = WorkspaceUriLabelProviderContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceUriLabelProviderContribution);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-user-working-directory-provider.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-user-working-directory-provider.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceUserWorkingDirectoryProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const user_working_directory_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/user-working-directory-provider */ "../../node_modules/@theia/core/lib/browser/user-working-directory-provider.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
let WorkspaceUserWorkingDirectoryProvider = class WorkspaceUserWorkingDirectoryProvider extends user_working_directory_provider_1.UserWorkingDirectoryProvider {
    async getUserWorkingDir() {
        var _a, _b, _c;
        return (_c = (_b = (_a = await this.getFromSelection()) !== null && _a !== void 0 ? _a : await this.getFromLastOpenResource()) !== null && _b !== void 0 ? _b : await this.getFromWorkspace()) !== null && _c !== void 0 ? _c : this.getFromUserHome();
    }
    getFromWorkspace() {
        var _a;
        return (_a = this.workspaceService.tryGetRoots()[0]) === null || _a === void 0 ? void 0 : _a.resource;
    }
    async ensureIsDirectory(uri) {
        if (uri) {
            const asFile = uri.withScheme('file');
            const stat = await this.fileService.resolve(asFile)
                .catch(() => this.fileService.resolve(asFile.parent))
                .catch(() => undefined);
            return (stat === null || stat === void 0 ? void 0 : stat.isDirectory) ? stat.resource : stat === null || stat === void 0 ? void 0 : stat.resource.parent;
        }
    }
};
exports.WorkspaceUserWorkingDirectoryProvider = WorkspaceUserWorkingDirectoryProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceUserWorkingDirectoryProvider.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceUserWorkingDirectoryProvider.prototype, "fileService", void 0);
exports.WorkspaceUserWorkingDirectoryProvider = WorkspaceUserWorkingDirectoryProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceUserWorkingDirectoryProvider);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-utils.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-utils.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceUtils = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
/**
 * Collection of workspace utility functions
 * @class
 */
let WorkspaceUtils = class WorkspaceUtils {
    /**
     * Determine if root directory exists
     * for a given array of URIs
     * @param uris
     */
    containsRootDirectory(uris) {
        // obtain all roots URIs for a given workspace
        const rootUris = this.workspaceService.tryGetRoots().map(root => root.resource);
        // return true if at least a single URI is a root directory
        return rootUris.some(rootUri => uris.some(uri => uri.isEqualOrParent(rootUri)));
    }
};
exports.WorkspaceUtils = WorkspaceUtils;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceUtils.prototype, "workspaceService", void 0);
exports.WorkspaceUtils = WorkspaceUtils = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceUtils);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-variable-contribution.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-variable-contribution.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceVariableContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const path_1 = __webpack_require__(/*! @theia/core/lib/common/path */ "../../node_modules/@theia/core/lib/common/path.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
let WorkspaceVariableContribution = class WorkspaceVariableContribution {
    constructor() {
        this.recentlyVisibleIds = [];
    }
    init() {
        this.shell.onDidChangeCurrentWidget(() => this.updateCurrentWidget());
        this.widgetManager.onDidCreateWidget(({ widget }) => {
            if (browser_1.NavigatableWidget.is(widget)) {
                widget.onDidChangeVisibility(() => {
                    if (widget.isVisible) {
                        this.addRecentlyVisible(widget);
                    }
                    else {
                        this.removeRecentlyVisible(widget);
                    }
                    this.updateCurrentWidget();
                });
                widget.onDidDispose(() => {
                    this.removeRecentlyVisible(widget);
                    this.updateCurrentWidget();
                });
            }
        });
        for (const widget of this.shell.widgets) {
            if (browser_1.NavigatableWidget.is(widget) && widget.isVisible) {
                this.addRecentlyVisible(widget);
            }
        }
        this.updateCurrentWidget();
    }
    get recentlyVisible() {
        const id = this.recentlyVisibleIds[0];
        const widget = id && this.shell.getWidgetById(id) || undefined;
        if (browser_1.NavigatableWidget.is(widget)) {
            return widget;
        }
        return undefined;
    }
    addRecentlyVisible(widget) {
        this.removeRecentlyVisible(widget);
        this.recentlyVisibleIds.unshift(widget.id);
    }
    removeRecentlyVisible(widget) {
        const index = this.recentlyVisibleIds.indexOf(widget.id);
        if (index !== -1) {
            this.recentlyVisibleIds.splice(index, 1);
        }
    }
    updateCurrentWidget() {
        const { currentWidget } = this.shell;
        if (browser_1.NavigatableWidget.is(currentWidget)) {
            this.currentWidget = currentWidget;
        }
        else if (!this.currentWidget || !this.currentWidget.isVisible) {
            this.currentWidget = this.recentlyVisible;
        }
    }
    registerVariables(variables) {
        this.registerWorkspaceRootVariables(variables);
        variables.registerVariable({
            name: 'file',
            description: 'The path of the currently opened file',
            resolve: () => {
                const uri = this.getResourceUri();
                return uri && this.fileService.fsPath(uri);
            }
        });
        variables.registerVariable({
            name: 'fileBasename',
            description: 'The basename of the currently opened file',
            resolve: () => {
                const uri = this.getResourceUri();
                return uri && uri.path.base;
            }
        });
        variables.registerVariable({
            name: 'fileBasenameNoExtension',
            description: "The currently opened file's name without extension",
            resolve: () => {
                const uri = this.getResourceUri();
                return uri && uri.path.name;
            }
        });
        variables.registerVariable({
            name: 'fileDirname',
            description: "The name of the currently opened file's directory",
            resolve: () => {
                const uri = this.getResourceUri();
                return uri && uri.path.dir.toString();
            }
        });
        variables.registerVariable({
            name: 'fileExtname',
            description: 'The extension of the currently opened file',
            resolve: () => {
                const uri = this.getResourceUri();
                return uri && uri.path.ext;
            }
        });
    }
    registerWorkspaceRootVariables(variables) {
        const scoped = (variable) => ({
            name: variable.name,
            description: variable.description,
            resolve: (context, workspaceRootName) => {
                const workspaceRoot = workspaceRootName && this.workspaceService.tryGetRoots().find(r => r.resource.path.name === workspaceRootName);
                return variable.resolve(workspaceRoot ? workspaceRoot.resource : context);
            }
        });
        variables.registerVariable(scoped({
            name: 'workspaceRoot',
            description: 'The path of the workspace root folder',
            resolve: (context) => {
                const uri = this.getWorkspaceRootUri(context);
                return uri && this.fileService.fsPath(uri);
            }
        }));
        variables.registerVariable(scoped({
            name: 'workspaceFolder',
            description: 'The path of the workspace root folder',
            resolve: (context) => {
                const uri = this.getWorkspaceRootUri(context);
                return uri && this.fileService.fsPath(uri);
            }
        }));
        variables.registerVariable(scoped({
            name: 'workspaceRootFolderName',
            description: 'The name of the workspace root folder',
            resolve: (context) => {
                const uri = this.getWorkspaceRootUri(context);
                return uri && uri.displayName;
            }
        }));
        variables.registerVariable(scoped({
            name: 'workspaceFolderBasename',
            description: 'The name of the workspace root folder',
            resolve: (context) => {
                const uri = this.getWorkspaceRootUri(context);
                return uri && uri.displayName;
            }
        }));
        variables.registerVariable(scoped({
            name: 'cwd',
            description: "The task runner's current working directory on startup",
            resolve: (context) => {
                const uri = this.getWorkspaceRootUri(context);
                return (uri && this.fileService.fsPath(uri)) || '';
            }
        }));
        variables.registerVariable(scoped({
            name: 'relativeFile',
            description: "The currently opened file's path relative to the workspace root",
            resolve: (context) => {
                const uri = this.getResourceUri();
                return uri && this.getWorkspaceRelativePath(uri, context);
            }
        }));
        variables.registerVariable(scoped({
            name: 'relativeFileDirname',
            description: "The current opened file's dirname relative to ${workspaceFolder}",
            resolve: (context) => {
                const uri = this.getResourceUri();
                const relativePath = uri && this.getWorkspaceRelativePath(uri, context);
                return relativePath && new path_1.Path(relativePath).dir.toString();
            }
        }));
    }
    getWorkspaceRootUri(uri = this.getResourceUri()) {
        return this.workspaceService.getWorkspaceRootUri(uri);
    }
    getResourceUri() {
        return this.currentWidget && this.currentWidget.getResourceUri();
    }
    getWorkspaceRelativePath(uri, context) {
        const workspaceRootUri = this.getWorkspaceRootUri(context || uri);
        const path = workspaceRootUri && workspaceRootUri.path.relative(uri.path);
        return path && path.toString();
    }
};
exports.WorkspaceVariableContribution = WorkspaceVariableContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceVariableContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], WorkspaceVariableContribution.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceVariableContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    tslib_1.__metadata("design:type", browser_1.WidgetManager)
], WorkspaceVariableContribution.prototype, "widgetManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], WorkspaceVariableContribution.prototype, "init", null);
exports.WorkspaceVariableContribution = WorkspaceVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/workspace-window-title-updater.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/workspace-window-title-updater.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceWindowTitleUpdater = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const window_title_updater_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-title-updater */ "../../node_modules/@theia/core/lib/browser/window/window-title-updater.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const workspace_service_1 = __webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const navigatable_1 = __webpack_require__(/*! @theia/core/lib/browser/navigatable */ "../../node_modules/@theia/core/lib/browser/navigatable.js");
let WorkspaceWindowTitleUpdater = class WorkspaceWindowTitleUpdater extends window_title_updater_1.WindowTitleUpdater {
    updateTitleWidget(widget) {
        super.updateTitleWidget(widget);
        let folderName;
        let folderPath;
        if (navigatable_1.Navigatable.is(widget)) {
            const folder = this.workspaceService.getWorkspaceRootUri(widget.getResourceUri());
            if (folder) {
                folderName = this.labelProvider.getName(folder);
                folderPath = folder.path.toString();
            }
        }
        this.windowTitleService.update({
            folderName,
            folderPath
        });
    }
};
exports.WorkspaceWindowTitleUpdater = WorkspaceWindowTitleUpdater;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceWindowTitleUpdater.prototype, "workspaceService", void 0);
exports.WorkspaceWindowTitleUpdater = WorkspaceWindowTitleUpdater = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceWindowTitleUpdater);


/***/ }),

/***/ "../../node_modules/filename-reserved-regex/index.js":
/*!***********************************************************!*\
  !*** ../../node_modules/filename-reserved-regex/index.js ***!
  \***********************************************************/
/***/ ((module) => {


/* eslint-disable no-control-regex */
// TODO: remove parens when Node.js 6 is targeted. Node.js 4 barfs at it.
module.exports = () => (/[<>:"\/\\|?*\x00-\x1F]/g);
module.exports.windowsNames = () => (/^(con|prn|aux|nul|com[0-9]|lpt[0-9])$/i);


/***/ }),

/***/ "../../node_modules/valid-filename/index.js":
/*!**************************************************!*\
  !*** ../../node_modules/valid-filename/index.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


const filenameReservedRegex = __webpack_require__(/*! filename-reserved-regex */ "../../node_modules/filename-reserved-regex/index.js");

module.exports = str => {
	if (!str || str.length > 255) {
		return false;
	}

	if (filenameReservedRegex().test(str) || filenameReservedRegex.windowsNames().test(str)) {
		return false;
	}

	if (/^\.\.?$/.test(str)) {
		return false;
	}

	return true;
};


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_workspace_lib_browser_workspace-frontend-module_js.js.map