"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VarManager = void 0;
const var_1 = require("./mi/var");
class VarManager {
    constructor(gdb) {
        this.gdb = gdb;
        this.variableMap = new Map();
        this.gdb = gdb;
    }
    getKey(frameRef, depth) {
        return `frame${frameRef.frameId}_thread${frameRef.threadId}_depth${depth}`;
    }
    getVars(frameRef, depth) {
        return frameRef
            ? this.variableMap.get(this.getKey(frameRef, depth))
            : undefined;
    }
    getVar(frameRef, depth, expression, type) {
        const vars = this.getVars(frameRef, depth);
        if (vars) {
            for (const varobj of vars) {
                if (varobj.expression === expression) {
                    if (type !== 'registers') {
                        type = 'local';
                    }
                    if (type === varobj.varType) {
                        return varobj;
                    }
                }
            }
        }
        return;
    }
    getVarByName(frameRef, depth, varname) {
        const vars = this.getVars(frameRef, depth);
        if (vars) {
            for (const varobj of vars) {
                if (varobj.varname === varname) {
                    return varobj;
                }
            }
        }
        return;
    }
    addVar(frameRef, depth, expression, isVar, isChild, varCreateResponse, type) {
        let vars = frameRef
            ? this.variableMap.get(this.getKey(frameRef, depth))
            : undefined;
        if (!vars) {
            vars = [];
            if (frameRef) {
                this.variableMap.set(this.getKey(frameRef, depth), vars);
            }
        }
        const varobj = {
            varname: varCreateResponse.name,
            expression,
            numchild: varCreateResponse.numchild,
            children: [],
            value: varCreateResponse.value,
            type: varCreateResponse.type,
            isVar,
            isChild,
            varType: type ? type : 'local',
        };
        vars.push(varobj);
        return varobj;
    }
    removeVar(frameRef, depth, varname) {
        return __awaiter(this, void 0, void 0, function* () {
            let deleteme;
            const vars = frameRef
                ? this.variableMap.get(this.getKey(frameRef, depth))
                : undefined;
            if (vars) {
                for (const varobj of vars) {
                    if (varobj.varname === varname) {
                        deleteme = varobj;
                        break;
                    }
                }
                if (deleteme) {
                    yield (0, var_1.sendVarDelete)(this.gdb, { varname: deleteme.varname });
                    vars.splice(vars.indexOf(deleteme), 1);
                    for (const child of deleteme.children) {
                        yield this.removeVar(frameRef, depth, child.varname);
                    }
                }
            }
        });
    }
    updateVar(frameRef, depth, varobj) {
        return __awaiter(this, void 0, void 0, function* () {
            let returnVar = varobj;
            const vup = yield (0, var_1.sendVarUpdate)(this.gdb, { name: varobj.varname });
            const update = vup.changelist[0];
            if (update) {
                if (update.in_scope === 'true') {
                    if (update.name === varobj.varname) {
                        // don't update the parent value to a child's value
                        varobj.value = update.value;
                    }
                }
                else {
                    this.removeVar(frameRef, depth, varobj.varname);
                    yield (0, var_1.sendVarDelete)(this.gdb, { varname: varobj.varname });
                    const createResponse = yield (0, var_1.sendVarCreate)(this.gdb, {
                        frame: 'current',
                        expression: varobj.expression,
                        frameRef,
                    });
                    returnVar = this.addVar(frameRef, depth, varobj.expression, varobj.isVar, varobj.isChild, createResponse);
                }
            }
            return Promise.resolve(returnVar);
        });
    }
}
exports.VarManager = VarManager;
//# sourceMappingURL=varManager.js.map